/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.wildfly.common.Assert;
import org.wildfly.security.asn1.DEREncoder;
import org.wildfly.security.x500.X500AttributeTypeAndValue;

public final class X500PrincipalBuilder {
    private final List<Collection<X500AttributeTypeAndValue>> items = new ArrayList<Collection<X500AttributeTypeAndValue>>();

    public X500PrincipalBuilder addItem(X500AttributeTypeAndValue attributeTypeAndValue) {
        Assert.checkNotNullParam((String)"attributeTypeAndValue", (Object)attributeTypeAndValue);
        this.items.add(Collections.singletonList(attributeTypeAndValue));
        return this;
    }

    public X500PrincipalBuilder addCompoundItem(Collection<X500AttributeTypeAndValue> attributeTypeAndValues) {
        Assert.checkNotNullParam((String)"attributeTypeAndValues", attributeTypeAndValues);
        Assert.checkNotEmptyParam((String)"attributeTypeAndValues", attributeTypeAndValues);
        this.items.add(attributeTypeAndValues);
        return this;
    }

    public X500Principal build() throws IllegalArgumentException {
        DEREncoder derEncoder = new DEREncoder();
        derEncoder.startSequence();
        for (Collection<X500AttributeTypeAndValue> itemSet : this.items) {
            derEncoder.startSet();
            for (X500AttributeTypeAndValue item : itemSet) {
                item.encodeTo(derEncoder);
            }
            derEncoder.endSet();
        }
        derEncoder.endSequence();
        return new X500Principal(derEncoder.getEncoded());
    }
}

