/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.wildfly.common.Assert;
import org.wildfly.security.x500._private.ElytronMessages;

public final class X500 {
    public static final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];
    public static final String OID_AT = "2.5.4";
    public static final String OID_AT_COMMON_NAME = "2.5.4.3";
    public static final String OID_AT_SURNAME = "2.5.4.4";
    public static final String OID_AT_SERIAL_NUMBER = "2.5.4.5";
    public static final String OID_AT_COUNTRY_NAME = "2.5.4.6";
    public static final String OID_AT_LOCALITY_NAME = "2.5.4.7";
    public static final String OID_AT_STATE_OR_PROVINCE_NAME = "2.5.4.8";
    public static final String OID_AT_STREET_ADDRESS = "2.5.4.9";
    public static final String OID_AT_ORGANIZATION_NAME = "2.5.4.10";
    public static final String OID_AT_ORGANIZATIONAL_UNIT_NAME = "2.5.4.11";
    public static final String OID_AT_TITLE = "2.5.4.12";
    public static final String OID_AT_DESCRIPTION = "2.5.4.13";
    public static final String OID_AT_BUSINESS_CATEGORY = "2.5.4.15";
    public static final String OID_AT_TELEPHONE_NUMBER = "2.5.4.20";
    public static final String OID_AT_FAX_NUMBER = "2.5.4.23";
    public static final String OID_AT_NAME = "2.5.4.41";
    public static final String OID_AT_GIVEN_NAME = "2.5.4.42";
    public static final String OID_AT_INITIALS = "2.5.4.43";
    public static final String OID_AT_GENERATION_QUALIFIER = "2.5.4.44";
    public static final String OID_AT_DN_QUALIFIER = "2.5.4.46";
    public static final String OID_AT_HOUSE_IDENTIFIER = "2.5.4.51";
    public static final String OID_AT_PSEUDONYM = "2.5.4.65";
    public static final String OID_UID = "0.9.2342.19200300.100.1.1";
    public static final String OID_DC = "0.9.2342.19200300.100.1.25";
    public static final String OID_CE = "2.5.29";
    public static final String OID_CE_SUBJECT_DIRECTORY_ATTRIBUTES = "2.5.29.9";
    public static final String OID_CE_SUBJECT_KEY_IDENTIFIER = "2.5.29.14";
    public static final String OID_CE_KEY_USAGE = "2.5.29.15";
    public static final String OID_CE_PRIVATE_KEY_USAGE_PERIOD = "2.5.29.16";
    public static final String OID_CE_SUBJECT_ALT_NAME = "2.5.29.17";
    public static final String OID_CE_ISSUER_ALT_NAME = "2.5.29.18";
    public static final String OID_CE_BASIC_CONSTRAINTS = "2.5.29.19";
    public static final String OID_CE_CRL_NUMBER = "2.5.29.20";
    public static final String OID_CE_CRL_REASONS = "2.5.29.21";
    public static final String OID_CE_HOLD_INSTRUCTION_CODE = "2.5.29.23";
    public static final String OID_CE_INVALIDITY_DATE = "2.5.29.24";
    public static final String OID_CE_DELTA_CLR_INDICATOR = "2.5.29.27";
    public static final String OID_CE_ISSUING_DISTRIBUTION_POINT = "2.5.29.28";
    public static final String OID_CE_CERTIFICATE_ISSUER = "2.5.29.29";
    public static final String OID_CE_NAME_CONSTRAINTS = "2.5.29.30";
    public static final String OID_CE_CRL_DISTRIBUTION_POINTS = "2.5.29.31";
    public static final String OID_CE_CERTIFICATE_POLICIES = "2.5.29.32";
    public static final String OID_CE_POLICY_MAPPINGS = "2.5.29.33";
    public static final String OID_CE_AUTHORITY_KEY_IDENTIFIER = "2.5.29.35";
    public static final String OID_CE_POLICY_CONSTRAINTS = "2.5.29.36";
    public static final String OID_CE_EXT_KEY_USAGE = "2.5.29.37";
    public static final String OID_CE_FRESHEST_CRL = "2.5.29.46";
    public static final String OID_CE_INHIBIT_ANY_POLICY = "2.5.29.54";
    public static final String OID_PKIX = "1.3.6.1.5.5.7";
    public static final String OID_PE = "1.3.6.1.5.5.7.1";
    public static final String OID_QT = "1.3.6.1.5.5.7.2";
    public static final String OID_KP = "1.3.6.1.5.5.7.3";
    public static final String OID_AD = "1.3.6.1.5.5.7.48";
    public static final String OID_PE_AUTHORITY_INFO_ACCESS = "1.3.6.1.5.5.7.1.1";
    public static final String OID_PE_SUBJECT_INFO_ACCESS = "1.3.6.1.5.5.7.1.11";
    public static final String OID_QT_CPS = "1.3.6.1.5.5.7.2.1";
    public static final String OID_QT_UNOTICE = "1.3.6.1.5.5.7.2.2";
    public static final String OID_KP_SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    public static final String OID_KP_CLIENT_AUTH = "1.3.6.1.5.5.7.3.2";
    public static final String OID_KP_CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    public static final String OID_KP_EMAIL_PROTECTION = "1.3.6.1.5.5.7.3.4";
    public static final String OID_KP_TIME_STAMPING = "1.3.6.1.5.5.7.3.8";
    public static final String OID_KP_OCSP_SIGNING = "1.3.6.1.5.5.7.3.9";
    public static final String OID_AD_OCSP = "1.3.6.1.5.5.7.48.1";
    public static final String OID_AD_CA_ISSUERS = "1.3.6.1.5.5.7.48.2";
    public static final String OID_AD_TIME_STAMPING = "1.3.6.1.5.5.7.48.3";
    public static final String OID_AD_CA_REPOSITORY = "1.3.6.1.5.5.7.48.5";
    public static final String OID_HOLD_INSTRUCTION = "2.2.840.10040.2";
    @Deprecated
    public static final String OID_HOLD_INSTRUCTION_NONE = "2.2.840.10040.2.1";
    public static final String OID_HOLD_INSTRUCTION_CALL_ISSUER = "2.2.840.10040.2.2";
    public static final String OID_HOLD_INSTRUCTION_REJECT = "2.2.840.10040.2.3";

    private X500() {
    }

    public static X509Certificate[] asX509CertificateArray(Object[] certificates) throws ArrayStoreException {
        if (certificates.length == 0) {
            return NO_CERTIFICATES;
        }
        if (certificates instanceof X509Certificate[]) {
            return (X509Certificate[])certificates;
        }
        return (X509Certificate[])Arrays.copyOf(certificates, certificates.length, X509Certificate[].class);
    }

    public static X509Certificate[] asOrderedX509CertificateChain(PublicKey firstPublicKey, Certificate[] certificates) throws IllegalArgumentException {
        Certificate[] x509Certificates;
        Assert.checkNotNullParam((String)"firstPublicKey", (Object)firstPublicKey);
        Assert.checkNotNullParam((String)"certificates", (Object)certificates);
        try {
            x509Certificates = X500.asX509CertificateArray(certificates);
        }
        catch (ArrayStoreException e) {
            throw ElytronMessages.log.nonX509CertificateInCertificateArray();
        }
        boolean foundFirstCertificate = false;
        for (int i = 0; i < x509Certificates.length; ++i) {
            if (!x509Certificates[i].getPublicKey().equals(firstPublicKey)) continue;
            foundFirstCertificate = true;
            X500.swapCertificates(x509Certificates, 0, i);
            break;
        }
        if (!foundFirstCertificate) {
            throw ElytronMessages.log.startingPublicKeyNotFoundInCertificateArray();
        }
        Certificate currentCertificate = x509Certificates[0];
        for (int i = 1; i < x509Certificates.length - 1; ++i) {
            boolean issuerCertificateFound = false;
            for (int j = i; j < x509Certificates.length; ++j) {
                if (!X500.issuedBy(currentCertificate, (X509Certificate)x509Certificates[j])) continue;
                X500.swapCertificates(x509Certificates, i, j);
                issuerCertificateFound = true;
                currentCertificate = x509Certificates[i];
                break;
            }
            if (issuerCertificateFound) continue;
            throw ElytronMessages.log.incompleteCertificateArray();
        }
        return x509Certificates;
    }

    public static X509Certificate[] createX509CertificateChain(X509Certificate firstCertificate, HashMap<Principal, HashSet<X509Certificate>> certificatesMap) throws IllegalArgumentException {
        Assert.checkNotNullParam((String)"firstCertificate", (Object)firstCertificate);
        Assert.checkNotNullParam((String)"certificatesMap", certificatesMap);
        ArrayList<X509Certificate> certificateChain = new ArrayList<X509Certificate>();
        if (X500.createX509CertificateChain(firstCertificate, certificateChain, certificatesMap)) {
            Collections.reverse(certificateChain);
            return certificateChain.toArray(new X509Certificate[certificateChain.size()]);
        }
        throw ElytronMessages.log.unableToCreateCertificateChainFromCertificateMap();
    }

    private static void swapCertificates(Certificate[] certificates, int i, int j) {
        Certificate tempCertificate = certificates[i];
        certificates[i] = certificates[j];
        certificates[j] = tempCertificate;
    }

    private static boolean issuedBy(X509Certificate certificate, X509Certificate issuer) {
        if (issuer.getSubjectDN().equals(certificate.getIssuerDN())) {
            try {
                certificate.verify(issuer.getPublicKey());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private static boolean createX509CertificateChain(X509Certificate firstCertificate, ArrayList<X509Certificate> certificateChain, HashMap<Principal, HashSet<X509Certificate>> certificatesMap) {
        if (X500.issuedBy(firstCertificate, firstCertificate)) {
            certificateChain.add(firstCertificate);
            return true;
        }
        HashSet<X509Certificate> issuerCertificates = certificatesMap.get(firstCertificate.getIssuerDN());
        if (issuerCertificates == null || issuerCertificates.isEmpty()) {
            return false;
        }
        for (X509Certificate issuerCertificate : issuerCertificates) {
            if (!X500.issuedBy(firstCertificate, issuerCertificate) || !X500.createX509CertificateChain(issuerCertificate, certificateChain, certificatesMap)) continue;
            certificateChain.add(firstCertificate);
            return true;
        }
        return false;
    }
}

