/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert.util;

import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.ECParameterSpec;
import org.wildfly.security.asn1.DERDecoder;
import org.wildfly.security.x500.cert.util.ElytronMessages;

public final class KeyUtil {
    public static String getDefaultCompatibleSignatureAlgorithmName(PrivateKey privateKey) throws IllegalArgumentException {
        int keySize = KeyUtil.getKeySize(privateKey);
        if (keySize == -1) {
            throw ElytronMessages.log.unableToDetermineKeySize();
        }
        return KeyUtil.getDefaultCompatibleSignatureAlgorithmName(privateKey.getAlgorithm(), keySize);
    }

    public static String getDefaultCompatibleSignatureAlgorithmName(String keyAlgorithmName, int keySize) {
        String messageDigestAlgorithmName = KeyUtil.getDefaultMessageDigestAlgorithmName(keyAlgorithmName, keySize);
        if (messageDigestAlgorithmName == null) {
            return null;
        }
        switch (keyAlgorithmName) {
            case "DSA": {
                return messageDigestAlgorithmName + "withDSA";
            }
            case "RSA": {
                return messageDigestAlgorithmName + "withRSA";
            }
            case "EC": {
                return messageDigestAlgorithmName + "withECDSA";
            }
        }
        return null;
    }

    private static String getDefaultMessageDigestAlgorithmName(String keyAlgorithmName, int keySize) {
        switch (keyAlgorithmName) {
            case "DSA": {
                return "SHA256";
            }
            case "RSA": {
                if (keySize <= 3072) {
                    return "SHA256";
                }
                if (keySize <= 7680) {
                    return "SHA384";
                }
                return "SHA512";
            }
            case "EC": {
                if (keySize <= 383) {
                    return "SHA256";
                }
                if (keySize <= 511) {
                    return "SHA384";
                }
                return "SHA512";
            }
        }
        return null;
    }

    public static int getKeySize(Key key) {
        if (key instanceof ECKey) {
            ECParameterSpec params = ((ECKey)((Object)key)).getParams();
            if (params != null) {
                return params.getOrder().bitLength();
            }
        } else if (key instanceof DSAKey) {
            DSAParams params = ((DSAKey)((Object)key)).getParams();
            if (params != null) {
                return params.getP().bitLength();
            }
        } else if (key instanceof RSAKey) {
            return ((RSAKey)((Object)key)).getModulus().bitLength();
        }
        return -1;
    }

    public static byte[] getKeyIdentifier(PublicKey publicKey) {
        DERDecoder decoder = new DERDecoder(publicKey.getEncoded());
        decoder.startSequence();
        decoder.skipElement();
        byte[] subjectPublicKey = decoder.decodeBitString();
        decoder.endSequence();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(subjectPublicKey);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

