package org.wildfly.security.ssl;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.security.cert.CertificateException;
import org.wildfly.security.auth.server.RealmUnavailableException;
import java.lang.String;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.security.Principal;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-04-10T15:28:17-0400")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void warnInvalidStringCountForMechanismDatabaseEntry(final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidStringCountForMechanismDatabaseEntry$str(), name);
    }
    protected String warnInvalidStringCountForMechanismDatabaseEntry$str() {
        return "ELY01066: Invalid string count for mechanism database entry \"%s\"";
    }
    @Override
    public final void warnInvalidKeyExchangeForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidKeyExchangeForMechanismDatabaseEntry$str(), value, name);
    }
    protected String warnInvalidKeyExchangeForMechanismDatabaseEntry$str() {
        return "ELY01067: Invalid key exchange \"%s\" for mechanism database entry \"%s\"";
    }
    @Override
    public final void warnInvalidAuthenticationForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidAuthenticationForMechanismDatabaseEntry$str(), value, name);
    }
    protected String warnInvalidAuthenticationForMechanismDatabaseEntry$str() {
        return "ELY01068: Invalid authentication \"%s\" for mechanism database entry \"%s\"";
    }
    @Override
    public final void warnInvalidEncryptionForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidEncryptionForMechanismDatabaseEntry$str(), value, name);
    }
    protected String warnInvalidEncryptionForMechanismDatabaseEntry$str() {
        return "ELY01069: Invalid encryption \"%s\" for mechanism database entry \"%s\"";
    }
    @Override
    public final void warnInvalidDigestForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidDigestForMechanismDatabaseEntry$str(), value, name);
    }
    protected String warnInvalidDigestForMechanismDatabaseEntry$str() {
        return "ELY01070: Invalid digest \"%s\" for mechanism database entry \"%s\"";
    }
    @Override
    public final void warnInvalidProtocolForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidProtocolForMechanismDatabaseEntry$str(), value, name);
    }
    protected String warnInvalidProtocolForMechanismDatabaseEntry$str() {
        return "ELY01071: Invalid protocol \"%s\" for mechanism database entry \"%s\"";
    }
    @Override
    public final void warnInvalidLevelForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidLevelForMechanismDatabaseEntry$str(), value, name);
    }
    protected String warnInvalidLevelForMechanismDatabaseEntry$str() {
        return "ELY01072: Invalid level \"%s\" for mechanism database entry \"%s\"";
    }
    @Override
    public final void warnInvalidStrengthBitsForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidStrengthBitsForMechanismDatabaseEntry$str(), value, name);
    }
    protected String warnInvalidStrengthBitsForMechanismDatabaseEntry$str() {
        return "ELY01073: Invalid strength bits \"%s\" for mechanism database entry \"%s\"";
    }
    @Override
    public final void warnInvalidAlgorithmBitsForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidAlgorithmBitsForMechanismDatabaseEntry$str(), value, name);
    }
    protected String warnInvalidAlgorithmBitsForMechanismDatabaseEntry$str() {
        return "ELY01074: Invalid algorithm bits \"%s\" for mechanism database entry \"%s\"";
    }
    @Override
    public final void warnInvalidDuplicateMechanismDatabaseEntry(final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidDuplicateMechanismDatabaseEntry$str(), name);
    }
    protected String warnInvalidDuplicateMechanismDatabaseEntry$str() {
        return "ELY01075: Invalid duplicate mechanism database entry \"%s\"";
    }
    @Override
    public final void warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry(final String alias, final String name, final String originalName) {
        super.log.logf(FQCN, WARN, null, warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry$str(), alias, name, originalName);
    }
    protected String warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry$str() {
        return "ELY01076: Invalid duplicate OpenSSL-style alias \"%s\" for mechanism database entry \"%s\" (original is \"%s\")";
    }
    @Override
    public final void warnInvalidAliasForMissingMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidAliasForMissingMechanismDatabaseEntry$str(), value, name);
    }
    protected String warnInvalidAliasForMissingMechanismDatabaseEntry$str() {
        return "ELY01077: Invalid alias \"%s\" for missing mechanism database entry \"%s\"";
    }
    protected String noAlgorithmForSslProtocol$str() {
        return "ELY04001: No algorithm found matching TLS/SSL protocol selection criteria";
    }
    @Override
    public final NoSuchAlgorithmException noAlgorithmForSslProtocol() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noAlgorithmForSslProtocol$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String emptyChainNotTrusted$str() {
        return "ELY04002: Empty certificate chain is not trusted";
    }
    @Override
    public final CertificateException emptyChainNotTrusted() {
        final CertificateException result = new CertificateException(String.format(getLoggingLocale(), emptyChainNotTrusted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notTrustedRealmProblem$str() {
        return "ELY04003: Certificate not trusted due to realm failure for principal [%s]";
    }
    @Override
    public final CertificateException notTrustedRealmProblem(final RealmUnavailableException e, final Principal principal) {
        final CertificateException result = new CertificateException(String.format(getLoggingLocale(), notTrustedRealmProblem$str(), principal), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notTrusted$str() {
        return "ELY04004: Credential validation failed: certificate is not trusted for principal [%s]";
    }
    @Override
    public final CertificateException notTrusted(final Principal principal) {
        final CertificateException result = new CertificateException(String.format(getLoggingLocale(), notTrusted$str(), principal));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDefaultTrustManager$str() {
        return "ELY04005: No default trust manager available";
    }
    @Override
    public final NoSuchAlgorithmException noDefaultTrustManager() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noDefaultTrustManager$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noContextForSslConnection$str() {
        return "ELY04006: No context for SSL connection";
    }
    @Override
    public final SSLHandshakeException noContextForSslConnection() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), noContextForSslConnection$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sslClosed$str() {
        return "ELY04007: SSL channel is closed";
    }
    @Override
    public final SSLException sslClosed() {
        final SSLException result = new SSLException(String.format(getLoggingLocale(), sslClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notHandshakeRecord$str() {
        return "ELY04008: Initial SSL/TLS data is not a handshake record";
    }
    @Override
    public final SSLHandshakeException notHandshakeRecord() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), notHandshakeRecord$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidHandshakeRecord$str() {
        return "ELY04009: Initial SSL/TLS handshake record is invalid";
    }
    @Override
    public final SSLHandshakeException invalidHandshakeRecord() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), invalidHandshakeRecord$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiRecordSSLHandshake$str() {
        return "ELY04010: Initial SSL/TLS handshake spans multiple records";
    }
    @Override
    public final SSLHandshakeException multiRecordSSLHandshake() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), multiRecordSSLHandshake$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expectedClientHello$str() {
        return "ELY04011: Expected \"client hello\" record";
    }
    @Override
    public final SSLHandshakeException expectedClientHello() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), expectedClientHello$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedSslRecord$str() {
        return "ELY04012: Unsupported SSL/TLS record";
    }
    @Override
    public final SSLHandshakeException unsupportedSslRecord() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), unsupportedSslRecord$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTlsExt$str() {
        return "ELY04013: Invalid TLS extension data";
    }
    @Override
    public final SSLProtocolException invalidTlsExt() {
        final SSLProtocolException result = new SSLProtocolException(String.format(getLoggingLocale(), invalidTlsExt$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notEnoughData$str() {
        return "ELY04014: Not enough data in record to fill declared item size";
    }
    @Override
    public final SSLProtocolException notEnoughData() {
        final SSLProtocolException result = new SSLProtocolException(String.format(getLoggingLocale(), notEnoughData$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String emptyHostNameSni$str() {
        return "ELY04015: Empty host name in SNI record data";
    }
    @Override
    public final SSLProtocolException emptyHostNameSni() {
        final SSLProtocolException result = new SSLProtocolException(String.format(getLoggingLocale(), emptyHostNameSni$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicatedSniServerName$str() {
        return "ELY04016: Duplicated SNI server name of type %d";
    }
    @Override
    public final SSLProtocolException duplicatedSniServerName(final int type) {
        final SSLProtocolException result = new SSLProtocolException(String.format(getLoggingLocale(), duplicatedSniServerName$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownAuthenticationName$str() {
        return "ELY04017: Unknown authentication name \"%s\"";
    }
    @Override
    public final IllegalArgumentException unknownAuthenticationName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownAuthenticationName$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownEncryptionName$str() {
        return "ELY04018: Unknown encryption name \"%s\"";
    }
    @Override
    public final IllegalArgumentException unknownEncryptionName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownEncryptionName$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownKeyExchangeName$str() {
        return "ELY04019: Unknown key exchange name \"%s\"";
    }
    @Override
    public final IllegalArgumentException unknownKeyExchangeName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownKeyExchangeName$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidClientMode$str() {
        return "ELY04024: Invalid client mode, expected %s, got %s";
    }
    @Override
    public final IllegalArgumentException invalidClientMode(final boolean expectedMode, final boolean givenMode) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidClientMode$str(), expectedMode, givenMode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sslErrorCreatingTrustManager$str() {
        return "ELY04026: Could not create trust manager [%s]";
    }
    @Override
    public final IllegalStateException sslErrorCreatingTrustManager(final String name, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), sslErrorCreatingTrustManager$str(), name), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String securityDomainOfSSLContextDoesNotSupportX509$str() {
        return "ELY04027: SecurityDomain of SSLContext does not support X509PeerCertificateChainEvidence verification";
    }
    @Override
    public final IllegalArgumentException securityDomainOfSSLContextDoesNotSupportX509() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), securityDomainOfSSLContextDoesNotSupportX509$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String defaultContextCannotBeNull$str() {
        return "ELY04029: Default context cannot be null";
    }
    @Override
    public final IllegalStateException defaultContextCannotBeNull() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), defaultContextCannotBeNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSNIContextForSslConnection$str() {
        return "ELY04030: No context for SSL connection";
    }
    @Override
    public final SSLException noSNIContextForSslConnection() {
        final SSLException result = new SSLException(String.format(getLoggingLocale(), noSNIContextForSslConnection$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sslErrorCreatingRevocationTrustManager$str() {
        return "ELY04031: TrustManagerFactory algorithm [%s] does not support certificate revocation";
    }
    @Override
    public final IllegalStateException sslErrorCreatingRevocationTrustManager(final String name, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), sslErrorCreatingRevocationTrustManager$str(), name), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechSelectorUnexpectedChar$str() {
        return "ELY05015: Unexpected character U+%04x at offset %d of mechanism selection string \"%s\"";
    }
    @Override
    public final IllegalArgumentException mechSelectorUnexpectedChar(final int codePoint, final long offset, final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mechSelectorUnexpectedChar$str(), codePoint, offset, string));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechSelectorUnknownToken$str() {
        return "ELY05016: Unrecognized token \"%s\" in mechanism selection string \"%s\"";
    }
    @Override
    public final IllegalArgumentException mechSelectorUnknownToken(final String word, final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mechSelectorUnknownToken$str(), word, string));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechSelectorTokenNotAllowed$str() {
        return "ELY05017: Token \"%s\" not allowed at offset %d of mechanism selection string \"%s\"";
    }
    @Override
    public final IllegalArgumentException mechSelectorTokenNotAllowed(final String token, final long offset, final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mechSelectorTokenNotAllowed$str(), token, offset, string));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownCipherSuiteName$str() {
        return "ELY15000: Unknown cipher suite name '%s' in names string '%s'";
    }
    @Override
    public final IllegalArgumentException unknownCipherSuiteName(final String name, final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownCipherSuiteName$str(), name, string));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSslContextProvided$str() {
        return "ELY15001: No '%s' provided by the configured providers";
    }
    @Override
    public final NoSuchAlgorithmException noSslContextProvided(final String type) {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noSslContextProvided$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
