/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.security.sasl.SaslException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.password.impl.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String emptyParameter$str() {
        return "ELY00002: Parameter %s is empty";
    }

    @Override
    public final IllegalArgumentException emptyParameter(String parameter) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.emptyParameter$str(), parameter));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String unrecognizedAlgorithm$str() {
        return "ELY00004: Unrecognized algorithm \"%s\"";
    }

    @Override
    public final IllegalArgumentException unrecognizedAlgorithm(String algorithm) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unrecognizedAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mechInvalidOTPAlgorithm$str() {
        return "ELY05151: Invalid OTP algorithm \"%s\"";
    }

    @Override
    public final SaslException mechInvalidOTPAlgorithm(String algorithm) {
        SaslException result = new SaslException(String.format(this.getLoggingLocale(), this.mechInvalidOTPAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidKeySpecNoSuchMessageDigestAlgorithm$str() {
        return "ELY08013: No such MessageDigest algorithm for \"%s\"";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecNoSuchMessageDigestAlgorithm(String algorithm) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecNoSuchMessageDigestAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidKeyNoSuchMessageDigestAlgorithm$str() {
        return "ELY08014: No such MessageDigest algorithm for \"%s\"";
    }

    @Override
    public final InvalidKeyException invalidKeyNoSuchMessageDigestAlgorithm(String algorithm) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyNoSuchMessageDigestAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidKeyCannotVerifyPassword$str() {
        return "ELY08015: Cannot verify password";
    }

    @Override
    public final InvalidKeyException invalidKeyCannotVerifyPassword(Throwable cause) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyCannotVerifyPassword$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidKeyDesCryptPasswordHashMustBeBytes$str() {
        return "ELY08017: DES crypt password hash must be %d bytes";
    }

    @Override
    public final InvalidKeyException invalidKeyDesCryptPasswordHashMustBeBytes(int bytes) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyDesCryptPasswordHashMustBeBytes$str(), bytes));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidParameterSpecSaltMustBeBytesBits$str() {
        return "ELY08018: Salt must be %d bytes (%d bits)";
    }

    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytesBits(int bytes, int bits) {
        InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(this.getLoggingLocale(), this.invalidParameterSpecSaltMustBeBytesBits$str(), bytes, bits));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidNumberOfRoundsMustBeIntBetween$str() {
        return "ELY08020: Invalid number of rounds. Must be an integer between %d and %d, inclusive";
    }

    @Override
    public final IllegalArgumentException invalidNumberOfRoundsMustBeIntBetween(int min, int max) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNumberOfRoundsMustBeIntBetween$str(), min, max));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSaltMustBeBytesLong$str() {
        return "ELY08021: Invalid salt: must be %d bytes long";
    }

    @Override
    public final IllegalArgumentException invalidSaltMustBeBytesLong(int length) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidSaltMustBeBytesLong$str(), length));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str() {
        return "ELY08022: BSD DES crypt password hash must be %d bytes";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecBsdDesCryptPasswordHashMustBeBytes(int bytes) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidParameterSpecSaltMustBeBytes$str() {
        return "ELY08023: Salt must be %d bytes";
    }

    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytes(int bytes) {
        InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(this.getLoggingLocale(), this.invalidParameterSpecSaltMustBeBytes$str(), bytes));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidKeyBsdDesCryptPasswordHashMustBeBytes$str() {
        return "ELY08024: BSD DES crypt password hash must be %d bytes";
    }

    @Override
    public final InvalidKeyException invalidKeyBsdDesCryptPasswordHashMustBeBytes(int bytes) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidKeySpecExpectedSpecGotSpec$str() {
        return "ELY08025: Expected to get a \"%s\" as spec, got \"%s\"";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecExpectedSpecGotSpec(String expected, String got) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecExpectedSpecGotSpec$str(), expected, got));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str() {
        return "ELY08026: Unknown algorithm \"%s\" or incompatible PasswordSpec \"%s\"";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec(String algorithm, String passwordSpec) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str(), algorithm, passwordSpec));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str() {
        return "ELY08027: Unknown password type or algorithm";
    }

    @Override
    public final InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm() {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuchAlgorithmInvalidAlgorithm$str() {
        return "ELY08028: Invalid algorithm \"%s\"";
    }

    @Override
    public final NoSuchAlgorithmException noSuchAlgorithmInvalidAlgorithm(String algorithm) {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noSuchAlgorithmInvalidAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAlgorithmParameterSpecification$str() {
        return "ELY21000: Invalid algorithm parameter specification";
    }

    @Override
    public final InvalidAlgorithmParameterException invalidAlgorithmParameterSpecification() {
        InvalidAlgorithmParameterException result = new InvalidAlgorithmParameterException(String.format(this.getLoggingLocale(), this.invalidAlgorithmParameterSpecification$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSequenceNumberAlgorithmParameter$str() {
        return "ELY21001: Invalid sequence number algorithm parameter \"%s\"";
    }

    @Override
    public final InvalidAlgorithmParameterException invalidSequenceNumberAlgorithmParameter(int sequenceNumber) {
        InvalidAlgorithmParameterException result = new InvalidAlgorithmParameterException(String.format(this.getLoggingLocale(), this.invalidSequenceNumberAlgorithmParameter$str(), sequenceNumber));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

