/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server.servlet;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import org.wildfly.elytron.web.undertow.server.ElytronContextAssociationHandler;
import org.wildfly.elytron.web.undertow.server.servlet.RequestResponseAccessor;
import org.wildfly.elytron.web.undertow.server.servlet.ServletSecurityContextImpl;

public class ElytronServletContextAssociationHandler
extends ElytronContextAssociationHandler {
    private final String applicationContext;
    private final boolean enableJaspi;
    private final boolean integratedJaspi;

    private ElytronServletContextAssociationHandler(Builder builder) {
        super((ElytronContextAssociationHandler.Builder)builder);
        this.applicationContext = builder.applicationContext;
        this.enableJaspi = builder.enableJaspi;
        this.integratedJaspi = builder.integratedJapi;
    }

    public SecurityContext createSecurityContext(HttpServerExchange exchange) {
        RequestResponseAccessor requestResponseAccessor = new RequestResponseAccessor((ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY));
        return this.populateSecurityContextBuilder(ServletSecurityContextImpl.builder().setApplicationContext(this.applicationContext).setEnableJaspi(this.enableJaspi).setIntegratedJaspi(this.integratedJaspi).setRequestResponseAccessor(requestResponseAccessor), exchange).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ElytronContextAssociationHandler.Builder {
        private String applicationContext;
        private boolean enableJaspi = true;
        private boolean integratedJapi = true;

        public Builder setEnableJaspi(boolean enableJaspi) {
            this.enableJaspi = enableJaspi;
            return this;
        }

        public Builder setIntegratedJaspi(boolean integratedJaspi) {
            this.integratedJapi = integratedJaspi;
            return this;
        }

        public Builder setApplicationContext(String applicationContext) {
            this.applicationContext = applicationContext;
            return this;
        }

        public HttpHandler build() {
            return new ElytronServletContextAssociationHandler(this);
        }
    }
}

