/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.wildfly.plugin.tools.ConsoleConsumer;

public class StandardOutput {
    private static final String SYSTEM_OUT = "system.out";
    private static final String SYSTEM_ERR = "system.err";
    private static final String NONE = "none";
    private final OutputStream consumerStream;
    private final ProcessBuilder.Redirect destination;
    private final Target target;
    private final Path stdoutPath;
    private static final OutputStream DISCARDING = new OutputStream(){

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    };

    private StandardOutput(Target target, OutputStream consumerStream, ProcessBuilder.Redirect destination, Path stdoutPath) {
        this.target = target;
        this.consumerStream = consumerStream;
        this.destination = destination;
        this.stdoutPath = stdoutPath;
    }

    public static StandardOutput parse(String stdout, boolean discardNone) throws IOException {
        return StandardOutput.parse(stdout, discardNone, false);
    }

    public static StandardOutput parse(String stdout, boolean discardNone, boolean append) throws IOException {
        OutputStream out;
        Target target;
        if (stdout == null) {
            return new StandardOutput(Target.INHERIT, null, ProcessBuilder.Redirect.INHERIT, null);
        }
        Path stdoutPath = null;
        String value = stdout.trim();
        if (SYSTEM_OUT.equalsIgnoreCase(value)) {
            target = Target.SYSTEM_OUT;
            out = System.out;
        } else if (SYSTEM_ERR.equalsIgnoreCase(value)) {
            target = Target.SYSTEM_ERR;
            out = System.err;
        } else if (NONE.equalsIgnoreCase(value)) {
            if (discardNone) {
                target = Target.DISCARDING;
                out = DISCARDING;
            } else {
                target = Target.COLLECTING;
                out = new ByteArrayOutputStream();
            }
        } else {
            stdoutPath = Paths.get(stdout.trim(), new String[0]);
            if (Files.notExists(stdoutPath, new LinkOption[0])) {
                Path parent = stdoutPath.getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.createFile(stdoutPath, new FileAttribute[0]);
            }
            target = Target.FILE;
            out = null;
        }
        ProcessBuilder.Redirect destination = null;
        if (stdoutPath != null) {
            destination = append ? ProcessBuilder.Redirect.appendTo(stdoutPath.toFile()) : ProcessBuilder.Redirect.to(stdoutPath.toFile());
        }
        return new StandardOutput(target, out, destination, stdoutPath);
    }

    public static boolean isFile(String output) {
        return output != null && !SYSTEM_OUT.equals(output) && !SYSTEM_ERR.equals(output) && !NONE.equals(output);
    }

    public Optional<ProcessBuilder.Redirect> getRedirect() {
        return Optional.ofNullable(this.destination);
    }

    public Optional<Thread> startConsumer(Process process) {
        Thread thread = null;
        if (this.consumerStream != null) {
            thread = ConsoleConsumer.start((Process)process, (OutputStream)this.consumerStream);
        }
        return Optional.ofNullable(thread);
    }

    public Path getStdoutPath() {
        return this.stdoutPath;
    }

    public Target getTarget() {
        return this.target;
    }

    public String toString() {
        if (this.target == Target.COLLECTING) {
            return this.consumerStream.toString();
        }
        return super.toString();
    }

    public static enum Target {
        COLLECTING,
        DISCARDING,
        FILE,
        SYSTEM_ERR,
        SYSTEM_OUT,
        INHERIT;

    }
}

