/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.ProvisioningOption;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.plugin.InstallPlugin;
import org.jboss.galleon.plugin.ProvisioningPluginWithOptions;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.w3c.dom.Document;
import org.wildfly.galleon.plugin.AbstractArtifactInstaller;
import org.wildfly.galleon.plugin.AbstractModuleTemplateProcessor;
import org.wildfly.galleon.plugin.EE9ArtifactInstaller;
import org.wildfly.galleon.plugin.EE9ArtifactTransformerInstaller;
import org.wildfly.galleon.plugin.FatModuleTemplateProcessor;
import org.wildfly.galleon.plugin.MapPropertyResolver;
import org.wildfly.galleon.plugin.ModuleTemplate;
import org.wildfly.galleon.plugin.PropertyReplacer;
import org.wildfly.galleon.plugin.PropertyResolver;
import org.wildfly.galleon.plugin.SimpleArtifactInstaller;
import org.wildfly.galleon.plugin.ThinModuleTemplateProcessor;
import org.wildfly.galleon.plugin.Utils;
import org.wildfly.galleon.plugin.WildFlyPackageTask;
import org.wildfly.galleon.plugin.WildFlyPackageTasks;
import org.wildfly.galleon.plugin.config.CopyArtifact;
import org.wildfly.galleon.plugin.config.CopyPath;
import org.wildfly.galleon.plugin.config.DeletePath;
import org.wildfly.galleon.plugin.config.ExampleFpConfigs;
import org.wildfly.galleon.plugin.config.FileFilter;
import org.wildfly.galleon.plugin.config.XslTransform;
import org.wildfly.galleon.plugin.transformer.JakartaTransformer;

public class WfInstallPlugin
extends ProvisioningPluginWithOptions
implements InstallPlugin {
    private static final String CONFIG_GEN_METHOD = "generate";
    private static final String CONFIG_GEN_PATH = "wildfly/wildfly-config-gen.jar";
    private static final String CONFIG_GEN_CLASS = "org.wildfly.galleon.plugin.config.generator.WfConfigGenerator";
    private static final String CLI_SCRIPT_RUNNER_CLASS = "org.wildfly.galleon.plugin.config.generator.CliScriptRunner";
    private static final String CLI_SCRIPT_RUNNER_METHOD = "runCliScript";
    private static final String MAVEN_REPO_LOCAL = "maven.repo.local";
    public static final String JAKARTA_TRANSFORM_SUFFIX_KEY = "jakarta.transform.artifacts.suffix";
    private static final ProvisioningOption OPTION_MVN_DIST = ProvisioningOption.builder((String)"jboss-maven-dist").setBooleanValueSet().build();
    public static final ProvisioningOption OPTION_DUMP_CONFIG_SCRIPTS = ProvisioningOption.builder((String)"jboss-dump-config-scripts").setPersistent(false).build();
    private static final ProvisioningOption OPTION_FORK_EMBEDDED = ProvisioningOption.builder((String)"jboss-fork-embedded").setBooleanValueSet().build();
    private static final ProvisioningOption OPTION_MVN_REPO = ProvisioningOption.builder((String)"jboss-maven-repo").setPersistent(false).build();
    private static final ProvisioningOption OPTION_JAKARTA_TRANSFORM_ARTIFACTS = ProvisioningOption.builder((String)"jboss-jakarta-transform-artifacts").setBooleanValueSet().build();
    private static final ProvisioningOption OPTION_MVN_PROVISIONING_REPO = ProvisioningOption.builder((String)"jboss-maven-provisioning-repo").setPersistent(false).build();
    private static final ProvisioningOption OPTION_JAKARTA_TRANSFORM_ARTIFACTS_VERBOSE = ProvisioningOption.builder((String)"jboss-jakarta-transform-artifacts-verbose").setBooleanValueSet().build();
    private static final ProvisioningOption OPTION_OVERRIDDEN_ARTIFACTS = ProvisioningOption.builder((String)"jboss-overridden-artifacts").setPersistent(true).build();
    private ProvisioningRuntime runtime;
    MessageWriter log;
    private Map<String, String> mergedArtifactVersions = new HashMap<String, String>();
    private final Map<String, String> overriddenArtifactVersions = new HashMap<String, String>();
    private Map<FeaturePackLocation.ProducerSpec, Map<String, String>> fpArtifactVersions = new HashMap<FeaturePackLocation.ProducerSpec, Map<String, String>>();
    private Map<FeaturePackLocation.ProducerSpec, Map<String, String>> fpTasksProps = Collections.emptyMap();
    private Map<String, String> mergedTaskProps = new HashMap<String, String>();
    private PropertyResolver mergedTaskPropsResolver;
    private boolean thinServer;
    private Set<String> schemaGroups = Collections.emptySet();
    private List<WildFlyPackageTask> finalizingTasks = Collections.emptyList();
    private List<PackageRuntime> finalizingTasksPkgs = Collections.emptyList();
    private DocumentBuilderFactory docBuilderFactory;
    private TransformerFactory xsltFactory;
    private Map<String, Transformer> xslTransformers = Collections.emptyMap();
    private Map<FeaturePackLocation.FPID, ExampleFpConfigs> exampleConfigs = Collections.emptyMap();
    private ProgressTracker<PackageRuntime> pkgProgressTracker;
    private MavenRepoManager maven;
    private Map<Path, PackageRuntime> jbossModules = new LinkedHashMap<Path, PackageRuntime>();
    private Path transformationMavenRepo;
    private Set<String> transformExcluded = new HashSet<String>();
    private Path provisioningMavenRepo;
    private Path generatedMavenRepo;
    private AbstractArtifactInstaller artifactInstaller;
    private ArtifactResolver artifactResolver;

    protected List<ProvisioningOption> initPluginOptions() {
        return Arrays.asList(OPTION_MVN_DIST, OPTION_DUMP_CONFIG_SCRIPTS, OPTION_FORK_EMBEDDED, OPTION_MVN_REPO, OPTION_JAKARTA_TRANSFORM_ARTIFACTS, OPTION_MVN_PROVISIONING_REPO, OPTION_JAKARTA_TRANSFORM_ARTIFACTS_VERBOSE, OPTION_OVERRIDDEN_ARTIFACTS);
    }

    public ProvisioningRuntime getRuntime() {
        return this.runtime;
    }

    private boolean isThinServer() throws ProvisioningException {
        if (!this.runtime.isOptionSet(OPTION_MVN_DIST)) {
            return false;
        }
        String value = this.runtime.getOptionValue(OPTION_MVN_DIST);
        return value == null ? true : Boolean.parseBoolean(value);
    }

    private Path getGeneratedMavenRepo() throws ProvisioningException {
        if (!this.runtime.isOptionSet(OPTION_MVN_REPO)) {
            return null;
        }
        String value = this.runtime.getOptionValue(OPTION_MVN_REPO);
        return value == null ? null : Paths.get(value, new String[0]);
    }

    private Path getProvisioningMavenRepo() throws ProvisioningException {
        if (!this.runtime.isOptionSet(OPTION_MVN_PROVISIONING_REPO)) {
            return null;
        }
        String value = this.runtime.getOptionValue(OPTION_MVN_PROVISIONING_REPO);
        return value == null ? null : Paths.get(value, new String[0]);
    }

    private Map<String, String> getOverriddenArtifacts() throws ProvisioningException {
        if (!this.runtime.isOptionSet(OPTION_OVERRIDDEN_ARTIFACTS)) {
            return Collections.emptyMap();
        }
        String value = this.runtime.getOptionValue(OPTION_OVERRIDDEN_ARTIFACTS);
        return value == null ? Collections.emptyMap() : Utils.toArtifactsMap(value);
    }

    private boolean isTransformationEnabled() throws ProvisioningException {
        if (!this.runtime.isOptionSet(OPTION_JAKARTA_TRANSFORM_ARTIFACTS)) {
            return true;
        }
        String value = this.runtime.getOptionValue(OPTION_JAKARTA_TRANSFORM_ARTIFACTS);
        return value == null ? true : Boolean.parseBoolean(value);
    }

    private boolean isVerboseTransformation() throws ProvisioningException {
        if (!this.runtime.isOptionSet(OPTION_JAKARTA_TRANSFORM_ARTIFACTS_VERBOSE)) {
            return false;
        }
        String value = this.runtime.getOptionValue(OPTION_JAKARTA_TRANSFORM_ARTIFACTS_VERBOSE);
        return value == null ? true : Boolean.parseBoolean(value);
    }

    public void preInstall(ProvisioningRuntime runtime) throws ProvisioningException {
        String runningMode;
        FsDiff fsDiff = runtime.getFsDiff();
        if (fsDiff == null) {
            return;
        }
        String string = fsDiff.getEntry("standalone/tmp/startup-marker") != null ? "standalone" : (runningMode = fsDiff.getEntry("domain/tmp/startup-marker") != null ? "domain" : null);
        if (runningMode != null) {
            throw new ProvisioningException("The server appears to be running (" + runningMode + " mode).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void postInstall(ProvisioningRuntime runtime) throws ProvisioningException {
        Path layersConf;
        long startTime = runtime.isLogTime() ? System.nanoTime() : -1L;
        this.runtime = runtime;
        this.log = runtime.getMessageWriter();
        this.log.verbose((CharSequence)"WildFly Galleon Installation Plugin");
        this.thinServer = this.isThinServer();
        this.generatedMavenRepo = this.getGeneratedMavenRepo();
        if (this.generatedMavenRepo != null) {
            IoUtils.recursiveDelete((Path)this.generatedMavenRepo);
        }
        this.maven = (MavenRepoManager)runtime.getArtifactResolver("repository.maven");
        this.provisioningMavenRepo = this.getProvisioningMavenRepo();
        this.overriddenArtifactVersions.putAll(this.getOverriddenArtifacts());
        if (this.provisioningMavenRepo != null && Files.notExists(this.provisioningMavenRepo, new LinkOption[0])) {
            throw new ProvisioningException("Local maven repository " + this.provisioningMavenRepo.toAbsolutePath().toString() + " used to provision the server doesn't exist.");
        }
        for (FeaturePackRuntime fp : runtime.getFeaturePacks()) {
            Path excludedArtifacts;
            Throwable throwable;
            Path tasksPropsPath;
            Path wfRes = fp.getResource(new String[]{"wildfly"});
            if (!Files.exists(wfRes, new LinkOption[0])) continue;
            Path artifactProps = wfRes.resolve("artifact-versions.properties");
            if (Files.exists(artifactProps, new LinkOption[0])) {
                Map<String, String> versionProps = Utils.readProperties(artifactProps);
                for (Map.Entry<String, String> entry : this.overriddenArtifactVersions.entrySet()) {
                    if (!versionProps.containsKey(entry.getKey())) continue;
                    versionProps.put(entry.getKey(), entry.getValue());
                }
                this.fpArtifactVersions.put(fp.getFPID().getProducer(), versionProps);
                this.mergedArtifactVersions.putAll(versionProps);
            }
            if (Files.exists(tasksPropsPath = wfRes.resolve("wildfly-tasks.properties"), new LinkOption[0])) {
                Map<String, String> fpProps = Utils.readProperties(tasksPropsPath);
                this.fpTasksProps = CollectionUtils.put(this.fpTasksProps, (Object)fp.getFPID().getProducer(), fpProps);
                this.mergedTaskProps.putAll(fpProps);
            }
            if (fp.containsPackage("docs.schema")) {
                Path schemaGroupsTxt = fp.getPackage("docs.schema").getResource(new String[]{"pm", "wildfly", "schema-groups.txt"});
                try {
                    throwable = null;
                    try (BufferedReader bufferedReader = Files.newBufferedReader(schemaGroupsTxt);){
                        String line2 = bufferedReader.readLine();
                        while (line2 != null) {
                            this.schemaGroups = CollectionUtils.add(this.schemaGroups, (Object)line2);
                            line2 = bufferedReader.readLine();
                        }
                    }
                    catch (Throwable line2) {
                        throwable = line2;
                        throw line2;
                    }
                }
                catch (IOException iOException) {
                    throw new ProvisioningException(Errors.readFile((Path)schemaGroupsTxt), (Throwable)iOException);
                }
            }
            if (!Files.exists(excludedArtifacts = wfRes.resolve("wildfly-jakarta-transform-excludes.txt"), new LinkOption[0])) continue;
            try {
                BufferedReader bufferedReader = Files.newBufferedReader(excludedArtifacts, StandardCharsets.UTF_8);
                throwable = null;
                try {
                    String line3 = bufferedReader.readLine();
                    while (line3 != null) {
                        this.transformExcluded = CollectionUtils.add(this.transformExcluded, (Object)line3);
                        line3 = bufferedReader.readLine();
                    }
                }
                catch (Throwable line3) {
                    throwable = line3;
                    throw line3;
                }
                finally {
                    if (bufferedReader == null) continue;
                    if (throwable != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable line3) {
                            throwable.addSuppressed(line3);
                        }
                        continue;
                    }
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new ProvisioningException(Errors.readFile((Path)excludedArtifacts), (Throwable)iOException);
            }
        }
        for (String key : this.overriddenArtifactVersions.keySet()) {
            if (this.mergedArtifactVersions.containsKey(key)) continue;
            throw new ProvisioningException("Overridden artifacts " + key + " is not found in the set of known server artifacts");
        }
        this.mergedArtifactVersions.putAll(this.overriddenArtifactVersions);
        this.mergedTaskPropsResolver = new MapPropertyResolver(this.mergedTaskProps);
        boolean transformableFeaturePack = Boolean.valueOf(this.mergedTaskProps.getOrDefault("jakarta.transform.artifacts", "false"));
        if (!transformableFeaturePack) {
            this.artifactResolver = this::resolveMaven;
            this.artifactInstaller = new SimpleArtifactInstaller(this.artifactResolver, this.generatedMavenRepo);
        } else {
            final String jakartaTransformSuffix = this.mergedTaskProps.getOrDefault(JAKARTA_TRANSFORM_SUFFIX_KEY, "");
            boolean jakartaTransformVerbose = this.isVerboseTransformation();
            String jakartaConfigsDir = this.mergedTaskProps.get("jakarta.transform.configs.dir");
            Iterator jakartaTransformConfigsDir = null;
            if (jakartaConfigsDir != null) {
                jakartaTransformConfigsDir = Paths.get(jakartaConfigsDir, new String[0]);
            }
            JakartaTransformer.LogHandler logHandler = new JakartaTransformer.LogHandler(){

                @Override
                public void print(String format, Object ... args) {
                    WfInstallPlugin.this.log.print(format, args);
                }
            };
            if (this.isTransformationEnabled()) {
                if (this.provisioningMavenRepo != null) {
                    throw new ProvisioningException("Jakarta transformation is enabled, option " + OPTION_MVN_PROVISIONING_REPO.getName() + " can't be set.");
                }
                if (this.isThinServer() && this.generatedMavenRepo == null) {
                    throw new ProvisioningException("Jakarta transformation is enabled for thin server, option " + OPTION_MVN_REPO.getName() + " is required.");
                }
                this.artifactResolver = this::resolveMaven;
                this.artifactInstaller = new EE9ArtifactTransformerInstaller(this.artifactResolver, this.generatedMavenRepo, this.transformExcluded, this, jakartaTransformSuffix, (Path)((Object)jakartaTransformConfigsDir), logHandler, jakartaTransformVerbose, runtime);
            } else {
                if (this.provisioningMavenRepo == null) {
                    throw new ProvisioningException("Jakarta transformation is disabled, " + OPTION_MVN_PROVISIONING_REPO.getName() + " must be set");
                }
                this.artifactResolver = new ArtifactResolver(){

                    @Override
                    public void resolve(MavenArtifact artifact) throws ProvisioningException {
                        WfInstallPlugin.this.resolveMaven(artifact, jakartaTransformSuffix);
                    }
                };
                this.artifactInstaller = new EE9ArtifactInstaller(this.artifactResolver, this.generatedMavenRepo, this.transformExcluded, this, jakartaTransformSuffix, (Path)((Object)jakartaTransformConfigsDir), logHandler, jakartaTransformVerbose, runtime, this.provisioningMavenRepo);
            }
        }
        ProvisioningLayoutFactory layoutFactory = runtime.getLayout().getFactory();
        this.pkgProgressTracker = layoutFactory.getProgressTracker("PACKAGES");
        long pkgsTotal = 0L;
        for (Object fp : runtime.getFeaturePacks()) {
            pkgsTotal += (long)fp.getPackageNames().size();
        }
        this.pkgProgressTracker.starting(pkgsTotal);
        for (Object fp : runtime.getFeaturePacks()) {
            this.processPackages((FeaturePackRuntime)fp);
        }
        this.pkgProgressTracker.complete();
        if (!this.jbossModules.isEmpty()) {
            if (transformableFeaturePack && !this.exampleConfigs.isEmpty()) {
                this.transformationMavenRepo = this.generatedMavenRepo != null ? this.generatedMavenRepo : runtime.getTmpPath(new String[]{"jakarta-transform-repo"});
            }
            ProgressTracker modulesTracker = layoutFactory.getProgressTracker("JBMODULES");
            modulesTracker.starting((long)this.jbossModules.size());
            for (Map.Entry entry : this.jbossModules.entrySet()) {
                PackageRuntime pkg = (PackageRuntime)entry.getValue();
                modulesTracker.processing((Object)pkg);
                try {
                    this.processModuleTemplate(pkg, (Path)entry.getKey());
                }
                catch (IOException e) {
                    throw new ProvisioningException("Failed to process JBoss module XML template for feature-pack " + pkg.getFeaturePackRuntime().getFPID() + " package " + pkg.getName(), (Throwable)e);
                }
                modulesTracker.processed((Object)pkg);
            }
            modulesTracker.complete();
        }
        if (Files.exists(layersConf = runtime.getStagedDir().resolve("modules").resolve("layers.conf"), new LinkOption[0])) {
            this.mergeLayerConfs(runtime);
        }
        String originalMavenRepoLocal = System.getProperty(MAVEN_REPO_LOCAL);
        if (this.thinServer) {
            void var10_23;
            Object var10_20 = null;
            if (runtime.isOptionSet(OPTION_MVN_REPO)) {
                String path = runtime.getOptionValue(OPTION_MVN_REPO);
                Path path2 = Paths.get(path, new String[0]).toAbsolutePath();
            } else if (this.provisioningMavenRepo != null) {
                Path path = this.provisioningMavenRepo.toAbsolutePath();
            }
            if (var10_23 != null) {
                System.setProperty(MAVEN_REPO_LOCAL, var10_23.toString());
            }
            if (this.log.isVerboseEnabled()) {
                this.log.verbose((CharSequence)("Generating configs with local maven repository: " + System.getProperty(MAVEN_REPO_LOCAL)));
            }
        }
        try {
            this.generateConfigs(runtime);
        }
        finally {
            if (originalMavenRepoLocal == null) {
                System.clearProperty(MAVEN_REPO_LOCAL);
            } else {
                System.setProperty(MAVEN_REPO_LOCAL, originalMavenRepoLocal);
            }
        }
        if (Files.exists(runtime.getStagedDir(), new LinkOption[0])) {
            for (FeaturePackRuntime fp : runtime.getFeaturePacks()) {
                Path finalizeCli = fp.getResource(new String[]{"wildfly", "scripts", "finalize.cli"});
                if (!Files.exists(finalizeCli, new LinkOption[0])) continue;
                Path configGenJar = runtime.getResource(new String[]{CONFIG_GEN_PATH});
                if (!Files.exists(configGenJar, new LinkOption[0])) {
                    throw new ProvisioningException(Errors.pathDoesNotExist((Path)configGenJar));
                }
                URL[] cp = new URL[2];
                try {
                    MavenArtifact artifact = Utils.toArtifactCoords(this.mergedArtifactVersions, "org.wildfly.core:wildfly-launcher", false);
                    this.artifactResolver.resolve(artifact);
                    cp[0] = configGenJar.toUri().toURL();
                    cp[1] = artifact.getPath().toUri().toURL();
                }
                catch (IOException e) {
                    throw new ProvisioningException("Failed to init classpath to run CLI finalize script for " + runtime.getStagedDir(), (Throwable)e);
                }
                ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
                URLClassLoader cliScriptCl = new URLClassLoader(cp, originalCl);
                try {
                    Path script;
                    try {
                        byte[] content = Files.readAllBytes(finalizeCli);
                        Path tmpDir = runtime.getTmpPath(new String[0]);
                        if (!Files.exists(tmpDir, new LinkOption[0])) {
                            Files.createDirectory(tmpDir, new FileAttribute[0]);
                        }
                        script = tmpDir.resolve(finalizeCli.getFileName().toString());
                        Files.write(script, content, new OpenOption[0]);
                    }
                    catch (IOException ex) {
                        throw new ProvisioningException(ex.getLocalizedMessage(), (Throwable)ex);
                    }
                    Thread.currentThread().setContextClassLoader(cliScriptCl);
                    try {
                        Class<?> cliScriptRunnerCls = cliScriptCl.loadClass(CLI_SCRIPT_RUNNER_CLASS);
                        Method m = cliScriptRunnerCls.getMethod(CLI_SCRIPT_RUNNER_METHOD, Path.class, Path.class, MessageWriter.class);
                        m.invoke(null, runtime.getStagedDir(), script, this.log);
                    }
                    catch (Throwable e) {
                        throw new ProvisioningException("Failed to initialize CLI script runner org.wildfly.galleon.plugin.config.generator.CliScriptRunner", e);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalCl);
                    try {
                        cliScriptCl.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (!this.finalizingTasks.isEmpty()) {
            void var10_28;
            boolean bl = false;
            while (var10_28 < this.finalizingTasks.size()) {
                this.finalizingTasks.get((int)var10_28).execute(this, this.finalizingTasksPkgs.get((int)var10_28));
                ++var10_28;
            }
        }
        if (!this.exampleConfigs.isEmpty()) {
            this.provisionExampleConfigs(transformableFeaturePack);
        }
        if (startTime > 0L) {
            this.log.print((CharSequence)Errors.tookTime((String)"Overall WildFly Galleon Plugin", (long)startTime));
        }
    }

    private void setupLayerDirectory(Path layersConf, Path layersDir) throws ProvisioningException {
        this.log.verbose((CharSequence)"Creating layers directories if needed.");
        try (BufferedReader reader = Files.newBufferedReader(layersConf);){
            String[] layerNames;
            Properties props = new Properties();
            props.load(reader);
            String layersProp = props.getProperty("layers");
            if (layersProp == null || (layersProp = layersProp.trim()).length() == 0) {
                return;
            }
            for (String layerName : layerNames = layersProp.split(",")) {
                this.log.verbose("Found layer %s", new Object[]{layerName});
                Path layerDir = layersDir.resolve(layerName);
                if (Files.exists(layerDir, new LinkOption[0])) continue;
                this.log.verbose("Creating directory %s", new Object[]{layerDir});
                Files.createDirectories(layerDir, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            throw new ProvisioningException("Failed to setup layers directory in " + layersDir, (Throwable)ex);
        }
    }

    private void mergeLayerConfs(ProvisioningRuntime runtime) throws ProvisioningException {
        List<Path> layersConfs = Utils.collectLayersConf(runtime.getLayout());
        for (Path p : layersConfs) {
            this.setupLayerDirectory(p, runtime.getStagedDir().resolve("modules").resolve("system").resolve("layers"));
        }
        if (layersConfs.size() < 2) {
            return;
        }
        Utils.mergeLayersConfs(layersConfs, runtime.getStagedDir());
    }

    private void provisionExampleConfigs(boolean transformableFeaturePack) throws ProvisioningException {
        Path examplesTmp = this.runtime.getTmpPath(new String[]{"example-configs"});
        ProvisioningManager pm = ProvisioningManager.builder().setInstallationHome(examplesTmp).setMessageWriter(this.log).setLayoutFactory(this.runtime.getLayout().getFactory()).setRecordState(false).build();
        ArrayList<Path> configPaths = new ArrayList<Path>();
        ProvisioningConfig.Builder configBuilder = ProvisioningConfig.builder();
        for (Map.Entry<FeaturePackLocation.FPID, ExampleFpConfigs> example : this.exampleConfigs.entrySet()) {
            FeaturePackConfig.Builder fpBuilder = ((FeaturePackConfig.Builder)FeaturePackConfig.builder((FeaturePackLocation)example.getKey().getLocation()).setInheritConfigs(false)).setInheritPackages(false);
            ExampleFpConfigs fpExampleConfigs = example.getValue();
            if (fpExampleConfigs != null) {
                for (Map.Entry<ConfigId, ConfigModel> config : fpExampleConfigs.getConfigs().entrySet()) {
                    ConfigId configId = config.getKey();
                    ConfigModel configModel = config.getValue();
                    String configName = null;
                    if (configModel != null) {
                        fpBuilder.addConfig(configModel);
                        if (configModel.hasProperties()) {
                            configName = "standalone".equals(configId.getModel()) ? (String)configModel.getProperties().get("--server-config") : ("host".equals(configId.getModel()) ? (String)configModel.getProperties().get("--host-config") : (String)configModel.getProperties().get("--domain-config"));
                        }
                        if (configName == null) {
                            configName = configId.getName();
                        }
                    } else {
                        fpBuilder.includeDefaultConfig(configId);
                        configName = configId.getName();
                    }
                    if ("host".equals(configId.getModel())) {
                        configPaths.add(examplesTmp.resolve("domain").resolve("configuration").resolve(configName));
                        continue;
                    }
                    configPaths.add(examplesTmp.resolve(configId.getModel()).resolve("configuration").resolve(configName));
                }
            }
            configBuilder.addFeaturePackDep(fpBuilder.build());
        }
        try {
            this.log.verbose((CharSequence)"Generating example configs");
            ProvisioningConfig config = configBuilder.build();
            HashMap options = this.runtime.getLayout().getOptions();
            if (!options.containsKey(OPTION_MVN_DIST.getName()) || options.containsKey(OPTION_MVN_REPO.getName())) {
                HashMap tmp = new HashMap(options.size() + 1);
                tmp.putAll(options);
                options = tmp;
                options.put(OPTION_MVN_DIST.getName(), null);
                options.remove(OPTION_MVN_REPO.getName());
                if (transformableFeaturePack) {
                    options.remove(OPTION_JAKARTA_TRANSFORM_ARTIFACTS.getName());
                    options.put(OPTION_JAKARTA_TRANSFORM_ARTIFACTS.getName(), "false");
                    if (!options.containsKey(OPTION_MVN_PROVISIONING_REPO.getName())) {
                        Path localRepo;
                        if (this.transformationMavenRepo != null) {
                            localRepo = this.transformationMavenRepo.toAbsolutePath();
                        } else if (this.thinServer && this.runtime.isOptionSet(OPTION_MVN_REPO)) {
                            String path = this.runtime.getOptionValue(OPTION_MVN_REPO);
                            Path repo = Paths.get(path, new String[0]);
                            localRepo = repo.toAbsolutePath();
                        } else {
                            throw new ProvisioningException("Can't provision example configs, no local maven repo cache");
                        }
                        options.put(OPTION_MVN_PROVISIONING_REPO.getName(), localRepo.toString());
                    }
                }
            }
            pm.provision(config, (Map)options);
        }
        catch (ProvisioningException e) {
            throw new ProvisioningException("Failed to generate example configs", (Throwable)e);
        }
        Path exampleConfigsDir = this.runtime.getStagedDir().resolve("docs").resolve("examples").resolve("configs");
        for (Path configPath : configPaths) {
            try {
                IoUtils.copy((Path)configPath, (Path)exampleConfigsDir.resolve(configPath.getFileName()));
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.copyFile((Path)configPath, (Path)exampleConfigsDir.resolve(configPath.getFileName())), (Throwable)e);
            }
        }
    }

    private void generateConfigs(ProvisioningRuntime runtime) throws ProvisioningException {
        if (!runtime.hasConfigs()) {
            return;
        }
        long startTime = runtime.isLogTime() ? System.nanoTime() : -1L;
        Path configGenJar = runtime.getResource(new String[]{CONFIG_GEN_PATH});
        if (!Files.exists(configGenJar, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)configGenJar));
        }
        URL[] cp = new URL[3];
        try {
            cp[0] = configGenJar.toUri().toURL();
            MavenArtifact artifact = Utils.toArtifactCoords(this.mergedArtifactVersions, "org.jboss.modules:jboss-modules", false);
            this.artifactResolver.resolve(artifact);
            cp[1] = artifact.getPath().toUri().toURL();
            artifact = Utils.toArtifactCoords(this.mergedArtifactVersions, "org.wildfly.core:wildfly-cli::client", false);
            this.artifactResolver.resolve(artifact);
            cp[2] = artifact.getPath().toUri().toURL();
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to init classpath for " + runtime.getStagedDir(), (Throwable)e);
        }
        if (this.log.isVerboseEnabled()) {
            this.log.verbose((CharSequence)"Config generator classpath:");
            for (int i = 0; i < cp.length; ++i) {
                this.log.verbose((CharSequence)(i + 1 + ". " + cp[i]));
            }
        }
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        URLClassLoader configGenCl = new URLClassLoader(cp, originalCl);
        Thread.currentThread().setContextClassLoader(configGenCl);
        try {
            Class<?> configHandlerCls = configGenCl.loadClass(CONFIG_GEN_CLASS);
            Constructor<?> ctor = configHandlerCls.getConstructor(new Class[0]);
            Method m = configHandlerCls.getMethod(CONFIG_GEN_METHOD, ProvisioningRuntime.class, Boolean.TYPE);
            Object generator = ctor.newInstance(new Object[0]);
            boolean forkEmbedded = false;
            if (runtime.isOptionSet(OPTION_FORK_EMBEDDED)) {
                String value = runtime.getOptionValue(OPTION_FORK_EMBEDDED);
                forkEmbedded = value == null ? true : Boolean.parseBoolean(value);
            }
            m.invoke(generator, runtime, forkEmbedded);
            if (startTime > 0L) {
                this.log.print((CharSequence)Errors.tookTime((String)"WildFly configuration generation", (long)startTime));
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProvisioningException) {
                throw (ProvisioningException)cause;
            }
            throw new ProvisioningException("Failed to invoke config generator org.wildfly.galleon.plugin.config.generator.WfConfigGenerator", cause);
        }
        catch (Throwable e) {
            throw new ProvisioningException("Failed to initialize config generator org.wildfly.galleon.plugin.config.generator.WfConfigGenerator", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
            try {
                configGenCl.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void processPackages(FeaturePackRuntime fp) throws ProvisioningException {
        this.log.verbose("Processing %s packages", new Object[]{fp.getFPID()});
        for (PackageRuntime pkg : fp.getPackages()) {
            Path tasksXml;
            this.pkgProgressTracker.processing((Object)pkg);
            Path pmWfDir = pkg.getResource(new String[]{"pm", "wildfly"});
            if (!Files.exists(pmWfDir, new LinkOption[0])) {
                this.pkgProgressTracker.processed((Object)pkg);
                continue;
            }
            Path moduleDir = pmWfDir.resolve("module");
            if (Files.exists(moduleDir, new LinkOption[0])) {
                this.processModules(pkg, moduleDir);
            }
            if (Files.exists(tasksXml = pmWfDir.resolve("tasks.xml"), new LinkOption[0])) {
                WildFlyPackageTasks pkgTasks = WildFlyPackageTasks.load(tasksXml);
                if (pkgTasks.hasTasks()) {
                    this.log.verbose("Processing %s package %s tasks", new Object[]{fp.getFPID(), pkg.getName()});
                    for (WildFlyPackageTask task : pkgTasks.getTasks()) {
                        if (task.getPhase() == WildFlyPackageTask.Phase.PROCESSING) {
                            task.execute(this, pkg);
                            continue;
                        }
                        this.finalizingTasks = CollectionUtils.add(this.finalizingTasks, (Object)task);
                        this.finalizingTasksPkgs = CollectionUtils.add(this.finalizingTasksPkgs, (Object)pkg);
                    }
                }
                if (pkgTasks.hasMkDirs()) {
                    WfInstallPlugin.mkdirs(pkgTasks, this.runtime.getStagedDir());
                }
                WfInstallPlugin.changeLineEndings(pkgTasks, this.runtime.getStagedDir());
            }
            this.pkgProgressTracker.processed((Object)pkg);
        }
    }

    public void xslTransform(PackageRuntime pkg, XslTransform xslt) throws ProvisioningException {
        Path src = this.runtime.getStagedDir().resolve(xslt.getSrc());
        if (!Files.exists(src, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)src));
        }
        Path output = this.runtime.getStagedDir().resolve(xslt.getOutput());
        if (Files.exists(output, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathAlreadyExists((Path)output));
        }
        try (InputStream srcInput = Files.newInputStream(src, new OpenOption[0]);
             OutputStream outStream = Files.newOutputStream(output, new OpenOption[0]);){
            Map<String, String> taskProps;
            Document document = this.getXmlDocumentBuilderFactory().newDocumentBuilder().parse(srcInput);
            Transformer transformer = this.getXslTransformer(xslt.getStylesheet());
            if (xslt.hasParams()) {
                for (Map.Entry<String, String> entry : xslt.getParams().entrySet()) {
                    transformer.setParameter(entry.getKey(), entry.getValue());
                }
            }
            Map<String, String> map = taskProps = xslt.isFeaturePackProperties() ? this.fpTasksProps.get(pkg.getFeaturePackRuntime().getFPID().getProducer()) : this.mergedTaskProps;
            if (taskProps != null) {
                for (Map.Entry<String, String> entry : taskProps.entrySet()) {
                    transformer.setParameter(entry.getKey(), entry.getValue());
                }
            }
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(outStream);
            transformer.transform(dOMSource, streamResult);
        }
        catch (ProvisioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProvisioningException("Failed to transform " + xslt.getSrc() + " with " + xslt.getStylesheet() + " to " + xslt.getOutput(), (Throwable)e);
        }
    }

    private Transformer getXslTransformer(String stylesheet) throws ProvisioningException {
        Transformer transformer = this.xslTransformers.get(stylesheet);
        if (transformer != null) {
            return transformer;
        }
        transformer = this.getXslTransformer(this.runtime.getStagedDir().resolve(stylesheet));
        this.xslTransformers = CollectionUtils.put(this.xslTransformers, (Object)stylesheet, (Object)transformer);
        return transformer;
    }

    public DocumentBuilderFactory getXmlDocumentBuilderFactory() {
        if (this.docBuilderFactory == null) {
            this.docBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return this.docBuilderFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Transformer getXslTransformer(Path p) throws ProvisioningException {
        if (!Files.exists(p, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)p));
        }
        try (InputStream styleInput = Files.newInputStream(p, new OpenOption[0]);){
            StreamSource stylesource = new StreamSource(styleInput);
            if (this.xsltFactory == null) {
                this.xsltFactory = TransformerFactory.newInstance();
            }
            Transformer transformer = this.xsltFactory.newTransformer(stylesource);
            return transformer;
        }
        catch (Exception e) {
            throw new ProvisioningException("Failed to initialize a transformer for " + p, (Throwable)e);
        }
    }

    private void processModules(final PackageRuntime pkg, final Path fpModuleDir) throws ProvisioningException {
        try {
            final Path stagedDir = this.runtime.getStagedDir();
            if (!Files.exists(stagedDir, new LinkOption[0])) {
                Files.createDirectories(stagedDir, new FileAttribute[0]);
            }
            Files.walkFileTree(fpModuleDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    block2: {
                        Path targetDir = stagedDir.resolve(fpModuleDir.relativize(dir).toString());
                        try {
                            Files.copy(dir, targetDir, new CopyOption[0]);
                        }
                        catch (FileAlreadyExistsException e) {
                            if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                            throw e;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().equals("module.xml")) {
                        PackageRuntime overriddenPkg = WfInstallPlugin.this.jbossModules.put(fpModuleDir.relativize(file), pkg);
                        if (overriddenPkg != null && WfInstallPlugin.this.log.isVerboseEnabled()) {
                            WfInstallPlugin.this.log.verbose((CharSequence)("Feature-pack " + pkg.getFeaturePackRuntime().getFPID() + " package " + pkg.getName() + " override jboss-module from feature-pack " + overriddenPkg.getFeaturePackRuntime().getFPID() + " package " + overriddenPkg.getName()));
                        }
                    } else {
                        Files.copy(file, stagedDir.resolve(fpModuleDir.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to process modules from package " + pkg.getName() + " from feature-pack " + pkg.getFeaturePackRuntime().getFPID(), (Throwable)e);
        }
    }

    private void processModuleTemplate(PackageRuntime pkg, Path moduleXmlRelativePath) throws ProvisioningException, IOException {
        Path targetPath;
        Path moduleTemplateFile = pkg.getResource(new String[]{"pm", "wildfly", "module"}).resolve(moduleXmlRelativePath);
        ModuleTemplate moduleTemplate = new ModuleTemplate(pkg, moduleTemplateFile, targetPath = this.runtime.getStagedDir().resolve(moduleXmlRelativePath.toString()));
        if (!moduleTemplate.isModule()) {
            Files.copy(moduleTemplateFile, targetPath, StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        Map<String, String> versionProps = this.fpArtifactVersions.get(pkg.getFeaturePackRuntime().getFPID().getProducer());
        Path targetDir = this.runtime.getStagedDir().resolve(moduleXmlRelativePath.toString());
        AbstractModuleTemplateProcessor processor = this.thinServer ? new ThinModuleTemplateProcessor(this, this.artifactInstaller, moduleXmlRelativePath, moduleTemplate, versionProps) : new FatModuleTemplateProcessor(this, this.artifactInstaller, targetDir, moduleTemplate, versionProps, this.transformationMavenRepo);
        processor.process();
        moduleTemplate.store();
    }

    public void addExampleConfigs(FeaturePackRuntime fp, ExampleFpConfigs exampleConfigs) throws ProvisioningException {
        FeaturePackLocation.FPID originFpId = exampleConfigs.getOrigin() != null ? fp.getSpec().getFeaturePackDep(exampleConfigs.getOrigin()).getLocation().getFPID() : fp.getFPID();
        ExampleFpConfigs existingConfigs = this.exampleConfigs.get(originFpId);
        if (existingConfigs == null) {
            this.exampleConfigs = CollectionUtils.put(this.exampleConfigs, (Object)originFpId, (Object)exampleConfigs);
        } else {
            existingConfigs.addAll(exampleConfigs);
        }
    }

    private void extractSchemas(Path moduleArtifact) throws IOException {
        Path targetSchemasDir = this.runtime.getStagedDir().resolve("docs").resolve("schema");
        Files.createDirectories(targetSchemasDir, new FileAttribute[0]);
        try (FileSystem jarFS = FileSystems.newFileSystem(moduleArtifact, (ClassLoader)null);){
            Path schemaSrc = jarFS.getPath("schema", new String[0]);
            if (Files.exists(schemaSrc, new LinkOption[0])) {
                ZipUtils.copyFromZip((Path)schemaSrc.toAbsolutePath(), (Path)targetSchemasDir);
            }
        }
    }

    public void copyArtifact(CopyArtifact copyArtifact, PackageRuntime pkg) throws ProvisioningException {
        MavenArtifact artifact = Utils.toArtifactCoords(copyArtifact.isFeaturePackVersion() ? this.fpArtifactVersions.get(pkg.getFeaturePackRuntime().getFPID().getProducer()) : this.mergedArtifactVersions, copyArtifact.getArtifact(), copyArtifact.isOptional());
        if (artifact == null) {
            return;
        }
        try {
            this.log.verbose("Resolving artifact %s ", new Object[]{artifact});
            this.artifactResolver.resolve(artifact);
            Path jarSrc = this.artifactInstaller.installCopiedArtifact(artifact);
            String location = copyArtifact.getToLocation();
            if (!location.isEmpty() && location.charAt(location.length() - 1) == '/') {
                location = location + jarSrc.getFileName();
            }
            Path jarTarget = this.runtime.getStagedDir().resolve(location);
            Files.createDirectories(jarTarget.getParent(), new FileAttribute[0]);
            this.log.verbose("Copying artifact %s to %s", new Object[]{jarSrc, jarTarget});
            if (copyArtifact.isExtract()) {
                Utils.extractArtifact(jarSrc, jarTarget, copyArtifact);
            } else {
                IoUtils.copy((Path)jarSrc, (Path)jarTarget);
            }
            if (this.schemaGroups.contains(artifact.getGroupId())) {
                this.extractSchemas(jarSrc);
            }
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to copy artifact " + artifact, (Throwable)e);
        }
    }

    void processSchemas(String groupId, Path artifactPath) throws IOException {
        if (this.schemaGroups.contains(groupId)) {
            this.extractSchemas(artifactPath);
        }
    }

    public void copyPath(Path relativeTo, CopyPath copyPath) throws ProvisioningException {
        Path target;
        final Path src = relativeTo.resolve(copyPath.getSrc());
        if (!Files.exists(src, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)src));
        }
        Path path = target = copyPath.getTarget() == null ? this.runtime.getStagedDir() : this.runtime.getStagedDir().resolve(copyPath.getTarget());
        if (copyPath.isReplaceProperties()) {
            if (!Files.exists(target.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.mkdirs((Path)target.getParent()), (Throwable)e);
                }
            }
            try {
                Files.walkFileTree(src, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        block2: {
                            Path targetDir = target.resolve(src.relativize(dir).toString());
                            try {
                                Files.copy(dir, targetDir, new CopyOption[0]);
                            }
                            catch (FileAlreadyExistsException e) {
                                if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                                throw e;
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        PropertyReplacer.copy(file, target.resolve(src.relativize(file).toString()), WfInstallPlugin.this.mergedTaskPropsResolver);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.copyFile((Path)src, (Path)target), (Throwable)e);
            }
        }
        try {
            IoUtils.copy((Path)src, (Path)target);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.copyFile((Path)src, (Path)target));
        }
    }

    public void deletePath(DeletePath deletePath) throws ProvisioningException {
        Path path = this.runtime.getStagedDir().resolve(deletePath.getPath());
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (deletePath.isRecursive()) {
            IoUtils.recursiveDelete((Path)path);
            return;
        }
        if (deletePath.isIfEmpty()) {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new ProvisioningException(Errors.notADir((Path)path));
            }
            try (Stream<Path> stream = Files.list(path);){
                if (stream.iterator().hasNext()) {
                    return;
                }
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readDirectory((Path)path));
            }
        }
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.deletePath((Path)path), (Throwable)e);
        }
    }

    private static void mkdirs(WildFlyPackageTasks tasks, Path installDir) throws ProvisioningException {
        for (String dirName : tasks.getMkDirs()) {
            try {
                Files.createDirectories(installDir.resolve(dirName), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.mkdirs((Path)installDir.resolve(dirName)));
            }
        }
    }

    private static void changeLineEndings(final WildFlyPackageTasks tasks, final Path installDir) throws ProvisioningException {
        if (tasks.getUnixLineEndFilters().isEmpty() && tasks.getWindowsLineEndFilters().isEmpty()) {
            return;
        }
        try {
            Files.walkFileTree(installDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String relative = installDir.relativize(file).toString();
                    for (FileFilter filter : tasks.getUnixLineEndFilters()) {
                        if (!filter.matches(relative)) continue;
                        try {
                            WfInstallPlugin.changeLineEndings(file, false);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(String.format("Failed to convert %s to Unix line endings.", file), e);
                        }
                    }
                    for (FileFilter filter : tasks.getWindowsLineEndFilters()) {
                        if (!filter.matches(relative)) continue;
                        try {
                            WfInstallPlugin.changeLineEndings(file, true);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(String.format("Failed to convert %s to Windows line endings.", file), e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (UncheckedIOException e) {
            throw new ProvisioningException(e.getMessage(), (Throwable)e.getCause());
        }
        catch (IOException e) {
            throw new ProvisioningException(String.format("Failed to process %s for files that require line ending changes.", installDir), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void changeLineEndings(Path file, boolean isWindows) throws IOException {
        String eol = isWindows ? "\r\n" : "\n";
        Path temp = Files.createTempFile(file.getFileName().toString(), ".tmp", new FileAttribute[0]);
        Files.copy(file, temp, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        try (BufferedReader reader = Files.newBufferedReader(temp, StandardCharsets.UTF_8);
             BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING);){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write(eol);
            }
        }
        finally {
            Files.delete(temp);
        }
    }

    void resolveMaven(MavenArtifact artifact) throws ProvisioningException {
        this.maven.resolve(artifact);
    }

    void resolveMaven(MavenArtifact artifact, String suffix) throws ProvisioningException {
        if (this.provisioningMavenRepo == null) {
            this.maven.resolve(artifact);
        } else {
            String grpid = artifact.getGroupId().replaceAll("\\.", Matcher.quoteReplacement(File.separator));
            Path grpidPath = this.provisioningMavenRepo.resolve(grpid);
            Path artifactidPath = grpidPath.resolve(artifact.getArtifactId());
            String version = artifact.getVersion() + suffix;
            Path versionPath = artifactidPath.resolve(version);
            String classifier = artifact.getClassifier() == null || artifact.getClassifier().isEmpty() ? null : artifact.getClassifier();
            Path localPath = versionPath.resolve(artifact.getArtifactId() + "-" + version + (classifier == null ? "" : "-" + classifier) + "." + artifact.getExtension());
            if (Files.exists(localPath, new LinkOption[0])) {
                artifact.setPath(localPath);
            } else {
                this.resolveMaven(artifact);
            }
        }
    }

    public static String getTransformedArtifactFileName(String version, String fileName, String suffix) {
        int endVersionIndex = fileName.lastIndexOf(version) + version.length();
        return fileName.substring(0, endVersionIndex) + suffix + fileName.substring(endVersionIndex);
    }

    boolean isOverriddenArtifact(MavenArtifact artifact) throws ProvisioningException {
        return Utils.containsArtifact(this.overriddenArtifactVersions, artifact);
    }

    static interface ArtifactResolver {
        public void resolve(MavenArtifact var1) throws ProvisioningException;
    }
}

