/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.wildfly.galleon.plugin.AbstractArtifactInstaller;
import org.wildfly.galleon.plugin.ArtifactCoords;
import org.wildfly.galleon.plugin.WfInstallPlugin;
import org.wildfly.galleon.plugin.transformer.JakartaTransformer;
import org.wildfly.galleon.plugin.transformer.TransformedArtifact;

abstract class AbstractEE9ArtifactInstaller
extends AbstractArtifactInstaller {
    private final Set<String> transformExcluded = new HashSet<String>();
    private final MessageWriter log;
    private final String jakartaTransformSuffix;
    private final Path jakartaTransformConfigsDir;
    private final JakartaTransformer.LogHandler logHandler;
    private final boolean jakartaTransformVerbose;
    private final ProvisioningRuntime runtime;
    private final WfInstallPlugin plugin;

    AbstractEE9ArtifactInstaller(WfInstallPlugin.ArtifactResolver resolver, Path generatedMavenRepo, Set<String> transformExcluded, WfInstallPlugin plugin, String jakartaTransformSuffix, Path jakartaTransformConfigsDir, JakartaTransformer.LogHandler logHandler, boolean jakartaTransformVerbose, ProvisioningRuntime runtime) {
        super(resolver, generatedMavenRepo);
        this.plugin = plugin;
        this.transformExcluded.addAll(transformExcluded);
        this.log = plugin.log;
        this.jakartaTransformSuffix = jakartaTransformSuffix;
        this.jakartaTransformConfigsDir = jakartaTransformConfigsDir;
        this.logHandler = logHandler;
        this.jakartaTransformVerbose = jakartaTransformVerbose;
        this.runtime = runtime;
    }

    protected TransformedArtifact transform(MavenArtifact artifact, Path targetDir) throws IOException {
        TransformedArtifact a = JakartaTransformer.transform(this.jakartaTransformConfigsDir, artifact.getPath(), targetDir, this.jakartaTransformVerbose, this.logHandler);
        return a;
    }

    protected boolean isOverriddenArtifact(MavenArtifact artifact) throws ProvisioningException {
        return this.plugin.isOverriddenArtifact(artifact);
    }

    protected boolean isExcludedFromTransformation(MavenArtifact artifact) {
        if (this.transformExcluded.contains(ArtifactCoords.newGav(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()).toString())) {
            if (this.log.isVerboseEnabled()) {
                this.log.verbose((CharSequence)("Excluding " + artifact + " from EE9 transformation"));
            }
            return true;
        }
        return false;
    }

    String getTransformedArtifactFileName(String version, String fileName) {
        int endVersionIndex = fileName.lastIndexOf(version) + version.length();
        return fileName.substring(0, endVersionIndex) + this.jakartaTransformSuffix + fileName.substring(endVersionIndex);
    }

    String getTransformedVersion(String version) {
        return version + this.jakartaTransformSuffix;
    }

    ProvisioningRuntime getRuntime() {
        return this.runtime;
    }

    Path setupOverriddenArtifact(MavenArtifact mavenArtifact) throws IOException, MavenUniverseException, ProvisioningException {
        String transformedFileName = this.getTransformedArtifactFileName(mavenArtifact.getVersion(), mavenArtifact.getPath().getFileName().toString());
        Path transformedFile = this.tryTransformation(mavenArtifact, transformedFileName);
        String gav = ArtifactCoords.newGav(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion()).toString();
        if (transformedFile == null) {
            this.transformExcluded.add(gav);
        }
        return transformedFile;
    }

    void excludeFromTransformation(MavenArtifact artifact) {
        String gav = ArtifactCoords.newGav(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()).toString();
        this.transformExcluded.add(gav);
    }

    private Path tryTransformation(MavenArtifact artifact, String transformedFileName) throws IOException {
        Path transformedFile = this.runtime.getTmpPath(new String[]{transformedFileName});
        Files.createDirectories(transformedFile, new FileAttribute[0]);
        Files.deleteIfExists(transformedFile);
        TransformedArtifact transformedArtifact = this.transform(artifact, transformedFile);
        if (!transformedArtifact.isTransformed()) {
            transformedFile = null;
        }
        return transformedFile;
    }
}

