/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.strings;

import aQute.lib.hex.Hex;
import aQute.libg.qtokens.QuotedTokenizer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Strings {
    private static final String COMMA = ",";
    private static final Pattern SIMPLE_LIST_SPLITTER = Pattern.compile("\\s*,\\s*");
    private static final Pattern SIMPLE_LINE_SPLITTER = Pattern.compile("\r?\n");

    public static String join(String middle, Iterable<?> objects) {
        if (objects == null) {
            return "";
        }
        return StreamSupport.stream(objects.spliterator(), false).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(middle));
    }

    public static String join(Iterable<?> objects) {
        return Strings.join(COMMA, objects);
    }

    public static String join(String middle, Iterable<?> objects, Pattern pattern, String replace) {
        if (pattern == null) {
            return Strings.join(middle, objects);
        }
        StringBuilder sb = new StringBuilder();
        Strings.join(sb, middle, objects, pattern, replace);
        return sb.toString();
    }

    public static void join(StringBuilder sb, String middle, Iterable<?> objects, Pattern pattern, String replace) {
        if (objects == null) {
            return;
        }
        String del = "";
        for (Object o : objects) {
            if (o == null) continue;
            sb.append(del);
            String s = o.toString();
            if (pattern != null) {
                Matcher matcher = pattern.matcher(s);
                if (!matcher.matches()) continue;
                s = matcher.replaceAll(replace);
            }
            sb.append(s);
            del = middle;
        }
    }

    public static String join(String middle, Object[] segments) {
        return Strings.join(middle, Arrays.asList(segments));
    }

    public static Collector<CharSequence, ?, String> joining() {
        return Collectors.joining(COMMA);
    }

    public static Collector<CharSequence, ?, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix, CharSequence emptyValue) {
        Function<StringJoiner, String> finisher = emptyValue != null ? joiner -> joiner.setEmptyValue(emptyValue).toString() : joiner -> {
            String emptyMarker = new String();
            String joined = joiner.setEmptyValue(emptyMarker).toString();
            return joined != emptyMarker ? joined : null;
        };
        return Collector.of(() -> new StringJoiner(delimiter, prefix, suffix), StringJoiner::add, StringJoiner::merge, finisher, new Collector.Characteristics[0]);
    }

    public static String display(Object o, Object ... ifNull) {
        if (o != null) {
            return o.toString();
        }
        for (int i = 0; i < ifNull.length; ++i) {
            if (ifNull[i] == null) continue;
            return ifNull[i].toString();
        }
        return "";
    }

    public static String join(String[] strings) {
        return Strings.join(Arrays.asList(strings));
    }

    public static String join(Object[] strings) {
        return Strings.join(Arrays.asList(strings));
    }

    public static String getLastSegment(String name, char c) {
        return name.substring(name.lastIndexOf(c) + 1);
    }

    public static String getLastSegment(String name) {
        return Strings.getLastSegment(name, '.');
    }

    public static String trim(String s) {
        int end;
        int start;
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return s;
        }
        for (start = 0; start < s.length() && Character.isWhitespace(s.charAt(start)); ++start) {
        }
        for (end = s.length(); end > start && Character.isWhitespace(s.charAt(end - 1)); --end) {
        }
        if (start == 0 && end == s.length()) {
            return s;
        }
        return s.substring(start, end);
    }

    public static boolean notEmpty(String s) {
        return !s.isEmpty();
    }

    public static boolean nonNullOrEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    public static boolean nonNullOrTrimmedEmpty(String s) {
        return s != null && !s.trim().isEmpty();
    }

    public static Stream<String> splitAsStream(String s) {
        return Strings.splitAsStream(s, SIMPLE_LIST_SPLITTER);
    }

    public static Stream<String> splitAsStream(String s, Pattern splitter) {
        if (s == null || (s = s.trim()).isEmpty()) {
            return Stream.empty();
        }
        return splitter.splitAsStream(s).filter(Strings::notEmpty);
    }

    public static List<String> split(String s) {
        return Strings.splitAsStream(s).collect(Collectors.toList());
    }

    public static List<String> split(String s, Pattern splitter) {
        return Strings.splitAsStream(s, splitter).collect(Collectors.toList());
    }

    public static Stream<String> splitQuotedAsStream(String s) {
        return Strings.splitQuotedAsStream(s, true);
    }

    public static Stream<String> splitQuotedAsStream(String s, String separators) {
        return Strings.splitQuotedAsStream(s, separators, true);
    }

    public static Stream<String> splitQuotedAsStream(String s, boolean retainQuotes) {
        return Strings.splitQuotedAsStream(s, COMMA, retainQuotes);
    }

    public static Stream<String> splitQuotedAsStream(String s, String separators, boolean retainQuotes) {
        if (s == null || (s = s.trim()).isEmpty()) {
            return Stream.empty();
        }
        return new QuotedTokenizer(s, separators, false, retainQuotes).stream().filter(Strings::notEmpty);
    }

    public static Stream<String> splitLinesAsStream(String s) {
        if (s == null) {
            return Stream.empty();
        }
        return SIMPLE_LINE_SPLITTER.splitAsStream(s);
    }

    public static List<String> splitLines(String s) {
        return Strings.splitLinesAsStream(s).collect(Collectors.toList());
    }

    public static List<String> splitQuoted(String s) {
        return Strings.splitQuotedAsStream(s).collect(Collectors.toList());
    }

    public static List<String> splitQuoted(String s, String separators) {
        return Strings.splitQuotedAsStream(s, separators).collect(Collectors.toList());
    }

    public static List<String> split(String regex, String s) {
        if (s == null || (s = s.trim()).isEmpty()) {
            return new ArrayList<String>();
        }
        return Strings.split(s, Pattern.compile(regex));
    }

    public static boolean in(String[] skip, String key) {
        for (String s : skip) {
            if (!key.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static char charAt(String s, int n) {
        return s.charAt(Strings.adjustBegin(s, n));
    }

    public static String from(String s, int n) {
        return s.substring(Strings.adjustBegin(s, n));
    }

    public static String substring(String s, int begin, int end) {
        return s.substring(Strings.adjustBegin(s, begin), Strings.adjustEnd(s, end));
    }

    public static String substring(String s, int begin, int end, int stride) {
        StringBuilder sb = new StringBuilder();
        begin = Strings.adjustBegin(s, begin);
        end = Strings.adjustEnd(s, end);
        if (stride == 0) {
            stride = 1;
        }
        if (stride < 0) {
            for (int i = end - 1; i >= begin; i += stride) {
                sb.append(s.charAt(i));
            }
        } else {
            for (int i = begin; i < end; i += stride) {
                sb.append(s.charAt(i));
            }
        }
        return sb.toString();
    }

    public static String delete(String s, int begin, int end) {
        return s.substring(0, Strings.adjustBegin(s, begin)) + s.substring(Strings.adjustEnd(s, end));
    }

    public static String to(String s, int end) {
        return s.substring(0, Strings.adjustEnd(s, end));
    }

    public static int adjustBegin(String s, int n) {
        if (n < 0) {
            n = s.length() + n;
        }
        return n;
    }

    public static int adjustEnd(String s, int n) {
        if (n <= 0) {
            n = s.length() + n;
        }
        return n;
    }

    public static String[] extension(String s) {
        return Strings.last(s, '.');
    }

    public static String[] lastPathSegment(String s) {
        return Strings.last(s, '/');
    }

    public static String[] last(String s, char separator) {
        int n = s.lastIndexOf(separator);
        if (n >= 0) {
            String[] answer = new String[]{s.substring(0, n), s.substring(n + 1)};
            return answer;
        }
        return null;
    }

    public static String[] first(String s, char separator) {
        int n = s.indexOf(separator);
        if (n >= 0) {
            String[] answer = new String[]{s.substring(0, n), s.substring(n + 1)};
            return answer;
        }
        return null;
    }

    public static String stripPrefix(String s, String prefix) {
        Pattern p = Pattern.compile(prefix);
        return Strings.stripPrefix(s, p);
    }

    public static String stripPrefix(String s, Pattern p) {
        Matcher matcher = p.matcher(s);
        if (matcher.lookingAt()) {
            return s.substring(matcher.end());
        }
        return null;
    }

    public static String stripSuffix(String s, String suffix) {
        Pattern p = Pattern.compile(suffix);
        return Strings.stripSuffix(s, p);
    }

    public static String stripSuffix(String s, Pattern p) {
        Matcher matcher = p.matcher(s);
        while (matcher.find()) {
            if (matcher.end() != s.length()) continue;
            return s.substring(0, matcher.start());
        }
        return null;
    }

    public static String ensureSuffix(String s, String suffix) {
        if (s.endsWith(suffix)) {
            return s;
        }
        return s + suffix;
    }

    public static String ensurePrefix(String s, String prefix) {
        if (s.startsWith(prefix)) {
            return s;
        }
        return prefix + s;
    }

    public static String times(String s, int times) {
        if (times <= 1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(times * s.length());
        for (int i = 0; i < times; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String format(String string, Object ... parms) {
        if (parms == null) {
            parms = new Object[]{};
        }
        return String.format(string, Strings.makePrintableArray(parms));
    }

    private static Object[] makePrintableArray(Object array) {
        int length = Array.getLength(array);
        Object[] output = new Object[length];
        for (int i = 0; i < length; ++i) {
            output[i] = Strings.makePrintable(Array.get(array, i));
        }
        return output;
    }

    private static Object makePrintable(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            return Arrays.toString(Strings.makePrintableArray(object));
        }
        return object;
    }

    public static boolean compareExcept(String a, String b, Pattern pattern) {
        Matcher ma = pattern.matcher(a);
        Matcher mb = pattern.matcher(b);
        int ra = 0;
        int rb = 0;
        while (ma.find()) {
            int sb;
            if (!mb.find()) {
                return false;
            }
            int sa = ma.start(1);
            if (sa - ra != (sb = mb.start(1)) - rb) {
                return false;
            }
            for (int i = 0; i < sa - ra; ++i) {
                if (a.charAt(ra + i) == b.charAt(rb + i)) continue;
                return false;
            }
            ra = ma.end() + 1;
            rb = mb.end() + 1;
        }
        if (a.length() - ra != b.length() - rb) {
            return false;
        }
        for (int i = 0; i < a.length() - ra; ++i) {
            if (a.charAt(ra + i) == b.charAt(rb + i)) continue;
            return false;
        }
        return true;
    }

    public static String toString(double n, String suffix) {
        boolean isByte = suffix.equals("b");
        if (isByte && n < 1.0) {
            throw new IllegalArgumentException("If bytes are used, then the value must be >= 1, it is " + n);
        }
        for (Magnitude m : Magnitude.values()) {
            if (m != Magnitude.exa && !(n < 1000.0 * m.one)) continue;
            String s = m == Magnitude.unit ? String.format("%.0f %s%s", n, m.prefix, suffix) : String.format("%.2f %s%s", n /= isByte ? (double)m.byteUnit : m.one, m.prefix, suffix);
            return s;
        }
        throw new IllegalArgumentException();
    }

    public static String escape(String string, Pattern illegalCharacters, char escape) {
        if (string == null) {
            return null;
        }
        assert (illegalCharacters != null) : "illegalCharacters is mandator";
        assert (illegalCharacters.matcher("" + escape).find()) : "the escape character must be in the set of illegalCharacters";
        Matcher m = illegalCharacters.matcher(string);
        if (!m.find()) {
            return string;
        }
        StringBuffer sb = new StringBuffer();
        do {
            m.appendReplacement(sb, "");
            for (int i = m.start(); i < m.end(); ++i) {
                char ch = string.charAt(i);
                sb.append(escape);
                Hex.append((Appendable)sb, ch);
            }
        } while (m.find());
        m.appendTail(sb);
        return sb.toString();
    }

    public static Optional<String> unescape(String string, char escape) {
        if (string == null) {
            return Optional.empty();
        }
        int n = string.indexOf(escape);
        if (n < 0) {
            return Optional.of(string);
        }
        StringBuffer sb = new StringBuffer();
        int start = 0;
        do {
            sb.append(string, start, n);
            if (n + 5 > string.length()) {
                return Optional.empty();
            }
            int ch = 0;
            for (int i = n + 1; i < n + 5; ++i) {
                char c = string.charAt(i);
                if (!Hex.isHexCharacter(c)) {
                    return Optional.empty();
                }
                int nibble = Hex.nibble(c);
                ch = (ch << 4) + nibble;
            }
            sb.append((char)ch);
        } while ((n = string.indexOf(escape, start = n + 5)) >= 0);
        sb.append(string, start, string.length());
        return Optional.of(sb.toString());
    }

    static enum Magnitude {
        quaco("g", 1.0E-23, 0L),
        zepto("z", 1.0E-21, 0L),
        atto("a", 1.0E-18, 0L),
        femto("f", 1.0E-15, 0L),
        pico("p", 1.0E-12, 0L),
        nano("n", 1.0E-9, 0L),
        micro("\u00b5", 1.0E-6, 0L),
        milli("m", 0.001, 0L),
        unit("", 1.0, 1L),
        kilo("k", 1000.0, 1024L),
        mega("M", 1000000.0, 0x100000L),
        giga("G", 1.0E9, 0x40000000L),
        tera("T", 1.0E12, 0x10000000000L),
        peta("P", 1.0E15, 0x4000000000000L),
        exa("E", 1.0E18, 0x1000000000000000L);

        final String prefix;
        final double one;
        final long byteUnit;

        private Magnitude(String prefix, double one, long byteUnit) {
            this.prefix = prefix;
            this.one = one;
            this.byteUnit = byteUnit;
        }
    }
}

