/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security.realms;

import java.util.Arrays;
import java.util.List;

public final class KerberosKeytab {
    private final String principal;
    private final String path;
    private final String relativeTo;
    private final List<String> forHosts;
    private final Boolean debug;

    private KerberosKeytab(Builder builder) {
        this.principal = builder.principal;
        this.path = builder.path;
        this.relativeTo = builder.relativeTo;
        this.forHosts = builder.forHosts;
        this.debug = builder.debug;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getPath() {
        return this.path;
    }

    public String getRelativeTo() {
        return this.relativeTo;
    }

    public List<String> getForHosts() {
        return this.forHosts;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public static final class Builder {
        private String principal;
        private String path;
        private String relativeTo;
        private List<String> forHosts;
        private Boolean debug;

        public Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder relativeTo(String relativeTo) {
            this.relativeTo = relativeTo;
            return this;
        }

        public Builder validForHosts(String ... forHosts) {
            if (forHosts != null && forHosts.length > 0) {
                this.forHosts = Arrays.asList(forHosts);
            }
            return this;
        }

        public Builder validForAllHosts() {
            this.validForHosts("*");
            return this;
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public KerberosKeytab build() {
            if (this.principal == null) {
                throw new IllegalArgumentException("Principal of the kerberos keytab must be specified as non null value");
            }
            if (this.principal.isEmpty()) {
                throw new IllegalArgumentException("Principal of the kerberos keytab must not be empty value");
            }
            return new KerberosKeytab(this);
        }
    }
}

