/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security.realms;

import java.io.IOException;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public final class AddSecurityRealm
implements OnlineCommand,
OfflineCommand {
    private final String securityRealmName;
    private final Boolean mapGroupsToRoles;
    private final boolean replaceExisting;

    private AddSecurityRealm(Builder builder) {
        this.securityRealmName = builder.securityRealmName;
        this.mapGroupsToRoles = builder.mapGroupsToRoles;
        this.replaceExisting = builder.replaceExisting;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Operations ops = new Operations(ctx.client);
        Address securityRealmAddress = Address.coreService((String)"management").and("security-realm", this.securityRealmName);
        if (this.replaceExisting) {
            try {
                ops.removeIfExists(securityRealmAddress);
                new Administration(ctx.client).reloadIfRequired();
            }
            catch (OperationException e) {
                throw new IOException("Failed to remove existing security realm " + this.securityRealmName, e);
            }
        }
        ops.add(securityRealmAddress, Values.empty().andOptional("map-groups-to-roles", this.mapGroupsToRoles));
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddSecurityRealm.class).subtree("management", Subtree.management()).parameter("atrSecurityRealmName", this.securityRealmName).parameter("atrMapGroupsToRoles", this.mapGroupsToRoles).parameter("atrReplaceExisting", this.replaceExisting).build()});
    }

    public static final class Builder {
        private String securityRealmName;
        private Boolean mapGroupsToRoles;
        private boolean replaceExisting;

        public Builder(String securityRealmName) {
            if (securityRealmName == null) {
                throw new IllegalArgumentException("Name of the security-realm must be specified as non null value");
            }
            if (securityRealmName.isEmpty()) {
                throw new IllegalArgumentException("Name of the security-realm must not be empty value");
            }
            this.securityRealmName = securityRealmName;
        }

        public Builder mapGroupsToRoles(Boolean mapGroupsToRoles) {
            this.mapGroupsToRoles = mapGroupsToRoles;
            return this;
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        public AddSecurityRealm build() {
            return new AddSecurityRealm(this);
        }
    }
}

