/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.foundation.offline.xml;

import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import groovy.xml.XmlUtil;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.FirstLevelXmlElementOrder;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyHolder;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.TransformationScript;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;

public final class GroovyXmlTransform
implements OfflineCommand {
    private final TransformationScript script;
    private final Map<String, Subtree> subtrees;
    private final Map<String, Object> parameters;
    private final boolean entireFile;

    public static Builder of(Class clazz) {
        return GroovyXmlTransform.of(clazz, clazz.getSimpleName() + ".groovy");
    }

    public static Builder of(Class resourceLoader, String path) {
        if (resourceLoader == null) {
            throw new IllegalArgumentException("A class for loading the script must be provided");
        }
        if (path == null) {
            throw new IllegalArgumentException("A path to the script must be provided");
        }
        return new Builder(new TransformationScript(resourceLoader, path));
    }

    private GroovyXmlTransform(TransformationScript script, Map<String, Subtree> subtrees, Map<String, Object> parameters, boolean entireFile) {
        if (entireFile && !subtrees.isEmpty()) {
            throw new IllegalArgumentException("The 'entireFile' mode is only possible without subtrees");
        }
        if (entireFile && parameters.containsKey("file")) {
            throw new IllegalArgumentException("Parameter 'file' is reserved in 'entireFile' mode");
        }
        if (!entireFile && subtrees.isEmpty() && parameters.containsKey("root")) {
            throw new IllegalArgumentException("Parameter 'root' is reserved when no subtree is specified");
        }
        HashSet<String> keysIntersection = new HashSet<String>(subtrees.keySet());
        keysIntersection.retainAll(parameters.keySet());
        if (!keysIntersection.isEmpty()) {
            throw new IllegalArgumentException("Collision between subtrees and parameters: " + keysIntersection);
        }
        this.script = script;
        this.subtrees = subtrees;
        this.parameters = parameters;
        this.entireFile = entireFile;
    }

    public void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
        Script loadedScript;
        GroovyCodeSource codeSource;
        URL url = this.script.url();
        if (url == null) {
            throw new CommandFailedException("Couldn't load " + this.script);
        }
        try {
            codeSource = new GroovyCodeSource(url);
        }
        catch (IOException e) {
            throw new CommandFailedException((Throwable)e);
        }
        Class clazz = GroovyHolder.GROOVY.parseClass(codeSource);
        if (!Script.class.isAssignableFrom(clazz)) {
            throw new CommandFailedException("Not a valid Groovy script: " + this.script);
        }
        try {
            loadedScript = (Script)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new CommandFailedException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CommandFailedException((Throwable)e);
        }
        for (Map.Entry<String, Object> parameter : this.parameters.entrySet()) {
            loadedScript.setProperty(parameter.getKey(), parameter.getValue());
        }
        if (this.entireFile) {
            loadedScript.setProperty("file", (Object)ctx.configurationFile);
            loadedScript.run();
        } else {
            try {
                GPathResult root = new XmlSlurper(false, false).parse(ctx.configurationFile);
                if (this.subtrees.isEmpty()) {
                    loadedScript.setProperty("root", (Object)root);
                } else {
                    for (Subtree subtree : this.subtrees.values()) {
                        subtree.addIfMissing(root, ctx.options);
                    }
                    String fixedXml = FirstLevelXmlElementOrder.fix(XmlUtil.serialize((GPathResult)root));
                    root = new XmlSlurper(false, false).parseText(fixedXml);
                    for (Map.Entry<String, Subtree> subtree : this.subtrees.entrySet()) {
                        loadedScript.setProperty(subtree.getKey(), (Object)subtree.getValue().locate(root, ctx.options));
                    }
                }
                loadedScript.run();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(ctx.configurationFile), "utf-8"));
                XmlUtil.serialize((GPathResult)root, (Writer)writer);
                ((Writer)writer).close();
            }
            catch (Exception e) {
                throw new CommandFailedException((Throwable)e);
            }
        }
    }

    public String toString() {
        return "GroovyXmlTransform " + this.script.toString();
    }

    public static final class Builder {
        private final TransformationScript script;
        private final Map<String, Subtree> subtrees = new HashMap<String, Subtree>();
        private final Map<String, Object> parameters = new HashMap<String, Object>();
        private boolean entireFile = false;

        private Builder(TransformationScript script) {
            this.script = script;
        }

        public Builder subtree(String name, Subtree subtree) {
            this.subtrees.put(name, subtree);
            return this;
        }

        public Builder parameter(String name, Object value) {
            this.parameters.put(name, value);
            return this;
        }

        public Builder parameters(Map<String, Object> parameters) {
            this.parameters.putAll(parameters);
            return this;
        }

        Builder entireFile() {
            this.entireFile = true;
            return this;
        }

        public GroovyXmlTransform build() {
            return new GroovyXmlTransform(this.script, this.subtrees, this.parameters, this.entireFile);
        }
    }
}

