/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.domain;

import java.io.IOException;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public class AddJvmConfiguration
implements OnlineCommand {
    private final Address parentAddress;
    private final String jvmName;
    private final String maxHeapSize;
    private final String heapSize;
    private final String permgenSize;
    private final String maxPermgenSize;
    private final String javaHome;
    private final JvmType type;

    private AddJvmConfiguration(Builder builder) {
        this.parentAddress = builder.parentAddress;
        this.jvmName = builder.jvmName;
        this.maxHeapSize = builder.maxHeapSize;
        this.heapSize = builder.heapSize;
        this.permgenSize = builder.permgenSize;
        this.maxPermgenSize = builder.maxPermgenSize;
        this.javaHome = builder.javaHome;
        this.type = builder.type;
    }

    public void apply(OnlineCommandContext ctx) throws CommandFailedException, IOException {
        if (!ctx.client.options().isDomain) {
            throw new CommandFailedException("This command only makes sense in domain");
        }
        Operations ops = new Operations(ctx.client);
        ops.add(this.parentAddress.and("jvm", this.jvmName), Values.empty().andOptional("max-heap-size", this.maxHeapSize).andOptional("heap-size", this.heapSize).andOptional("permgen-size", this.permgenSize).andOptional("max-permgen-size", this.maxPermgenSize).andOptional("java-home", this.javaHome).andOptional("type", this.type != null ? this.type.toString() : null));
    }

    public static final class Builder {
        private String jvmName;
        private String maxHeapSize;
        private String heapSize;
        private String permgenSize;
        private String maxPermgenSize;
        private String javaHome;
        private JvmType type;
        private Address parentAddress;

        public Builder(Address parentAddress, String jvmName) {
            if (parentAddress == null) {
                throw new IllegalArgumentException("parentAddress must be specified as non null value");
            }
            if (jvmName == null) {
                throw new IllegalArgumentException("Name of the jvm must be specified as non null value");
            }
            this.parentAddress = parentAddress;
            this.jvmName = jvmName;
        }

        public Builder heapSize(String heapSize) {
            this.heapSize = heapSize;
            return this;
        }

        public Builder maxHeapSize(String maxHeapSize) {
            this.maxHeapSize = maxHeapSize;
            return this;
        }

        public Builder permgenSize(String permgenSize) {
            this.permgenSize = permgenSize;
            return this;
        }

        public Builder maxPermgenSize(String maxPermgenSize) {
            this.maxPermgenSize = maxPermgenSize;
            return this;
        }

        public Builder type(JvmType type) {
            this.type = type;
            return this;
        }

        public Builder javaHome(String javaHome) {
            this.javaHome = javaHome;
            return this;
        }

        public AddJvmConfiguration build() {
            return new AddJvmConfiguration(this);
        }
    }

    public static enum JvmType {
        SUN,
        IBM,
        OTHER;

    }
}

