/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.deployments;

import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;

public final class Undeploy
implements OnlineCommand {
    private final String deploymentName;
    private final boolean keepContent;

    private Undeploy(Builder builder) {
        this.deploymentName = builder.deploymentName;
        this.keepContent = builder.keepContent;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        StringBuilder cmd = new StringBuilder("undeploy ").append(this.deploymentName);
        if (this.keepContent) {
            cmd.append(" --keep-content");
        }
        if (ctx.options.isDomain) {
            cmd.append(" --all-relevant-server-groups");
        }
        ctx.client.executeCli(cmd.toString());
    }

    public static final class Builder {
        private String deploymentName;
        private boolean keepContent = false;

        public Builder(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        public Builder keepContent() {
            this.keepContent = true;
            return this;
        }

        public Undeploy build() {
            return new Undeploy(this);
        }
    }
}

