/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.webbitserver.WebSocket;
import org.webbitserver.WebSocketHandler;
import org.webbitserver.WebbitException;
import org.webbitserver.handler.ReconnectingWebSocketHandler;
import org.webbitserver.handler.exceptions.PrintStackTraceExceptionHandler;
import org.webbitserver.handler.exceptions.SilentExceptionHandler;
import org.webbitserver.helpers.Base64;
import org.webbitserver.helpers.SslFactory;
import org.webbitserver.netty.CatchingRunnable;
import org.webbitserver.netty.ConnectionHelper;
import org.webbitserver.netty.HybiWebSocketFrameDecoder;
import org.webbitserver.netty.HybiWebSocketFrameEncoder;
import org.webbitserver.netty.NettyHttpRequest;
import org.webbitserver.netty.NettyWebSocketConnection;
import org.webbitserver.netty.WebSocketConnectionHandler;

public class WebSocketClient
implements WebSocket {
    private static final int VERSION = 13;
    private static final String ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final MessageDigest SHA_1;
    private static long nextId;
    private final URI uri;
    private WebSocketHandler webSocketHandler;
    private final Executor executor;
    private final InetSocketAddress remoteAddress;
    private final HttpRequest request;
    private final boolean ssl;
    private ConnectionHelper connectionHelper;
    private ClientBootstrap bootstrap;
    private Channel channel;
    private String base64Nonce;
    private Thread.UncaughtExceptionHandler exceptionHandler;
    private Thread.UncaughtExceptionHandler ioExceptionHandler;
    private SslFactory sslFactory;

    public WebSocketClient(URI uri, WebSocketHandler webSocketHandler) {
        this(uri, webSocketHandler, Executors.newSingleThreadExecutor());
    }

    public WebSocketClient(URI uri, WebSocketHandler webSocketHandler, Executor executor) {
        this.uri = uri;
        this.webSocketHandler = webSocketHandler;
        this.executor = executor;
        String scheme = uri.getScheme() == null ? "ws" : uri.getScheme();
        String host = uri.getHost() == null ? "localhost" : uri.getHost();
        int port = uri.getPort();
        this.ssl = scheme.equalsIgnoreCase("wss");
        if (port == -1) {
            if (scheme.equalsIgnoreCase("ws")) {
                port = 80;
            } else if (this.ssl) {
                port = 443;
            }
        }
        this.remoteAddress = new InetSocketAddress(host, port);
        this.request = this.createNettyHttpRequest(this.getPath(uri), host);
        this.uncaughtExceptionHandler(new PrintStackTraceExceptionHandler());
        this.connectionExceptionHandler(new SilentExceptionHandler());
    }

    private String getPath(URI uri) {
        String path = uri.getPath();
        return "".equals(path) ? "/" : path;
    }

    @Override
    public WebSocketClient uncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.exceptionHandler = handler;
        this.connectionHelper = this.createConnectionHelper();
        return this;
    }

    @Override
    public WebSocketClient connectionExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.ioExceptionHandler = handler;
        this.connectionHelper = this.createConnectionHelper();
        return this;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    private ConnectionHelper createConnectionHelper() {
        return new ConnectionHelper(this.executor, this.exceptionHandler, this.ioExceptionHandler){

            @Override
            protected void fireOnClose() throws Exception {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public WebSocketClient setupSsl(InputStream keyStore, String storePass) {
        this.sslFactory = new SslFactory(keyStore, storePass);
        return this;
    }

    @Override
    public Future<WebSocketClient> start() {
        FutureTask<WebSocketClient> future = new FutureTask<WebSocketClient>(new Callable<WebSocketClient>(){

            @Override
            public WebSocketClient call() throws Exception {
                final byte[] outboundMaskingKey = new byte[]{WebSocketClient.this.randomByte(), WebSocketClient.this.randomByte(), WebSocketClient.this.randomByte(), WebSocketClient.this.randomByte()};
                WebSocketClient.this.bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
                WebSocketClient.this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

                    public ChannelPipeline getPipeline() throws Exception {
                        ChannelPipeline pipeline = Channels.pipeline();
                        if (WebSocketClient.this.ssl) {
                            if (WebSocketClient.this.sslFactory == null) {
                                throw new WebbitException("You need to call setupSsl first");
                            }
                            SSLContext sslContext = WebSocketClient.this.sslFactory.getClientContext();
                            SSLEngine sslEngine = sslContext.createSSLEngine();
                            sslEngine.setUseClientMode(true);
                            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                        }
                        pipeline.addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
                        pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
                        pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
                        pipeline.addLast("handshakeHandler", (ChannelHandler)new HandshakeChannelHandler(outboundMaskingKey));
                        return pipeline;
                    }
                });
                ChannelFuture future = WebSocketClient.this.bootstrap.connect((SocketAddress)WebSocketClient.this.remoteAddress);
                WebSocketClient.this.channel = future.awaitUninterruptibly().getChannel();
                if (!future.isSuccess()) {
                    WebSocketClient.this.stop();
                } else {
                    ChannelFuture requestFuture = WebSocketClient.this.channel.write((Object)WebSocketClient.this.request);
                    requestFuture.awaitUninterruptibly();
                }
                return WebSocketClient.this;
            }
        });
        this.executor.execute(future);
        return future;
    }

    private HttpRequest createNettyHttpRequest(String uri, String host) {
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri);
        request.setHeader("Host", (Object)host);
        request.setHeader("Connection", (Object)"Upgrade");
        request.setHeader("Upgrade", (Object)"websocket");
        request.setHeader("Accept-Encoding", (Object)"gzip");
        request.setHeader("Sec-WebSocket-Version", (Object)13);
        this.base64Nonce = this.base64Nonce();
        request.setHeader("Sec-WebSocket-Key", (Object)this.base64Nonce);
        return request;
    }

    private String base64Nonce() {
        byte[] nonce = new byte[16];
        for (int i = 0; i < 16; ++i) {
            nonce[i] = this.randomByte();
        }
        return Base64.encode(nonce);
    }

    private byte randomByte() {
        return (byte)(Math.random() * 256.0);
    }

    @Override
    public Future<WebSocketClient> stop() {
        FutureTask<WebSocketClient> future = new FutureTask<WebSocketClient>(new Callable<WebSocketClient>(){

            @Override
            public WebSocketClient call() throws Exception {
                try {
                    WebSocketClient.this.channel.getCloseFuture().awaitUninterruptibly();
                    WebSocketClient.this.bootstrap.releaseExternalResources();
                    WebSocketClient.this.webSocketHandler.onClose(null);
                }
                catch (Throwable e) {
                    WebSocketClient.this.exceptionHandler.uncaughtException(Thread.currentThread(), WebbitException.fromException(e, WebSocketClient.this.channel));
                }
                return WebSocketClient.this;
            }
        });
        this.executor.execute(future);
        return future;
    }

    @Override
    public WebSocketClient reconnectEvery(long reconnectIntervalMillis) {
        this.webSocketHandler = new ReconnectingWebSocketHandler(this.webSocketHandler, this, reconnectIntervalMillis);
        return this;
    }

    private static Object nextId() {
        return nextId++;
    }

    static {
        try {
            SHA_1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("SHA-1 not supported on this platform");
        }
        nextId = 1L;
    }

    private class HandshakeChannelHandler
    extends SimpleChannelUpstreamHandler {
        private final byte[] outboundMaskingKey;

        public HandshakeChannelHandler(byte[] outboundMaskingKey) {
            this.outboundMaskingKey = outboundMaskingKey;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            WebSocketClient.this.connectionHelper.fireConnectionException(e);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            HttpResponse response = (HttpResponse)e.getMessage();
            String webSocketAccept = response.getHeader("Sec-WebSocket-Accept");
            this.verifySecWebSocketAccept(webSocketAccept);
            this.adjustPipelineToWebSocket(ctx, e, (ChannelHandler)HybiWebSocketFrameDecoder.clientSide(this.outboundMaskingKey), (ChannelHandler)new HybiWebSocketFrameEncoder());
        }

        private void verifySecWebSocketAccept(String webSocketAccept) {
            if (webSocketAccept != null) {
                SHA_1.reset();
                SHA_1.update(WebSocketClient.this.base64Nonce.getBytes());
                SHA_1.update(WebSocketClient.ACCEPT_GUID.getBytes());
                String expectedKey = Base64.encode(SHA_1.digest());
                if (!webSocketAccept.equals(expectedKey)) {
                    throw new WebbitException("Sec-WebSocket-Accept header from server didn't match expected value of " + expectedKey);
                }
            } else {
                throw new WebbitException("Expected Sec-WebSocket-Accept header from server");
            }
        }

        private void adjustPipelineToWebSocket(ChannelHandlerContext ctx, MessageEvent messageEvent, ChannelHandler webSocketFrameDecoder, ChannelHandler webSocketFrameEncoder) {
            NettyHttpRequest httpRequest = new NettyHttpRequest(messageEvent, WebSocketClient.this.request, WebSocketClient.nextId(), this.timestamp());
            final NettyWebSocketConnection webSocketConnection = new NettyWebSocketConnection(WebSocketClient.this.executor, httpRequest, ctx, this.outboundMaskingKey);
            webSocketConnection.setHybiWebSocketVersion(13);
            WebSocketConnectionHandler webSocketChannelHandler = new WebSocketConnectionHandler(WebSocketClient.this.executor, WebSocketClient.this.exceptionHandler, WebSocketClient.this.ioExceptionHandler, webSocketConnection, WebSocketClient.this.webSocketHandler);
            ChannelPipeline p = ctx.getChannel().getPipeline();
            p.remove("inflater");
            p.replace("decoder", "wsdecoder", webSocketFrameDecoder);
            p.replace("encoder", "wsencoder", webSocketFrameEncoder);
            p.replace("handshakeHandler", "wshandler", (ChannelHandler)webSocketChannelHandler);
            WebSocketClient.this.executor.execute(new CatchingRunnable(WebSocketClient.this.exceptionHandler){

                @Override
                public void go() throws Throwable {
                    WebSocketClient.this.webSocketHandler.onOpen(webSocketConnection);
                }
            });
        }

        private long timestamp() {
            return System.currentTimeMillis();
        }
    }
}

