/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;

public class ConnectionTrackingHandler
extends SimpleChannelHandler {
    private final ChannelGroup openConnections = new DefaultChannelGroup();
    private final ReadWriteLock closingLock = new ReentrantReadWriteLock();
    private volatile boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.closingLock.readLock().lock();
        try {
            if (this.closed) {
                e.getChannel().close();
            } else {
                this.openConnections.add((Object)e.getChannel());
            }
        }
        finally {
            this.closingLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConnections() {
        this.closingLock.writeLock().lock();
        try {
            this.closed = true;
        }
        finally {
            this.closingLock.writeLock().unlock();
        }
        this.openConnections.close();
    }
}

