/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.quorum.enclave.protocol.utils;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0016\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J,\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u00a8\u0006\f"}, d2={"Lorg/web3j/quorum/enclave/protocol/utils/RequestBuilder;", "", "()V", "encodeGetRequest", "", "path", "encodeJsonRequest", "payload", "encodeRawJsonRequest", "from", "to", "", "web3j-quorum"})
public final class RequestBuilder {
    @NotNull
    public static final RequestBuilder INSTANCE = new RequestBuilder();

    private RequestBuilder() {
    }

    @NotNull
    public final String encodeRawJsonRequest(@NotNull String path, @NotNull String payload, @NotNull String from, @NotNull List<String> to) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        int length = payload.length();
        String toString = CollectionsKt.joinToString$default((Iterable)to, null, null, null, (int)0, null, null, (int)63, null);
        return StringsKt.trimIndent((String)("\n            POST /" + path + " HTTP/1.1\n            Host: k\n            User-Agent: constellation-client\n            Content-Type: application/json\n            Content-Length: " + length + "\n            c11n-from: " + from + "\n            c11n-to: " + toString + "\n\n            " + payload + "\n        "));
    }

    @NotNull
    public final String encodeJsonRequest(@NotNull String path, @NotNull String payload) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        int length = payload.length();
        return StringsKt.trimIndent((String)("\n            POST /" + path + " HTTP/1.1\n            Host: k\n            User-Agent: constellation-client\n            Content-Type: application/json\n            Content-Length: " + length + "\n\n            " + payload + "\n        "));
    }

    @NotNull
    public final String encodeGetRequest(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.trimIndent((String)("\n            GET /" + path + " HTTP/1.1\n            Host: k\n            User-Agent: constellation-client\n\n        "));
    }
}

