/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.quorum.enclave.protocol;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.web3j.quorum.enclave.EnclaveClientConnectionException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ5\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u000f2\u0006\u0010\u0011\u001a\u0002H\u00102\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0014\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/web3j/quorum/enclave/protocol/EnclaveService;", "", "url", "", "port", "", "client", "Lokhttp3/OkHttpClient;", "(Ljava/lang/String;ILokhttp3/OkHttpClient;)V", "JSON_MEDIA_TYPE", "Lokhttp3/MediaType;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "send", "T", "S", "request", "path", "responseType", "Ljava/lang/Class;", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "web3j-quorum"})
public final class EnclaveService {
    @NotNull
    private final String url;
    private final int port;
    @NotNull
    private final OkHttpClient client;
    private final ObjectMapper objectMapper;
    @Nullable
    private final MediaType JSON_MEDIA_TYPE;

    public EnclaveService(@NotNull String url, int port, @NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.url = url;
        this.port = port;
        this.client = client;
        this.objectMapper = ExtensionsKt.jacksonObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.JSON_MEDIA_TYPE = MediaType.Companion.parse("application/json; charset=utf-8");
    }

    public /* synthetic */ EnclaveService(String string, int n, OkHttpClient okHttpClient, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            okHttpClient = new OkHttpClient();
        }
        this(string, n, okHttpClient);
    }

    public final <S, T> T send(S request, @NotNull String path, @NotNull Class<T> responseType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(responseType, (String)"responseType");
        String payload = this.objectMapper.writeValueAsString(request);
        String uri = this.url + ":" + this.port + "/" + path;
        Intrinsics.checkNotNullExpressionValue((Object)payload, (String)"payload");
        RequestBody body = RequestBody.Companion.create(payload, this.JSON_MEDIA_TYPE);
        Request buildRequest = new Request.Builder().url(uri).post(body).build();
        Response response = this.client.newCall(buildRequest).execute();
        if (response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            String chunk = responseBody != null ? responseBody.string() : null;
            return (T)this.objectMapper.readValue(chunk, responseType);
        }
        int statusCode = response.code();
        if (response.body() == null) {
            string = "N/A";
        } else {
            ResponseBody responseBody = response.body();
            string = responseBody != null ? responseBody.string() : null;
        }
        String text = string;
        throw new EnclaveClientConnectionException("Invalid response received from enclave: " + statusCode + " " + text);
    }

    @NotNull
    public final String send(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String serverUri = this.url + ":" + this.port + "/" + path;
        Request request = new Request.Builder().url(serverUri).get().build();
        Response response = this.client.newCall(request).execute();
        Object object = response.body();
        if (object == null || (object = object.string()) == null) {
            object = "";
        }
        return object;
    }
}

