/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.videolan.libvlc.util.AndroidUtil;

public class HWDecoderUtil {
    private static final DecoderBySOC[] sBlacklistedDecoderBySOCList = new DecoderBySOC[]{new DecoderBySOC("ro.product.board", "MSM8225", Decoder.NONE), new DecoderBySOC("ro.product.board", "hawaii", Decoder.NONE)};
    private static final DecoderBySOC[] sDecoderBySOCList = new DecoderBySOC[]{new DecoderBySOC("ro.product.brand", "SEMC", Decoder.NONE), new DecoderBySOC("ro.board.platform", "msm7627", Decoder.NONE), new DecoderBySOC("ro.product.brand", "Amazon", Decoder.MEDIACODEC), new DecoderBySOC("ro.board.platform", "omap3", Decoder.OMX), new DecoderBySOC("ro.board.platform", "rockchip", Decoder.OMX), new DecoderBySOC("ro.board.platform", "rk29", Decoder.OMX), new DecoderBySOC("ro.board.platform", "msm7630", Decoder.OMX), new DecoderBySOC("ro.board.platform", "s5pc", Decoder.OMX), new DecoderBySOC("ro.board.platform", "montblanc", Decoder.OMX), new DecoderBySOC("ro.board.platform", "exdroid", Decoder.OMX), new DecoderBySOC("ro.board.platform", "sun6i", Decoder.OMX), new DecoderBySOC("ro.board.platform", "exynos4", Decoder.MEDIACODEC), new DecoderBySOC("ro.board.platform", "omap4", Decoder.ALL), new DecoderBySOC("ro.board.platform", "tegra", Decoder.ALL), new DecoderBySOC("ro.board.platform", "tegra3", Decoder.ALL), new DecoderBySOC("ro.board.platform", "msm8660", Decoder.ALL), new DecoderBySOC("ro.board.platform", "exynos5", Decoder.ALL), new DecoderBySOC("ro.board.platform", "rk30", Decoder.ALL), new DecoderBySOC("ro.board.platform", "rk31", Decoder.ALL), new DecoderBySOC("ro.board.platform", "mv88de3100", Decoder.ALL), new DecoderBySOC("ro.hardware", "mt83", Decoder.ALL)};
    private static final AudioOutputBySOC[] sAudioOutputBySOCList = new AudioOutputBySOC[]{new AudioOutputBySOC("ro.product.brand", "Amazon", AudioOutput.OPENSLES), new AudioOutputBySOC("ro.product.manufacturer", "Amazon", AudioOutput.OPENSLES)};
    private static final HashMap<String, String> sSystemPropertyMap = new HashMap();

    public static Decoder getDecoderFromDevice() {
        String prop;
        for (DecoderBySOC decBySOC : sBlacklistedDecoderBySOCList) {
            prop = HWDecoderUtil.getSystemPropertyCached(decBySOC.key);
            if (prop == null || !prop.contains(decBySOC.value)) continue;
            return decBySOC.dec;
        }
        if (AndroidUtil.isJellyBeanMR2OrLater) {
            return Decoder.ALL;
        }
        for (DecoderBySOC decBySOC : sDecoderBySOCList) {
            prop = HWDecoderUtil.getSystemPropertyCached(decBySOC.key);
            if (prop == null || !prop.contains(decBySOC.value)) continue;
            return decBySOC.dec;
        }
        return Decoder.UNKNOWN;
    }

    public static AudioOutput getAudioOutputFromDevice() {
        for (AudioOutputBySOC aoutBySOC : sAudioOutputBySOCList) {
            String prop = HWDecoderUtil.getSystemPropertyCached(aoutBySOC.key);
            if (prop == null || !prop.contains(aoutBySOC.value)) continue;
            return aoutBySOC.aout;
        }
        return AudioOutput.ALL;
    }

    private static String getSystemPropertyCached(String key) {
        String prop = sSystemPropertyMap.get(key);
        if (prop == null) {
            prop = HWDecoderUtil.getSystemProperty(key, "none");
            sSystemPropertyMap.put(key, prop);
        }
        return prop;
    }

    private static String getSystemProperty(String key, String def) {
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            Class<?> SystemProperties = cl.loadClass("android.os.SystemProperties");
            Class[] paramTypes = new Class[]{String.class, String.class};
            Method get = SystemProperties.getMethod("get", paramTypes);
            Object[] params = new Object[]{key, def};
            return (String)get.invoke(SystemProperties, params);
        }
        catch (Exception e) {
            return def;
        }
    }

    private static class AudioOutputBySOC {
        public final String key;
        public final String value;
        public final AudioOutput aout;

        public AudioOutputBySOC(String key, String value, AudioOutput aout) {
            this.key = key;
            this.value = value;
            this.aout = aout;
        }
    }

    private static class DecoderBySOC {
        public final String key;
        public final String value;
        public final Decoder dec;

        public DecoderBySOC(String key, String value, Decoder dec) {
            this.key = key;
            this.value = value;
            this.dec = dec;
        }
    }

    public static enum AudioOutput {
        OPENSLES,
        ALL;

    }

    public static enum Decoder {
        UNKNOWN,
        NONE,
        OMX,
        MEDIACODEC,
        ALL;

    }
}

