/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc.util;

import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.MainThread;
import java.util.ArrayList;
import org.videolan.libvlc.FactoryManager;
import org.videolan.libvlc.MediaDiscoverer;
import org.videolan.libvlc.MediaList;
import org.videolan.libvlc.interfaces.ILibVLC;
import org.videolan.libvlc.interfaces.IMedia;
import org.videolan.libvlc.interfaces.IMediaFactory;
import org.videolan.libvlc.interfaces.IMediaList;

public class MediaBrowser {
    private static final String TAG = "MediaBrowser";
    private final ILibVLC mILibVlc;
    private final ArrayList<MediaDiscoverer> mMediaDiscoverers = new ArrayList();
    private final ArrayList<IMedia> mDiscovererMediaArray = new ArrayList();
    private IMediaList mBrowserMediaList;
    private IMedia mMedia;
    private EventListener mEventListener;
    private Handler mHandler;
    private boolean mAlive;
    private IMediaFactory mFactory;
    private static final String IGNORE_LIST_OPTION = ":ignore-filetypes=";
    private String mIgnoreList = "db,nfo,ini,jpg,jpeg,ljpg,gif,png,pgm,pgmyuv,pbm,pam,tga,bmp,pnm,xpm,xcf,pcx,tif,tiff,lbm,sfv,txt,sub,idx,srt,ssa,ass,smi,utf,utf-8,rt,aqt,txt,usf,jss,cdg,psb,mpsub,mpl2,pjs,dks,stl,vtt,ttml";
    private final IMediaList.EventListener mBrowserMediaListEventListener = new IMediaList.EventListener(){

        @Override
        public void onEvent(IMediaList.Event event) {
            if (MediaBrowser.this.mEventListener == null) {
                return;
            }
            IMediaList.Event mlEvent = event;
            switch (mlEvent.type) {
                case 512: {
                    MediaBrowser.this.mEventListener.onMediaAdded(mlEvent.index, mlEvent.media);
                    break;
                }
                case 514: {
                    MediaBrowser.this.mEventListener.onMediaRemoved(mlEvent.index, mlEvent.media);
                    break;
                }
                case 516: {
                    MediaBrowser.this.mEventListener.onBrowseEnd();
                }
            }
        }
    };
    private final IMediaList.EventListener mDiscovererMediaListEventListener = new IMediaList.EventListener(){

        @Override
        public void onEvent(IMediaList.Event event) {
            if (MediaBrowser.this.mEventListener == null) {
                return;
            }
            IMediaList.Event mlEvent = event;
            int index = -1;
            switch (mlEvent.type) {
                case 512: {
                    MediaBrowser.this.mDiscovererMediaArray.add(mlEvent.media);
                    MediaBrowser.this.mEventListener.onMediaAdded(index, mlEvent.media);
                    break;
                }
                case 514: {
                    index = MediaBrowser.this.mDiscovererMediaArray.indexOf(mlEvent.media);
                    if (index != -1) {
                        MediaBrowser.this.mDiscovererMediaArray.remove(index);
                    }
                    if (index == -1) break;
                    MediaBrowser.this.mEventListener.onMediaRemoved(index, mlEvent.media);
                    break;
                }
                case 516: {
                    MediaBrowser.this.mEventListener.onBrowseEnd();
                }
            }
        }
    };

    public MediaBrowser(ILibVLC libvlc, EventListener listener) {
        this.mFactory = (IMediaFactory)FactoryManager.getFactory(IMediaFactory.factoryId);
        this.mILibVlc = libvlc;
        this.mILibVlc.retain();
        this.mEventListener = listener;
        this.mAlive = true;
    }

    public MediaBrowser(ILibVLC libvlc, EventListener listener, Handler handler) {
        this(libvlc, listener);
        this.mHandler = handler;
    }

    private void reset() {
        for (MediaDiscoverer md : this.mMediaDiscoverers) {
            md.release();
        }
        this.mMediaDiscoverers.clear();
        this.mDiscovererMediaArray.clear();
        if (this.mMedia != null) {
            this.mMedia.release();
            this.mMedia = null;
        }
        if (this.mBrowserMediaList != null) {
            this.mBrowserMediaList.release();
            this.mBrowserMediaList = null;
        }
    }

    @MainThread
    public void release() {
        this.reset();
        if (!this.mAlive) {
            throw new IllegalStateException("MediaBrowser released more than one time");
        }
        this.mILibVlc.release();
        this.mAlive = false;
    }

    @MainThread
    public void changeEventListener(EventListener eventListener) {
        this.reset();
        this.mEventListener = eventListener;
    }

    private void startMediaDiscoverer(String discovererName) {
        MediaDiscoverer md = new MediaDiscoverer(this.mILibVlc, discovererName);
        this.mMediaDiscoverers.add(md);
        MediaList ml = md.getMediaList();
        ml.setEventListener(this.mDiscovererMediaListEventListener, this.mHandler);
        ml.release();
        if (!md.isReleased()) {
            md.start();
        }
    }

    @MainThread
    public void discoverNetworkShares() {
        this.reset();
        MediaDiscoverer.Description[] descriptions = MediaDiscoverer.list(this.mILibVlc, 1);
        if (descriptions == null) {
            return;
        }
        for (MediaDiscoverer.Description description : descriptions) {
            Log.i((String)TAG, (String)("starting " + description.name + " discover (" + description.longName + ")"));
            this.startMediaDiscoverer(description.name);
        }
    }

    @MainThread
    public void discoverNetworkShares(String serviceName) {
        this.reset();
        this.startMediaDiscoverer(serviceName);
    }

    @MainThread
    public void browse(String path, int flags) {
        IMedia media = this.mFactory.getFromLocalPath(this.mILibVlc, path);
        this.browse(media, flags);
        media.release();
    }

    @MainThread
    public void browse(Uri uri, int flags) {
        IMedia media = this.mFactory.getFromUri(this.mILibVlc, uri);
        this.browse(media, flags);
        media.release();
    }

    @MainThread
    public void browse(IMedia media, int flags) {
        media.retain();
        media.addOption(IGNORE_LIST_OPTION + this.mIgnoreList);
        if ((flags & 2) != 0) {
            media.addOption(":no-sub-autodetect-file");
        }
        if ((flags & 4) != 0) {
            media.addOption(":show-hiddenfiles");
        }
        int mediaFlags = 2;
        if ((flags & 1) != 0) {
            mediaFlags |= 0x20;
        }
        this.reset();
        this.mBrowserMediaList = media.subItems();
        this.mBrowserMediaList.setEventListener(this.mBrowserMediaListEventListener, this.mHandler);
        media.parseAsync(mediaFlags, 0);
        this.mMedia = media;
    }

    @MainThread
    public int getMediaCount() {
        return this.mBrowserMediaList != null ? this.mBrowserMediaList.getCount() : this.mDiscovererMediaArray.size();
    }

    @MainThread
    public IMedia getMediaAt(int index) {
        if (index < 0 || index >= this.getMediaCount()) {
            throw new IndexOutOfBoundsException();
        }
        IMedia media = this.mBrowserMediaList != null ? this.mBrowserMediaList.getMediaAt(index) : this.mDiscovererMediaArray.get(index);
        media.retain();
        return media;
    }

    @MainThread
    public void setIgnoreFileTypes(String list) {
        this.mIgnoreList = list;
    }

    public static interface EventListener {
        public void onMediaAdded(int var1, IMedia var2);

        public void onMediaRemoved(int var1, IMedia var2);

        public void onBrowseEnd();
    }

    public static class Flag {
        public static final int Interact = 1;
        public static final int NoSlavesAutodetect = 2;
        public static final int ShowHiddenFiles = 4;
    }
}

