/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.content.Context;
import android.util.Log;
import androidx.annotation.Nullable;
import java.util.List;
import org.videolan.libvlc.VLCObject;
import org.videolan.libvlc.interfaces.AbstractVLCEvent;
import org.videolan.libvlc.interfaces.ILibVLC;

public class LibVLC
extends VLCObject<ILibVLC.Event>
implements ILibVLC {
    private static final String TAG = "VLC/LibVLC";
    final Context mAppContext;
    private static boolean sLoaded = false;

    public LibVLC(Context context, List<String> options) {
        this.mAppContext = context.getApplicationContext();
        LibVLC.loadLibraries();
        this.nativeNew(options != null ? options.toArray(new String[options.size()]) : null, context.getDir("vlc", 0).getAbsolutePath());
    }

    public LibVLC(Context context) {
        this(context, null);
    }

    public static native String version();

    public static native int majorVersion();

    public static native String compiler();

    public static native String changeset();

    @Override
    protected ILibVLC.Event onEventNative(int eventType, long arg1, long arg2, float argf1, @Nullable String args1) {
        return null;
    }

    @Override
    public Context getAppContext() {
        return this.mAppContext;
    }

    @Override
    protected void onReleaseNative() {
        this.nativeRelease();
    }

    public void setUserAgent(String name, String http) {
        this.nativeSetUserAgent(name, http);
    }

    private native void nativeNew(String[] var1, String var2);

    private native void nativeRelease();

    private native void nativeSetUserAgent(String var1, String var2);

    public static synchronized void loadLibraries() {
        if (sLoaded) {
            return;
        }
        sLoaded = true;
        try {
            System.loadLibrary("c++_shared");
        }
        catch (UnsatisfiedLinkError ule) {
            Log.e((String)TAG, (String)"Can't load c++_shared library");
        }
        catch (SecurityException se) {
            Log.e((String)TAG, (String)"Encountered a security issue when loading c++_shared library");
        }
        try {
            System.loadLibrary("vlc");
            System.loadLibrary("vlcjni");
        }
        catch (UnsatisfiedLinkError ule) {
            Log.e((String)TAG, (String)("Can't load vlcjni library: " + ule));
            System.exit(1);
        }
        catch (SecurityException se) {
            Log.e((String)TAG, (String)("Encountered a security issue when loading vlcjni library: " + se));
            System.exit(1);
        }
    }

    public static class Event
    extends AbstractVLCEvent {
        protected Event(int type) {
            super(type);
        }
    }
}

