/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.MainThread;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.videolan.libvlc.interfaces.IVLCVout;

public class AWindow
implements IVLCVout {
    private static final String TAG = "AWindow";
    private static final int ID_VIDEO = 0;
    private static final int ID_SUBTITLES = 1;
    private static final int ID_MAX = 2;
    private static final int SURFACE_STATE_INIT = 0;
    private static final int SURFACE_STATE_ATTACHED = 1;
    private static final int SURFACE_STATE_READY = 2;
    private final SurfaceHelper[] mSurfaceHelpers;
    private final SurfaceCallback mSurfaceCallback;
    private final AtomicInteger mSurfacesState = new AtomicInteger(0);
    private IVLCVout.OnNewVideoLayoutListener mOnNewVideoLayoutListener = null;
    private ArrayList<IVLCVout.Callback> mIVLCVoutCallbacks = new ArrayList();
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Surface[] mSurfaces;
    private long mCallbackNativeHandle = 0L;
    private int mMouseAction = -1;
    private int mMouseButton = -1;
    private int mMouseX = -1;
    private int mMouseY = -1;
    private int mWindowWidth = -1;
    private int mWindowHeight = -1;
    private SurfaceTextureThread mSurfaceTextureThread = new SurfaceTextureThread();
    private final NativeLock mNativeLock = new NativeLock();
    private static final int AWINDOW_REGISTER_ERROR = 0;
    private static final int AWINDOW_REGISTER_FLAGS_SUCCESS = 1;
    private static final int AWINDOW_REGISTER_FLAGS_HAS_VIDEO_LAYOUT_LISTENER = 2;

    public AWindow(SurfaceCallback surfaceCallback) {
        this.mSurfaceCallback = surfaceCallback;
        this.mSurfaceHelpers = new SurfaceHelper[2];
        this.mSurfaceHelpers[0] = null;
        this.mSurfaceHelpers[1] = null;
        this.mSurfaces = new Surface[2];
        this.mSurfaces[0] = null;
        this.mSurfaces[1] = null;
    }

    private void ensureInitState() throws IllegalStateException {
        if (this.mSurfacesState.get() != 0) {
            throw new IllegalStateException("Can't set view when already attached. Current state: " + this.mSurfacesState.get() + ", mSurfaces[ID_VIDEO]: " + this.mSurfaceHelpers[0] + " / " + this.mSurfaces[0] + ", mSurfaces[ID_SUBTITLES]: " + this.mSurfaceHelpers[1] + " / " + this.mSurfaces[1]);
        }
    }

    private void setView(int id, SurfaceView view) {
        this.ensureInitState();
        if (view == null) {
            throw new NullPointerException("view is null");
        }
        SurfaceHelper surfaceHelper = this.mSurfaceHelpers[id];
        if (surfaceHelper != null) {
            surfaceHelper.release();
        }
        this.mSurfaceHelpers[id] = new SurfaceHelper(id, view);
    }

    private void setView(int id, TextureView view) {
        this.ensureInitState();
        if (view == null) {
            throw new NullPointerException("view is null");
        }
        SurfaceHelper surfaceHelper = this.mSurfaceHelpers[id];
        if (surfaceHelper != null) {
            surfaceHelper.release();
        }
        this.mSurfaceHelpers[id] = new SurfaceHelper(id, view);
    }

    private void setSurface(int id, Surface surface, SurfaceHolder surfaceHolder) {
        this.ensureInitState();
        if (!surface.isValid() && surfaceHolder == null) {
            throw new IllegalStateException("surface is not attached and holder is null");
        }
        SurfaceHelper surfaceHelper = this.mSurfaceHelpers[id];
        if (surfaceHelper != null) {
            surfaceHelper.release();
        }
        this.mSurfaceHelpers[id] = new SurfaceHelper(id, surface, surfaceHolder);
    }

    @Override
    @MainThread
    public void setVideoView(SurfaceView videoSurfaceView) {
        this.setView(0, videoSurfaceView);
    }

    @Override
    @MainThread
    public void setVideoView(TextureView videoTextureView) {
        this.setView(0, videoTextureView);
    }

    @Override
    public void setVideoSurface(Surface videoSurface, SurfaceHolder surfaceHolder) {
        this.setSurface(0, videoSurface, surfaceHolder);
    }

    @Override
    @TargetApi(value=14)
    public void setVideoSurface(SurfaceTexture videoSurfaceTexture) {
        this.setSurface(0, new Surface(videoSurfaceTexture), null);
    }

    @Override
    @MainThread
    public void setSubtitlesView(SurfaceView subtitlesSurfaceView) {
        this.setView(1, subtitlesSurfaceView);
    }

    @Override
    @MainThread
    public void setSubtitlesView(TextureView subtitlesTextureView) {
        this.setView(1, subtitlesTextureView);
    }

    @Override
    public void setSubtitlesSurface(Surface subtitlesSurface, SurfaceHolder surfaceHolder) {
        this.setSurface(1, subtitlesSurface, surfaceHolder);
    }

    @Override
    @TargetApi(value=14)
    public void setSubtitlesSurface(SurfaceTexture subtitlesSurfaceTexture) {
        this.setSurface(1, new Surface(subtitlesSurfaceTexture), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @MainThread
    public void attachViews(IVLCVout.OnNewVideoLayoutListener onNewVideoLayoutListener) {
        if (this.mSurfacesState.get() != 0 || this.mSurfaceHelpers[0] == null) {
            throw new IllegalStateException("already attached or video view not configured");
        }
        this.mSurfacesState.set(1);
        NativeLock nativeLock = this.mNativeLock;
        synchronized (nativeLock) {
            this.mOnNewVideoLayoutListener = onNewVideoLayoutListener;
            this.mNativeLock.buffersGeometryConfigured = false;
            this.mNativeLock.buffersGeometryAbort = false;
        }
        for (int id = 0; id < 2; ++id) {
            SurfaceHelper surfaceHelper = this.mSurfaceHelpers[id];
            if (surfaceHelper == null) continue;
            surfaceHelper.attach();
        }
    }

    @Override
    @MainThread
    public void attachViews() {
        this.attachViews(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @MainThread
    public void detachViews() {
        if (this.mSurfacesState.get() == 0) {
            return;
        }
        this.mSurfacesState.set(0);
        this.mHandler.removeCallbacksAndMessages(null);
        NativeLock nativeLock = this.mNativeLock;
        synchronized (nativeLock) {
            this.mOnNewVideoLayoutListener = null;
            this.mNativeLock.buffersGeometryAbort = true;
            this.mNativeLock.notifyAll();
        }
        for (int id = 0; id < 2; ++id) {
            SurfaceHelper surfaceHelper = this.mSurfaceHelpers[id];
            if (surfaceHelper != null) {
                surfaceHelper.release();
            }
            this.mSurfaceHelpers[id] = null;
        }
        for (IVLCVout.Callback cb : this.mIVLCVoutCallbacks) {
            cb.onSurfacesDestroyed(this);
        }
        if (this.mSurfaceCallback != null) {
            this.mSurfaceCallback.onSurfacesDestroyed(this);
        }
        this.mSurfaceTextureThread.release();
    }

    @Override
    @MainThread
    public boolean areViewsAttached() {
        return this.mSurfacesState.get() != 0;
    }

    @MainThread
    private void onSurfaceCreated() {
        if (this.mSurfacesState.get() != 1) {
            throw new IllegalArgumentException("invalid state");
        }
        SurfaceHelper videoHelper = this.mSurfaceHelpers[0];
        SurfaceHelper subtitlesHelper = this.mSurfaceHelpers[1];
        if (videoHelper == null) {
            throw new NullPointerException("videoHelper shouldn't be null here");
        }
        if (videoHelper.isReady() && (subtitlesHelper == null || subtitlesHelper.isReady())) {
            this.mSurfacesState.set(2);
            for (IVLCVout.Callback cb : this.mIVLCVoutCallbacks) {
                cb.onSurfacesCreated(this);
            }
            if (this.mSurfaceCallback != null) {
                this.mSurfaceCallback.onSurfacesCreated(this);
            }
        }
    }

    @MainThread
    private void onSurfaceDestroyed() {
        this.detachViews();
    }

    boolean areSurfacesWaiting() {
        return this.mSurfacesState.get() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMouseEvent(int action, int button, int x, int y) {
        NativeLock nativeLock = this.mNativeLock;
        synchronized (nativeLock) {
            if (this.mCallbackNativeHandle != 0L && (this.mMouseAction != action || this.mMouseButton != button || this.mMouseX != x || this.mMouseY != y)) {
                AWindow.nativeOnMouseEvent(this.mCallbackNativeHandle, action, button, x, y);
            }
            this.mMouseAction = action;
            this.mMouseButton = button;
            this.mMouseX = x;
            this.mMouseY = y;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWindowSize(int width, int height) {
        NativeLock nativeLock = this.mNativeLock;
        synchronized (nativeLock) {
            if (this.mCallbackNativeHandle != 0L && (this.mWindowWidth != width || this.mWindowHeight != height)) {
                AWindow.nativeOnWindowSize(this.mCallbackNativeHandle, width, height);
            }
            this.mWindowWidth = width;
            this.mWindowHeight = height;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNativeSurface(int id, Surface surface) {
        NativeLock nativeLock = this.mNativeLock;
        synchronized (nativeLock) {
            this.mSurfaces[id] = surface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Surface getNativeSurface(int id) {
        NativeLock nativeLock = this.mNativeLock;
        synchronized (nativeLock) {
            return this.mSurfaces[id];
        }
    }

    @Override
    public void addCallback(IVLCVout.Callback callback) {
        if (!this.mIVLCVoutCallbacks.contains(callback)) {
            this.mIVLCVoutCallbacks.add(callback);
        }
    }

    @Override
    public void removeCallback(IVLCVout.Callback callback) {
        this.mIVLCVoutCallbacks.remove(callback);
    }

    private static native void nativeOnMouseEvent(long var0, int var2, int var3, int var4, int var5);

    private static native void nativeOnWindowSize(long var0, int var2, int var3);

    private Surface getVideoSurface() {
        return this.getNativeSurface(0);
    }

    private Surface getSubtitlesSurface() {
        return this.getNativeSurface(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int registerNative(long nativeHandle) {
        if (nativeHandle == 0L) {
            throw new IllegalArgumentException("nativeHandle is null");
        }
        NativeLock nativeLock = this.mNativeLock;
        synchronized (nativeLock) {
            if (this.mCallbackNativeHandle != 0L) {
                return 0;
            }
            this.mCallbackNativeHandle = nativeHandle;
            if (this.mMouseAction != -1) {
                AWindow.nativeOnMouseEvent(this.mCallbackNativeHandle, this.mMouseAction, this.mMouseButton, this.mMouseX, this.mMouseY);
            }
            if (this.mWindowWidth != -1 && this.mWindowHeight != -1) {
                AWindow.nativeOnWindowSize(this.mCallbackNativeHandle, this.mWindowWidth, this.mWindowHeight);
            }
            int flags = 1;
            if (this.mOnNewVideoLayoutListener != null) {
                flags |= 2;
            }
            return flags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterNative() {
        NativeLock nativeLock = this.mNativeLock;
        synchronized (nativeLock) {
            if (this.mCallbackNativeHandle == 0L) {
                throw new IllegalArgumentException("unregister called when not registered");
            }
            this.mCallbackNativeHandle = 0L;
        }
    }

    private boolean setBuffersGeometry(Surface surface, int width, int height, int format) {
        return false;
    }

    private void setVideoLayout(final int width, final int height, final int visibleWidth, final int visibleHeight, final int sarNum, final int sarDen) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (AWindow.this.mOnNewVideoLayoutListener != null) {
                    AWindow.this.mOnNewVideoLayoutListener.onNewVideoLayout(AWindow.this, width, height, visibleWidth, visibleHeight, sarNum, sarDen);
                }
            }
        });
    }

    boolean SurfaceTexture_attachToGLContext(int texName) {
        return this.mSurfaceTextureThread.attachToGLContext(texName);
    }

    private void SurfaceTexture_detachFromGLContext() {
        this.mSurfaceTextureThread.detachFromGLContext();
    }

    private boolean SurfaceTexture_waitAndUpdateTexImage(float[] transformMatrix) {
        return this.mSurfaceTextureThread.waitAndUpdateTexImage(transformMatrix);
    }

    private Surface SurfaceTexture_getSurface() {
        return this.mSurfaceTextureThread.getSurface();
    }

    @TargetApi(value=16)
    private static class SurfaceTextureThread
    implements Runnable,
    SurfaceTexture.OnFrameAvailableListener {
        private SurfaceTexture mSurfaceTexture = null;
        private Surface mSurface = null;
        private boolean mFrameAvailable = false;
        private Looper mLooper = null;
        private Thread mThread = null;
        private boolean mIsAttached = false;
        private boolean mDoRelease = false;

        private SurfaceTextureThread() {
        }

        private synchronized boolean createSurface() {
            if (this.mSurfaceTexture == null) {
                this.mThread = new Thread(this);
                this.mThread.start();
                while (this.mSurfaceTexture == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ignored) {
                        return false;
                    }
                }
                this.mSurface = new Surface(this.mSurfaceTexture);
            }
            return true;
        }

        private synchronized boolean attachToGLContext(int texName) {
            if (!this.createSurface()) {
                return false;
            }
            this.mSurfaceTexture.attachToGLContext(texName);
            this.mFrameAvailable = false;
            this.mIsAttached = true;
            return true;
        }

        public synchronized void onFrameAvailable(SurfaceTexture surfaceTexture) {
            if (surfaceTexture == this.mSurfaceTexture) {
                if (this.mFrameAvailable) {
                    throw new IllegalStateException("An available frame was not updated");
                }
                this.mFrameAvailable = true;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Looper.prepare();
            SurfaceTextureThread surfaceTextureThread = this;
            synchronized (surfaceTextureThread) {
                this.mLooper = Looper.myLooper();
                this.mSurfaceTexture = new SurfaceTexture(0);
                this.mSurfaceTexture.detachFromGLContext();
                this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
                this.notify();
            }
            Looper.loop();
        }

        private synchronized void detachFromGLContext() {
            if (this.mDoRelease) {
                this.mLooper.quit();
                this.mLooper = null;
                try {
                    this.mThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.mThread = null;
                this.mSurface.release();
                this.mSurface = null;
                this.mSurfaceTexture.release();
                this.mSurfaceTexture = null;
                this.mDoRelease = false;
            } else {
                this.mSurfaceTexture.detachFromGLContext();
            }
            this.mIsAttached = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitAndUpdateTexImage(float[] transformMatrix) {
            SurfaceTextureThread surfaceTextureThread = this;
            synchronized (surfaceTextureThread) {
                while (!this.mFrameAvailable) {
                    try {
                        this.wait(500L);
                        if (this.mFrameAvailable) continue;
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                this.mFrameAvailable = false;
            }
            this.mSurfaceTexture.updateTexImage();
            this.mSurfaceTexture.getTransformMatrix(transformMatrix);
            return true;
        }

        private synchronized Surface getSurface() {
            if (!this.createSurface()) {
                return null;
            }
            return this.mSurface;
        }

        private synchronized void release() {
            if (this.mSurfaceTexture != null) {
                if (this.mIsAttached) {
                    this.mDoRelease = true;
                } else {
                    this.mSurface.release();
                    this.mSurface = null;
                    this.mSurfaceTexture.release();
                    this.mSurfaceTexture = null;
                }
            }
        }
    }

    private static class NativeLock {
        private boolean buffersGeometryConfigured = false;
        private boolean buffersGeometryAbort = false;

        private NativeLock() {
        }
    }

    public static interface SurfaceCallback {
        @MainThread
        public void onSurfacesCreated(AWindow var1);

        @MainThread
        public void onSurfacesDestroyed(AWindow var1);
    }

    private class SurfaceHelper {
        private final int mId;
        private final SurfaceView mSurfaceView;
        private final TextureView mTextureView;
        private final SurfaceHolder mSurfaceHolder;
        private Surface mSurface;
        private final SurfaceHolder.Callback mSurfaceHolderCallback = new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                if (holder != SurfaceHelper.this.mSurfaceHolder) {
                    throw new IllegalStateException("holders are different");
                }
                SurfaceHelper.this.setSurface(holder.getSurface());
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                AWindow.this.onSurfaceDestroyed();
            }
        };
        private final TextureView.SurfaceTextureListener mSurfaceTextureListener = this.createSurfaceTextureListener();

        private SurfaceHelper(int id, SurfaceView surfaceView) {
            this.mId = id;
            this.mTextureView = null;
            this.mSurfaceView = surfaceView;
            this.mSurfaceHolder = this.mSurfaceView.getHolder();
        }

        private SurfaceHelper(int id, TextureView textureView) {
            this.mId = id;
            this.mSurfaceView = null;
            this.mSurfaceHolder = null;
            this.mTextureView = textureView;
        }

        private SurfaceHelper(int id, Surface surface, SurfaceHolder surfaceHolder) {
            this.mId = id;
            this.mSurfaceView = null;
            this.mTextureView = null;
            this.mSurfaceHolder = surfaceHolder;
            this.mSurface = surface;
        }

        private void setSurface(Surface surface) {
            if (surface.isValid() && AWindow.this.getNativeSurface(this.mId) == null) {
                this.mSurface = surface;
                AWindow.this.setNativeSurface(this.mId, this.mSurface);
                AWindow.this.onSurfaceCreated();
            }
        }

        private void attachSurfaceView() {
            this.mSurfaceHolder.addCallback(this.mSurfaceHolderCallback);
            this.setSurface(this.mSurfaceHolder.getSurface());
        }

        @TargetApi(value=14)
        private void attachTextureView() {
            this.mTextureView.setSurfaceTextureListener(this.mSurfaceTextureListener);
            SurfaceTexture surfaceTexture = this.mTextureView.getSurfaceTexture();
            if (surfaceTexture != null) {
                this.mSurfaceTextureListener.onSurfaceTextureAvailable(surfaceTexture, this.mTextureView.getWidth(), this.mTextureView.getHeight());
            }
        }

        private void attachSurface() {
            if (this.mSurfaceHolder != null) {
                this.mSurfaceHolder.addCallback(this.mSurfaceHolderCallback);
            }
            this.setSurface(this.mSurface);
        }

        public void attach() {
            if (this.mSurfaceView != null) {
                this.attachSurfaceView();
            } else if (this.mTextureView != null) {
                this.attachTextureView();
            } else if (this.mSurface != null) {
                this.attachSurface();
            } else {
                throw new IllegalStateException();
            }
        }

        @TargetApi(value=14)
        private void releaseTextureView() {
            if (this.mTextureView != null) {
                this.mTextureView.setSurfaceTextureListener(null);
            }
        }

        public void release() {
            this.mSurface = null;
            AWindow.this.setNativeSurface(this.mId, null);
            if (this.mSurfaceHolder != null) {
                this.mSurfaceHolder.removeCallback(this.mSurfaceHolderCallback);
            }
            this.releaseTextureView();
        }

        public boolean isReady() {
            return this.mSurfaceView == null || this.mSurface != null;
        }

        public Surface getSurface() {
            return this.mSurface;
        }

        SurfaceHolder getSurfaceHolder() {
            return this.mSurfaceHolder;
        }

        @TargetApi(value=14)
        private TextureView.SurfaceTextureListener createSurfaceTextureListener() {
            return new TextureView.SurfaceTextureListener(){

                public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
                    SurfaceHelper.this.setSurface(new Surface(surfaceTexture));
                }

                public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                }

                public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                    AWindow.this.onSurfaceDestroyed();
                    return true;
                }

                public void onSurfaceTextureUpdated(SurfaceTexture surface) {
                }
            };
        }
    }
}

