/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;
import org.videolan.libvlc.interfaces.AbstractVLCEvent;
import org.videolan.libvlc.interfaces.ILibVLC;
import org.videolan.libvlc.interfaces.IVLCObject;

abstract class VLCObject<T extends AbstractVLCEvent>
implements IVLCObject<T> {
    private AbstractVLCEvent.Listener<T> mEventListener = null;
    private Handler mHandler = null;
    final ILibVLC mILibVLC;
    private int mNativeRefCount = 1;
    private long mInstance = 0L;

    protected VLCObject(ILibVLC libvlc) {
        this.mILibVLC = libvlc;
    }

    protected VLCObject(IVLCObject parent) {
        this.mILibVLC = parent.getLibVLC();
    }

    protected VLCObject() {
        this.mILibVLC = null;
    }

    @Override
    public synchronized boolean isReleased() {
        return this.mNativeRefCount == 0;
    }

    @Override
    public final synchronized boolean retain() {
        if (this.mNativeRefCount > 0) {
            ++this.mNativeRefCount;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void release() {
        int refCount = -1;
        VLCObject vLCObject = this;
        synchronized (vLCObject) {
            if (this.mNativeRefCount == 0) {
                return;
            }
            if (this.mNativeRefCount > 0) {
                refCount = --this.mNativeRefCount;
            }
            if (refCount == 0) {
                this.setEventListener(null);
            }
        }
        if (refCount == 0) {
            this.nativeDetachEvents();
            vLCObject = this;
            synchronized (vLCObject) {
                this.onReleaseNative();
            }
        }
    }

    protected synchronized void finalize() {
        if (!this.isReleased()) {
            throw new AssertionError((Object)("VLCObject (" + this.getClass().getName() + ") finalized but not natively released (" + this.mNativeRefCount + " refs)"));
        }
    }

    @Override
    public ILibVLC getLibVLC() {
        return this.mILibVLC;
    }

    protected synchronized void setEventListener(AbstractVLCEvent.Listener<T> listener) {
        this.setEventListener(listener, null);
    }

    protected synchronized void setEventListener(AbstractVLCEvent.Listener<T> listener, Handler handler) {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.mEventListener = listener;
        if (this.mEventListener == null) {
            this.mHandler = null;
        } else if (this.mHandler == null) {
            this.mHandler = handler != null ? handler : new Handler(Looper.getMainLooper());
        }
    }

    protected abstract T onEventNative(int var1, long var2, long var4, float var6, String var7);

    protected abstract void onReleaseNative();

    private synchronized void dispatchEventFromNative(int eventType, long arg1, long arg2, float argf1, @Nullable String args1) {
        if (this.isReleased()) {
            return;
        }
        T event = this.onEventNative(eventType, arg1, arg2, argf1, args1);
        if (event != null && this.mEventListener != null && this.mHandler != null) {
            class EventRunnable
            implements Runnable {
                private final AbstractVLCEvent.Listener<T> listener;
                private final T event;

                EventRunnable(AbstractVLCEvent.Listener<T> listener, T event) {
                    this.listener = listener;
                    this.event = event;
                }

                @Override
                public void run() {
                    this.listener.onEvent(this.event);
                    ((AbstractVLCEvent)this.event).release();
                }
            }
            this.mHandler.post((Runnable)new EventRunnable(this.mEventListener, event));
        }
    }

    private native void nativeDetachEvents();

    private Object getWeakReference() {
        return new WeakReference<VLCObject>(this);
    }

    private static void dispatchEventFromWeakNative(Object weak, int eventType, long arg1, long arg2, float argf1, @Nullable String args1) {
        VLCObject obj = (VLCObject)((WeakReference)weak).get();
        if (obj != null) {
            obj.dispatchEventFromNative(eventType, arg1, arg2, argf1, args1);
        }
    }
}

