/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.os.Handler;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import org.videolan.libvlc.LibVLC;
import org.videolan.libvlc.Media;
import org.videolan.libvlc.MediaDiscoverer;
import org.videolan.libvlc.VLCEvent;
import org.videolan.libvlc.VLCObject;

public class MediaList
extends VLCObject<Event> {
    private static final String TAG = "LibVLC/MediaList";
    private int mCount = 0;
    private final SparseArray<Media> mMediaArray = new SparseArray();
    private boolean mLocked = false;

    private void init() {
        this.lock();
        this.mCount = this.nativeGetCount();
        for (int i = 0; i < this.mCount; ++i) {
            this.mMediaArray.put(i, (Object)new Media(this, i));
        }
        this.unlock();
    }

    public MediaList(LibVLC libVLC) {
        super(libVLC);
        this.nativeNewFromLibVlc(libVLC);
        this.init();
    }

    protected MediaList(MediaDiscoverer md) {
        super(md);
        this.nativeNewFromMediaDiscoverer(md);
        this.init();
    }

    protected MediaList(Media m) {
        super(m);
        this.nativeNewFromMedia(m);
        this.init();
    }

    private synchronized Media insertMediaFromEvent(int index) {
        for (int i = this.mCount - 1; i >= index; --i) {
            this.mMediaArray.put(i + 1, this.mMediaArray.valueAt(i));
        }
        ++this.mCount;
        Media media = new Media(this, index);
        this.mMediaArray.put(index, (Object)media);
        return media;
    }

    private synchronized Media removeMediaFromEvent(int index) {
        --this.mCount;
        Media media = (Media)this.mMediaArray.get(index);
        if (media != null) {
            media.release();
        }
        for (int i = index; i < this.mCount; ++i) {
            this.mMediaArray.put(i, this.mMediaArray.valueAt(i + 1));
        }
        return media;
    }

    public void setEventListener(EventListener listener, Handler handler) {
        super.setEventListener(listener, handler);
    }

    @Override
    protected synchronized Event onEventNative(int eventType, long arg1, long arg2, float argf1, @Nullable String args1) {
        if (this.mLocked) {
            throw new IllegalStateException("already locked from event callback");
        }
        this.mLocked = true;
        Event event = null;
        switch (eventType) {
            case 512: {
                int index = (int)arg1;
                if (index == -1) break;
                Media media = this.insertMediaFromEvent(index);
                event = new Event(eventType, media, true, index);
                break;
            }
            case 514: {
                int index = (int)arg1;
                if (index == -1) break;
                Media media = this.removeMediaFromEvent(index);
                event = new Event(eventType, media, false, index);
                break;
            }
            case 516: {
                event = new Event(eventType, null, false, -1);
            }
        }
        this.mLocked = false;
        return event;
    }

    public synchronized int getCount() {
        return this.mCount;
    }

    public synchronized Media getMediaAt(int index) {
        if (index < 0 || index >= this.getCount()) {
            throw new IndexOutOfBoundsException();
        }
        Media media = (Media)this.mMediaArray.get(index);
        media.retain();
        return media;
    }

    @Override
    public void onReleaseNative() {
        for (int i = 0; i < this.mMediaArray.size(); ++i) {
            Media media = (Media)this.mMediaArray.get(i);
            if (media == null) continue;
            media.release();
        }
        this.nativeRelease();
    }

    private synchronized void lock() {
        if (this.mLocked) {
            throw new IllegalStateException("already locked");
        }
        this.mLocked = true;
        this.nativeLock();
    }

    private synchronized void unlock() {
        if (!this.mLocked) {
            throw new IllegalStateException("not locked");
        }
        this.mLocked = false;
        this.nativeUnlock();
    }

    protected synchronized boolean isLocked() {
        return this.mLocked;
    }

    private native void nativeNewFromLibVlc(LibVLC var1);

    private native void nativeNewFromMediaDiscoverer(MediaDiscoverer var1);

    private native void nativeNewFromMedia(Media var1);

    private native void nativeRelease();

    private native int nativeGetCount();

    private native void nativeLock();

    private native void nativeUnlock();

    public static interface EventListener
    extends VLCEvent.Listener<Event> {
    }

    public static class Event
    extends VLCEvent {
        public static final int ItemAdded = 512;
        public static final int ItemDeleted = 514;
        public static final int EndReached = 516;
        public final Media media;
        private final boolean retain;
        public final int index;

        protected Event(int type, Media media, boolean retain, int index) {
            super(type);
            if (retain && (media == null || !media.retain())) {
                throw new IllegalStateException("invalid media reference");
            }
            this.media = media;
            this.retain = retain;
            this.index = index;
        }

        @Override
        void release() {
            if (this.retain) {
                this.media.release();
            }
        }
    }
}

