/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.commons.compress.archivers.tar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.vafer.jdeb.shaded.commons.compress.archivers.tar.TarArchiveStructSparse;
import org.vafer.jdeb.shaded.commons.compress.archivers.tar.TarConstants;
import org.vafer.jdeb.shaded.commons.compress.archivers.tar.TarUtils;

public class TarArchiveSparseEntry
implements TarConstants {
    private final boolean isExtended;
    private List<TarArchiveStructSparse> sparseHeaders;

    public TarArchiveSparseEntry(byte[] headerBuf) throws IOException {
        int offset = 0;
        this.sparseHeaders = new ArrayList<TarArchiveStructSparse>();
        for (int i = 0; i < 21; ++i) {
            TarArchiveStructSparse sparseHeader = TarUtils.parseSparse(headerBuf, offset + i * 24);
            if (sparseHeader.getOffset() <= 0L && sparseHeader.getNumbytes() <= 0L) continue;
            this.sparseHeaders.add(sparseHeader);
        }
        this.isExtended = TarUtils.parseBoolean(headerBuf, offset += 504);
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public List<TarArchiveStructSparse> getSparseHeaders() {
        return this.sparseHeaders;
    }
}

