/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import org.vafer.jdeb.shaded.bc.bcpg.MPInteger;
import org.vafer.jdeb.shaded.bc.bcpg.OnePassSignaturePacket;
import org.vafer.jdeb.shaded.bc.bcpg.SignaturePacket;
import org.vafer.jdeb.shaded.bc.bcpg.SignatureSubpacket;
import org.vafer.jdeb.shaded.bc.bcpg.UserAttributeSubpacket;
import org.vafer.jdeb.shaded.bc.bcpg.sig.IssuerKeyID;
import org.vafer.jdeb.shaded.bc.bcpg.sig.SignatureCreationTime;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPOnePassSignature;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPrivateKey;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPublicKey;
import org.vafer.jdeb.shaded.bc.openpgp.PGPRuntimeOperationException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignature;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignatureSubpacketVector;
import org.vafer.jdeb.shaded.bc.openpgp.PGPUserAttributeSubpacketVector;
import org.vafer.jdeb.shaded.bc.openpgp.PGPUtil;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPContentSigner;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPContentSignerBuilder;
import org.vafer.jdeb.shaded.bc.util.Arrays;
import org.vafer.jdeb.shaded.bc.util.Strings;

public class PGPSignatureGenerator {
    private SignatureSubpacket[] unhashed = new SignatureSubpacket[0];
    private SignatureSubpacket[] hashed = new SignatureSubpacket[0];
    private OutputStream sigOut;
    private PGPContentSignerBuilder contentSignerBuilder;
    private PGPContentSigner contentSigner;
    private int sigType;
    private byte lastb;
    private int providedKeyAlgorithm = -1;

    public PGPSignatureGenerator(PGPContentSignerBuilder pGPContentSignerBuilder) {
        this.contentSignerBuilder = pGPContentSignerBuilder;
    }

    public void init(int n, PGPPrivateKey pGPPrivateKey) throws PGPException {
        this.contentSigner = this.contentSignerBuilder.build(n, pGPPrivateKey);
        this.sigOut = this.contentSigner.getOutputStream();
        this.sigType = this.contentSigner.getType();
        this.lastb = 0;
        if (this.providedKeyAlgorithm >= 0 && this.providedKeyAlgorithm != this.contentSigner.getKeyAlgorithm()) {
            throw new PGPException("key algorithm mismatch");
        }
    }

    public void update(byte by) {
        if (this.sigType == 1) {
            if (by == 13) {
                this.byteUpdate((byte)13);
                this.byteUpdate((byte)10);
            } else if (by == 10) {
                if (this.lastb != 13) {
                    this.byteUpdate((byte)13);
                    this.byteUpdate((byte)10);
                }
            } else {
                this.byteUpdate(by);
            }
            this.lastb = by;
        } else {
            this.byteUpdate(by);
        }
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.sigType == 1) {
            int n3 = n + n2;
            for (int i = n; i != n3; ++i) {
                this.update(byArray[i]);
            }
        } else {
            this.blockUpdate(byArray, n, n2);
        }
    }

    private void byteUpdate(byte by) {
        try {
            this.sigOut.write(by);
        }
        catch (IOException iOException) {
            throw new PGPRuntimeOperationException(iOException.getMessage(), iOException);
        }
    }

    private void blockUpdate(byte[] byArray, int n, int n2) {
        try {
            this.sigOut.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new PGPRuntimeOperationException(iOException.getMessage(), iOException);
        }
    }

    public void setHashedSubpackets(PGPSignatureSubpacketVector pGPSignatureSubpacketVector) {
        if (pGPSignatureSubpacketVector == null) {
            this.hashed = new SignatureSubpacket[0];
            return;
        }
        this.hashed = pGPSignatureSubpacketVector.toSubpacketArray();
    }

    public void setUnhashedSubpackets(PGPSignatureSubpacketVector pGPSignatureSubpacketVector) {
        if (pGPSignatureSubpacketVector == null) {
            this.unhashed = new SignatureSubpacket[0];
            return;
        }
        this.unhashed = pGPSignatureSubpacketVector.toSubpacketArray();
    }

    public PGPOnePassSignature generateOnePassVersion(boolean bl) throws PGPException {
        return new PGPOnePassSignature(new OnePassSignaturePacket(this.sigType, this.contentSigner.getHashAlgorithm(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getKeyID(), bl));
    }

    public PGPSignature generate() throws PGPException {
        byte[] byArray;
        MPInteger[] mPIntegerArray;
        byte[] byArray2;
        Object object;
        int n = 4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SignatureSubpacket[] signatureSubpacketArray = !this.packetPresent(this.hashed, 2) ? this.insertSubpacket(this.hashed, new SignatureCreationTime(false, new Date())) : this.hashed;
        SignatureSubpacket[] signatureSubpacketArray2 = !this.packetPresent(this.hashed, 16) && !this.packetPresent(this.unhashed, 16) ? this.insertSubpacket(this.unhashed, new IssuerKeyID(false, this.contentSigner.getKeyID())) : this.unhashed;
        try {
            byteArrayOutputStream.write((byte)n);
            byteArrayOutputStream.write((byte)this.sigType);
            byteArrayOutputStream.write((byte)this.contentSigner.getKeyAlgorithm());
            byteArrayOutputStream.write((byte)this.contentSigner.getHashAlgorithm());
            object = new ByteArrayOutputStream();
            for (int i = 0; i != signatureSubpacketArray.length; ++i) {
                signatureSubpacketArray[i].encode((OutputStream)object);
            }
            byArray2 = ((ByteArrayOutputStream)object).toByteArray();
            byteArrayOutputStream.write((byte)(byArray2.length >> 8));
            byteArrayOutputStream.write((byte)byArray2.length);
            byteArrayOutputStream.write(byArray2);
        }
        catch (IOException iOException) {
            throw new PGPException("exception encoding hashed data.", iOException);
        }
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.write((byte)n);
        byteArrayOutputStream.write(-1);
        byteArrayOutputStream.write((byte)(((Object)object).length >> 24));
        byteArrayOutputStream.write((byte)(((Object)object).length >> 16));
        byteArrayOutputStream.write((byte)(((Object)object).length >> 8));
        byteArrayOutputStream.write((byte)((Object)object).length);
        byArray2 = byteArrayOutputStream.toByteArray();
        this.blockUpdate(byArray2, 0, byArray2.length);
        if (this.contentSigner.getKeyAlgorithm() == 3 || this.contentSigner.getKeyAlgorithm() == 1) {
            mPIntegerArray = new MPInteger[]{new MPInteger(new BigInteger(1, this.contentSigner.getSignature()))};
        } else if (this.contentSigner.getKeyAlgorithm() == 22) {
            byArray = this.contentSigner.getSignature();
            mPIntegerArray = new MPInteger[]{new MPInteger(new BigInteger(1, Arrays.copyOfRange(byArray, 0, byArray.length / 2))), new MPInteger(new BigInteger(1, Arrays.copyOfRange(byArray, byArray.length / 2, byArray.length)))};
        } else {
            mPIntegerArray = PGPUtil.dsaSigToMpi(this.contentSigner.getSignature());
        }
        byArray = this.contentSigner.getDigest();
        byte[] byArray3 = new byte[]{byArray[0], byArray[1]};
        return new PGPSignature(new SignaturePacket(this.sigType, this.contentSigner.getKeyID(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getHashAlgorithm(), signatureSubpacketArray, signatureSubpacketArray2, byArray3, mPIntegerArray));
    }

    public PGPSignature generateCertification(String string, PGPPublicKey pGPPublicKey) throws PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.updateWithIdData(180, Strings.toUTF8ByteArray(string));
        return this.generate();
    }

    public PGPSignature generateCertification(PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, PGPPublicKey pGPPublicKey) throws PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            UserAttributeSubpacket[] userAttributeSubpacketArray = pGPUserAttributeSubpacketVector.toSubpacketArray();
            for (int i = 0; i != userAttributeSubpacketArray.length; ++i) {
                userAttributeSubpacketArray[i].encode(byteArrayOutputStream);
            }
            this.updateWithIdData(209, byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new PGPException("cannot encode subpacket array", iOException);
        }
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2) throws PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.updateWithPublicKey(pGPPublicKey2);
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey pGPPublicKey) throws PGPException {
        if (!(this.sigType != 40 && this.sigType != 24 || pGPPublicKey.isMasterKey())) {
            throw new IllegalArgumentException("certifications involving subkey requires public key of revoking key as well.");
        }
        this.updateWithPublicKey(pGPPublicKey);
        return this.generate();
    }

    private byte[] getEncodedPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        byte[] byArray;
        try {
            byArray = pGPPublicKey.publicPk.getEncodedContents();
        }
        catch (IOException iOException) {
            throw new PGPException("exception preparing key.", iOException);
        }
        return byArray;
    }

    private boolean packetPresent(SignatureSubpacket[] signatureSubpacketArray, int n) {
        for (int i = 0; i != signatureSubpacketArray.length; ++i) {
            if (signatureSubpacketArray[i].getType() != n) continue;
            return true;
        }
        return false;
    }

    private SignatureSubpacket[] insertSubpacket(SignatureSubpacket[] signatureSubpacketArray, SignatureSubpacket signatureSubpacket) {
        SignatureSubpacket[] signatureSubpacketArray2 = new SignatureSubpacket[signatureSubpacketArray.length + 1];
        signatureSubpacketArray2[0] = signatureSubpacket;
        System.arraycopy(signatureSubpacketArray, 0, signatureSubpacketArray2, 1, signatureSubpacketArray.length);
        return signatureSubpacketArray2;
    }

    private void updateWithIdData(int n, byte[] byArray) {
        this.update((byte)n);
        this.update((byte)(byArray.length >> 24));
        this.update((byte)(byArray.length >> 16));
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
    }

    private void updateWithPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        byte[] byArray = this.getEncodedPublicKey(pGPPublicKey);
        this.update((byte)-103);
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
    }
}

