/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGInputStream;
import org.vafer.jdeb.shaded.bc.bcpg.ContainedPacket;
import org.vafer.jdeb.shaded.bc.bcpg.PublicKeyPacket;
import org.vafer.jdeb.shaded.bc.bcpg.PublicSubkeyPacket;
import org.vafer.jdeb.shaded.bc.bcpg.SecretKeyPacket;
import org.vafer.jdeb.shaded.bc.bcpg.SecretSubkeyPacket;
import org.vafer.jdeb.shaded.bc.bcpg.TrustPacket;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPKeyRing;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPublicKey;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPublicKeyRing;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSecretKey;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignature;
import org.vafer.jdeb.shaded.bc.openpgp.operator.KeyFingerPrintCalculator;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PBESecretKeyDecryptor;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PBESecretKeyEncryptor;
import org.vafer.jdeb.shaded.bc.util.Arrays;
import org.vafer.jdeb.shaded.bc.util.Iterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPSecretKeyRing
extends PGPKeyRing
implements Iterable<PGPSecretKey> {
    List keys;
    List extraPubKeys;

    private static List checkKeys(List list) {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(list.size());
        for (int i = 0; i != list.size(); ++i) {
            PGPSecretKey pGPSecretKey = (PGPSecretKey)list.get(i);
            if (i == 0) {
                if (!pGPSecretKey.isMasterKey()) {
                    throw new IllegalArgumentException("key 0 must be a master key");
                }
            } else if (pGPSecretKey.isMasterKey()) {
                throw new IllegalArgumentException("key 0 can be only master key");
            }
            arrayList.add(pGPSecretKey);
        }
        return arrayList;
    }

    public PGPSecretKeyRing(List list) {
        this(PGPSecretKeyRing.checkKeys(list), new ArrayList());
    }

    private PGPSecretKeyRing(List list, List list2) {
        this.keys = list;
        this.extraPubKeys = list2;
    }

    public PGPSecretKeyRing(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray), keyFingerPrintCalculator);
    }

    public PGPSecretKeyRing(InputStream inputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        this.keys = new ArrayList();
        this.extraPubKeys = new ArrayList();
        BCPGInputStream bCPGInputStream = PGPSecretKeyRing.wrap(inputStream);
        int n = bCPGInputStream.nextPacketTag();
        if (n != 5 && n != 7) {
            throw new IOException("secret key ring doesn't start with secret key tag: tag 0x" + Integer.toHexString(n));
        }
        SecretKeyPacket secretKeyPacket = (SecretKeyPacket)bCPGInputStream.readPacket();
        while (bCPGInputStream.nextPacketTag() == 61) {
            bCPGInputStream.readPacket();
        }
        TrustPacket trustPacket = PGPSecretKeyRing.readOptionalTrustPacket(bCPGInputStream);
        List list = PGPSecretKeyRing.readSignaturesAndTrust(bCPGInputStream);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        PGPSecretKeyRing.readUserIDs(bCPGInputStream, arrayList, arrayList2, arrayList3);
        this.keys.add(new PGPSecretKey(secretKeyPacket, new PGPPublicKey(secretKeyPacket.getPublicKeyPacket(), trustPacket, list, arrayList, arrayList2, arrayList3, keyFingerPrintCalculator)));
        while (bCPGInputStream.nextPacketTag() == 7 || bCPGInputStream.nextPacketTag() == 14) {
            List list2;
            TrustPacket trustPacket2;
            ContainedPacket containedPacket;
            if (bCPGInputStream.nextPacketTag() == 7) {
                containedPacket = (SecretSubkeyPacket)bCPGInputStream.readPacket();
                while (bCPGInputStream.nextPacketTag() == 61) {
                    bCPGInputStream.readPacket();
                }
                trustPacket2 = PGPSecretKeyRing.readOptionalTrustPacket(bCPGInputStream);
                list2 = PGPSecretKeyRing.readSignaturesAndTrust(bCPGInputStream);
                this.keys.add(new PGPSecretKey((SecretKeyPacket)containedPacket, new PGPPublicKey(((SecretKeyPacket)containedPacket).getPublicKeyPacket(), trustPacket2, list2, keyFingerPrintCalculator)));
                continue;
            }
            containedPacket = (PublicSubkeyPacket)bCPGInputStream.readPacket();
            trustPacket2 = PGPSecretKeyRing.readOptionalTrustPacket(bCPGInputStream);
            list2 = PGPSecretKeyRing.readSignaturesAndTrust(bCPGInputStream);
            this.extraPubKeys.add(new PGPPublicKey((PublicKeyPacket)containedPacket, trustPacket2, list2, keyFingerPrintCalculator));
        }
    }

    @Override
    public PGPPublicKey getPublicKey() {
        return ((PGPSecretKey)this.keys.get(0)).getPublicKey();
    }

    @Override
    public PGPPublicKey getPublicKey(long l) {
        PGPSecretKey pGPSecretKey = this.getSecretKey(l);
        if (pGPSecretKey != null) {
            return pGPSecretKey.getPublicKey();
        }
        for (int i = 0; i != this.extraPubKeys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(i);
            if (l != pGPPublicKey.getKeyID()) continue;
            return pGPPublicKey;
        }
        return null;
    }

    @Override
    public PGPPublicKey getPublicKey(byte[] byArray) {
        PGPSecretKey pGPSecretKey = this.getSecretKey(byArray);
        if (pGPSecretKey != null) {
            return pGPSecretKey.getPublicKey();
        }
        for (int i = 0; i != this.extraPubKeys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(i);
            if (!Arrays.areEqual(byArray, pGPPublicKey.getFingerprint())) continue;
            return pGPPublicKey;
        }
        return null;
    }

    @Override
    public Iterator<PGPPublicKey> getKeysWithSignaturesBy(long l) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        Iterator<PGPPublicKey> iterator = this.getPublicKeys();
        while (iterator.hasNext()) {
            PGPPublicKey pGPPublicKey = iterator.next();
            Iterator<PGPSignature> iterator2 = pGPPublicKey.getSignaturesForKeyID(l);
            if (!iterator2.hasNext()) continue;
            arrayList.add(pGPPublicKey);
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator<PGPPublicKey> getPublicKeys() {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        Iterator<PGPSecretKey> iterator = this.getSecretKeys();
        while (iterator.hasNext()) {
            PGPPublicKey pGPPublicKey = iterator.next().getPublicKey();
            arrayList.add(pGPPublicKey);
        }
        arrayList.addAll(this.extraPubKeys);
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public PGPSecretKey getSecretKey() {
        return (PGPSecretKey)this.keys.get(0);
    }

    public Iterator<PGPSecretKey> getSecretKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public PGPSecretKey getSecretKey(long l) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey pGPSecretKey = (PGPSecretKey)this.keys.get(i);
            if (l != pGPSecretKey.getKeyID()) continue;
            return pGPSecretKey;
        }
        return null;
    }

    public PGPSecretKey getSecretKey(byte[] byArray) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey pGPSecretKey = (PGPSecretKey)this.keys.get(i);
            if (!Arrays.areEqual(byArray, pGPSecretKey.getPublicKey().getFingerprint())) continue;
            return pGPSecretKey;
        }
        return null;
    }

    public Iterator<PGPPublicKey> getExtraPublicKeys() {
        return this.extraPubKeys.iterator();
    }

    @Override
    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        Object object;
        int n;
        for (n = 0; n != this.keys.size(); ++n) {
            object = (PGPSecretKey)this.keys.get(n);
            ((PGPSecretKey)object).encode(outputStream);
        }
        for (n = 0; n != this.extraPubKeys.size(); ++n) {
            object = (PGPPublicKey)this.extraPubKeys.get(n);
            ((PGPPublicKey)object).encode(outputStream);
        }
    }

    @Override
    public Iterator<PGPSecretKey> iterator() {
        return this.getSecretKeys();
    }

    public static PGPSecretKeyRing replacePublicKeys(PGPSecretKeyRing pGPSecretKeyRing, PGPPublicKeyRing pGPPublicKeyRing) {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys.size());
        for (PGPSecretKey pGPSecretKey : pGPSecretKeyRing.keys) {
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(pGPSecretKey.getKeyID());
            arrayList.add(PGPSecretKey.replacePublicKey(pGPSecretKey, pGPPublicKey));
        }
        return new PGPSecretKeyRing(arrayList);
    }

    public static PGPSecretKeyRing copyWithNewPassword(PGPSecretKeyRing pGPSecretKeyRing, PBESecretKeyDecryptor pBESecretKeyDecryptor, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys.size());
        Iterator<PGPSecretKey> iterator = pGPSecretKeyRing.getSecretKeys();
        while (iterator.hasNext()) {
            PGPSecretKey pGPSecretKey = iterator.next();
            if (pGPSecretKey.isPrivateKeyEmpty()) {
                arrayList.add(pGPSecretKey);
                continue;
            }
            arrayList.add(PGPSecretKey.copyWithNewPassword(pGPSecretKey, pBESecretKeyDecryptor, pBESecretKeyEncryptor));
        }
        return new PGPSecretKeyRing(arrayList, pGPSecretKeyRing.extraPubKeys);
    }

    public static PGPSecretKeyRing insertSecretKey(PGPSecretKeyRing pGPSecretKeyRing, PGPSecretKey pGPSecretKey) {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i != arrayList.size(); ++i) {
            PGPSecretKey pGPSecretKey2 = (PGPSecretKey)arrayList.get(i);
            if (pGPSecretKey2.getKeyID() == pGPSecretKey.getKeyID()) {
                bl = true;
                arrayList.set(i, pGPSecretKey);
            }
            if (!pGPSecretKey2.isMasterKey()) continue;
            bl2 = true;
        }
        if (!bl) {
            if (pGPSecretKey.isMasterKey()) {
                if (bl2) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                arrayList.add(0, pGPSecretKey);
            } else {
                arrayList.add(pGPSecretKey);
            }
        }
        return new PGPSecretKeyRing(arrayList, pGPSecretKeyRing.extraPubKeys);
    }

    public static PGPSecretKeyRing removeSecretKey(PGPSecretKeyRing pGPSecretKeyRing, PGPSecretKey pGPSecretKey) {
        ArrayList arrayList = new ArrayList(pGPSecretKeyRing.keys);
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            PGPSecretKey pGPSecretKey2 = (PGPSecretKey)arrayList.get(i);
            if (pGPSecretKey2.getKeyID() != pGPSecretKey.getKeyID()) continue;
            bl = true;
            arrayList.remove(i);
        }
        if (!bl) {
            return null;
        }
        return new PGPSecretKeyRing(arrayList, pGPSecretKeyRing.extraPubKeys);
    }
}

