/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.jcajce.provider.asymmetric.edec;

import java.io.IOException;
import java.security.interfaces.XECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.NamedParameterSpec;
import java.util.Optional;
import org.vafer.jdeb.shaded.bc.asn1.pkcs.PrivateKeyInfo;
import org.vafer.jdeb.shaded.bc.crypto.params.AsymmetricKeyParameter;
import org.vafer.jdeb.shaded.bc.crypto.params.X25519PrivateKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.X448PrivateKeyParameters;
import org.vafer.jdeb.shaded.bc.jcajce.provider.asymmetric.edec.BCXDHPrivateKey;

class BC11XDHPrivateKey
extends BCXDHPrivateKey
implements XECPrivateKey {
    BC11XDHPrivateKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        super(asymmetricKeyParameter);
    }

    BC11XDHPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        super(privateKeyInfo);
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        if (this.xdhPrivateKey instanceof X448PrivateKeyParameters) {
            return NamedParameterSpec.X448;
        }
        return NamedParameterSpec.X25519;
    }

    @Override
    public Optional<byte[]> getScalar() {
        if (this.xdhPrivateKey instanceof X448PrivateKeyParameters) {
            return Optional.of(((X448PrivateKeyParameters)this.xdhPrivateKey).getEncoded());
        }
        return Optional.of(((X25519PrivateKeyParameters)this.xdhPrivateKey).getEncoded());
    }
}

