/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Settings;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.vafer.jdeb.Console;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.DebMaker;
import org.vafer.jdeb.PackagingException;
import org.vafer.jdeb.maven.Data;
import org.vafer.jdeb.maven.MojoConsole;
import org.vafer.jdeb.shaded.commons.compress.archivers.tar.TarArchiveEntry;
import org.vafer.jdeb.utils.MapVariableResolver;
import org.vafer.jdeb.utils.SymlinkUtils;
import org.vafer.jdeb.utils.Utils;
import org.vafer.jdeb.utils.VariableResolver;

@Mojo(name="jdeb", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class DebMojo
extends AbstractMojo {
    @Component
    private MavenProjectHelper projectHelper;
    @Component(hint="jdeb-sec")
    private SecDispatcher secDispatcher;
    @Parameter
    private String name;
    @Parameter(defaultValue="[[buildDir]]/[[artifactId]]_[[version]]_all.[[extension]]")
    private String deb;
    @Parameter(defaultValue="[[baseDir]]/src/deb/control")
    private String controlDir;
    @Parameter(defaultValue="[[baseDir]]/CHANGES.txt")
    private String changesIn;
    @Parameter(defaultValue="[[buildDir]]/[[artifactId]]_[[version]]_all.changes")
    private String changesOut;
    @Parameter(defaultValue="[[baseDir]]/CHANGES.txt")
    private String changesSave;
    @Parameter(defaultValue="gzip")
    private String compression;
    @Parameter(defaultValue="true")
    private String attach;
    @Parameter(defaultValue="/opt/[[artifactId]]")
    private String installDir;
    @Parameter(defaultValue="deb")
    private String type;
    @Parameter(defaultValue="${basedir}", required=true, readonly=true)
    private File baseDir;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="project.build.directory", required=true, readonly=true)
    private File buildDirectory;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="SHA1")
    private String digest;
    @Parameter
    private Data[] dataSet;
    @Parameter(defaultValue="false")
    private boolean snapshotExpand;
    @Parameter(defaultValue="SNAPSHOT")
    private String snapshotEnv;
    @Parameter
    private String snapshotTemplate;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(property="jdeb.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="jdeb.skipPOMs", defaultValue="true")
    private boolean skipPOMs;
    @Parameter(property="jdeb.skipSubmodules", defaultValue="false")
    private boolean skipSubmodules;
    @Parameter(defaultValue="true")
    private boolean submodules;
    @Parameter(defaultValue="false")
    private boolean signPackage;
    @Parameter(defaultValue="false")
    private boolean signChanges;
    @Parameter(defaultValue="debsig-verify")
    private String signMethod;
    @Parameter(defaultValue="origin")
    private String signRole;
    @Parameter
    private String keyring;
    @Parameter
    private String key;
    @Parameter
    private String passphrase;
    @Parameter(defaultValue="jdeb.")
    private String signCfgPrefix;
    @Parameter(defaultValue="${settings}")
    private Settings settings;
    @Parameter(defaultValue="")
    private String propertyPrefix;
    @Parameter(defaultValue="gnu")
    private String tarLongFileMode;
    @Parameter(defaultValue="gnu")
    private String tarBigNumberMode;
    private static final String KEY = "key";
    private static final String KEYRING = "keyring";
    private static final String PASSPHRASE = "passphrase";
    private String openReplaceToken = "[[";
    private String closeReplaceToken = "]]";
    private Console console;
    private Collection<DataProducer> dataProducers = new ArrayList<DataProducer>();
    private Collection<DataProducer> conffileProducers = new ArrayList<DataProducer>();

    public void setOpenReplaceToken(String openReplaceToken) {
        this.openReplaceToken = openReplaceToken;
    }

    public void setCloseReplaceToken(String closeReplaceToken) {
        this.closeReplaceToken = closeReplaceToken;
    }

    protected void setData(Data[] dataSet) {
        this.dataSet = dataSet;
        this.dataProducers.clear();
        this.conffileProducers.clear();
        if (dataSet != null) {
            Collections.addAll(this.dataProducers, dataSet);
            for (Data item : dataSet) {
                if (!item.getConffile()) continue;
                this.conffileProducers.add(item);
            }
        }
    }

    protected VariableResolver initializeVariableResolver(Map<String, String> variables) {
        Map projectProperties = (Map)Map.class.cast(this.getProject().getProperties());
        Map systemProperties = (Map)Map.class.cast(System.getProperties());
        variables.putAll(projectProperties);
        variables.putAll(systemProperties);
        variables.put("name", this.name != null ? this.name : this.getProject().getName());
        variables.put("artifactId", this.getProject().getArtifactId());
        variables.put("groupId", this.getProject().getGroupId());
        variables.put("version", this.getProjectVersion());
        variables.put("description", this.getProject().getDescription());
        variables.put("extension", "deb");
        variables.put("baseDir", this.getProject().getBasedir().getAbsolutePath());
        variables.put("buildDir", this.buildDirectory.getAbsolutePath());
        variables.put("project.version", this.getProject().getVersion());
        variables.put("url", this.getProject().getUrl());
        return new MapVariableResolver(variables);
    }

    private String getProjectVersion() {
        return Utils.convertToDebianVersion(this.getProject().getVersion(), this.snapshotExpand, this.snapshotEnv, this.snapshotTemplate, this.session.getStartTime());
    }

    private boolean isPOM() {
        String type = this.getProject().getArtifact().getType();
        return "pom".equalsIgnoreCase(type);
    }

    private boolean isType() {
        return this.type.equals(this.getProject().getArtifact().getType());
    }

    private boolean isSubmodule() {
        return !this.session.getExecutionRootDirectory().equalsIgnoreCase(this.baseDir.toString());
    }

    private boolean hasMainArtifact() {
        MavenProject project = this.getProject();
        Artifact artifact = project.getArtifact();
        return artifact.getFile() != null && artifact.getFile().isFile();
    }

    public void execute() throws MojoExecutionException {
        File keyringFile;
        MavenProject project = this.getProject();
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping as configured (skip)");
            return;
        }
        if (this.skipPOMs && this.isPOM()) {
            this.getLog().info((CharSequence)"skipping because artifact is a pom (skipPOMs)");
            return;
        }
        if (this.skipSubmodules && this.isSubmodule()) {
            this.getLog().info((CharSequence)"skipping submodule (skipSubmodules)");
            return;
        }
        this.setData(this.dataSet);
        this.console = new MojoConsole(this.getLog(), this.verbose);
        this.initializeSignProperties();
        VariableResolver resolver = this.initializeVariableResolver(new HashMap<String, String>());
        File debFile = new File(Utils.replaceVariables(resolver, this.deb, this.openReplaceToken, this.closeReplaceToken));
        File controlDirFile = new File(Utils.replaceVariables(resolver, this.controlDir, this.openReplaceToken, this.closeReplaceToken));
        final File installDirFile = new File(Utils.replaceVariables(resolver, this.installDir, this.openReplaceToken, this.closeReplaceToken));
        File changesInFile = new File(Utils.replaceVariables(resolver, this.changesIn, this.openReplaceToken, this.closeReplaceToken));
        File changesOutFile = new File(Utils.replaceVariables(resolver, this.changesOut, this.openReplaceToken, this.closeReplaceToken));
        File changesSaveFile = new File(Utils.replaceVariables(resolver, this.changesSave, this.openReplaceToken, this.closeReplaceToken));
        File file = keyringFile = this.keyring == null ? null : new File(Utils.replaceVariables(resolver, this.keyring, this.openReplaceToken, this.closeReplaceToken));
        if (this.dataProducers.isEmpty() && this.hasMainArtifact()) {
            HashSet<Artifact> artifacts = new HashSet<Artifact>();
            artifacts.add(project.getArtifact());
            Set projectArtifacts = project.getArtifacts();
            for (Artifact artifact : projectArtifacts) {
                artifacts.add(artifact);
            }
            List attachedArtifacts = project.getAttachedArtifacts();
            for (Artifact artifact : attachedArtifacts) {
                artifacts.add(artifact);
            }
            for (Artifact artifact : artifacts) {
                final File file2 = artifact.getFile();
                if (file2 != null) {
                    this.dataProducers.add(new DataProducer(){

                        @Override
                        public void produce(DataConsumer receiver) {
                            try {
                                TarArchiveEntry e;
                                File path = new File(installDirFile.getPath(), file2.getName());
                                String entryName = path.getPath();
                                boolean symbolicLink = SymlinkUtils.isSymbolicLink(path);
                                if (symbolicLink) {
                                    e = new TarArchiveEntry(entryName, 50);
                                    e.setLinkName(SymlinkUtils.readSymbolicLink(path));
                                } else {
                                    e = new TarArchiveEntry(entryName, true);
                                }
                                e.setUserId(0);
                                e.setGroupId(0);
                                e.setUserName("root");
                                e.setGroupName("root");
                                e.setMode(33188);
                                e.setSize(file2.length());
                                receiver.onEachFile(new FileInputStream(file2), e);
                            }
                            catch (Exception e) {
                                DebMojo.this.getLog().error((Throwable)e);
                            }
                        }
                    });
                    continue;
                }
                this.getLog().error((CharSequence)("No file for artifact " + artifact));
            }
        }
        try {
            DebMaker debMaker = new DebMaker(this.console, this.dataProducers, this.conffileProducers);
            debMaker.setDeb(debFile);
            debMaker.setControl(controlDirFile);
            debMaker.setPackage(this.getProject().getArtifactId());
            debMaker.setDescription(this.getProject().getDescription());
            debMaker.setHomepage(this.getProject().getUrl());
            debMaker.setChangesIn(changesInFile);
            debMaker.setChangesOut(changesOutFile);
            debMaker.setChangesSave(changesSaveFile);
            debMaker.setCompression(this.compression);
            debMaker.setKeyring(keyringFile);
            debMaker.setKey(this.key);
            debMaker.setPassphrase(this.passphrase);
            debMaker.setSignPackage(this.signPackage);
            debMaker.setSignChanges(this.signChanges);
            debMaker.setSignMethod(this.signMethod);
            debMaker.setSignRole(this.signRole);
            debMaker.setResolver(resolver);
            debMaker.setOpenReplaceToken(this.openReplaceToken);
            debMaker.setCloseReplaceToken(this.closeReplaceToken);
            debMaker.setDigest(this.digest);
            debMaker.setTarBigNumberMode(this.tarBigNumberMode);
            debMaker.setTarLongFileMode(this.tarLongFileMode);
            debMaker.validate();
            debMaker.makeDeb();
            if ("true".equalsIgnoreCase(this.attach)) {
                this.console.info("Attaching created debian package " + debFile);
                if (!this.isType()) {
                    this.projectHelper.attachArtifact(project, this.type, this.classifier, debFile);
                } else {
                    project.getArtifact().setFile(debFile);
                }
            }
        }
        catch (PackagingException e) {
            this.getLog().error((CharSequence)("Failed to create debian package " + debFile), (Throwable)e);
            throw new MojoExecutionException("Failed to create debian package " + debFile, (Exception)e);
        }
        if (!Utils.isBlank(this.propertyPrefix)) {
            project.getProperties().put(this.propertyPrefix + "version", this.getProjectVersion());
            project.getProperties().put(this.propertyPrefix + "deb", debFile.getAbsolutePath());
            project.getProperties().put(this.propertyPrefix + "deb.name", debFile.getName());
            project.getProperties().put(this.propertyPrefix + "changes", changesOutFile.getAbsolutePath());
            project.getProperties().put(this.propertyPrefix + "changes.name", changesOutFile.getName());
            project.getProperties().put(this.propertyPrefix + "changes.txt", changesSaveFile.getAbsolutePath());
            project.getProperties().put(this.propertyPrefix + "changes.txt.name", changesSaveFile.getName());
        }
    }

    private void initializeSignProperties() {
        if (!this.signPackage && !this.signChanges) {
            return;
        }
        if (this.key != null && this.keyring != null && this.passphrase != null) {
            return;
        }
        Map<String, String> properties = this.readPropertiesFromActiveProfiles(this.signCfgPrefix, KEY, KEYRING, PASSPHRASE);
        this.key = Utils.lookupIfEmpty(this.key, properties, KEY);
        this.keyring = Utils.lookupIfEmpty(this.keyring, properties, KEYRING);
        this.passphrase = this.decrypt(Utils.lookupIfEmpty(this.passphrase, properties, PASSPHRASE));
        if (this.keyring == null) {
            try {
                this.keyring = Utils.guessKeyRingFile().getAbsolutePath();
                this.console.info("Located keyring at " + this.keyring);
            }
            catch (FileNotFoundException e) {
                this.console.warn(e.getMessage());
            }
        }
    }

    private String decrypt(String maybeEncryptedPassphrase) {
        if (maybeEncryptedPassphrase == null) {
            return null;
        }
        try {
            String decrypted = this.secDispatcher.decrypt(maybeEncryptedPassphrase);
            if (maybeEncryptedPassphrase.equals(decrypted)) {
                this.console.info("Passphrase was not encrypted");
            } else {
                this.console.info("Passphrase was successfully decrypted");
            }
            return decrypted;
        }
        catch (SecDispatcherException e) {
            this.console.warn("Unable to decrypt passphrase: " + e.getMessage());
            return maybeEncryptedPassphrase;
        }
    }

    private MavenProject getProject() {
        if (this.project.getExecutionProject() != null) {
            return this.project.getExecutionProject();
        }
        return this.project;
    }

    public Map<String, String> readPropertiesFromActiveProfiles(String prefix, String ... properties) {
        if (this.settings == null) {
            this.console.debug("No maven setting injected");
            return Collections.emptyMap();
        }
        List activeProfilesList = this.settings.getActiveProfiles();
        if (activeProfilesList.isEmpty()) {
            this.console.debug("No active profiles found");
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashSet activeProfiles = new HashSet(activeProfilesList);
        for (Profile profile : this.settings.getProfiles()) {
            String profileId = profile.getId();
            if (!activeProfiles.contains(profileId)) continue;
            this.console.debug("Trying active profile " + profileId);
            for (String property : properties) {
                String propKey = prefix != null ? prefix + property : property;
                String value = profile.getProperties().getProperty(propKey);
                if (value == null) continue;
                this.console.debug("Found property " + property + " in profile " + profileId);
                map.put(property, value);
            }
        }
        return map;
    }
}

