/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import org.vafer.jdeb.shaded.bc.jcajce.DefaultJcaJceHelper;
import org.vafer.jdeb.shaded.bc.jcajce.NamedJcaJceHelper;
import org.vafer.jdeb.shaded.bc.jcajce.ProviderJcaJceHelper;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PBESecretKeyDecryptor;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPDigestCalculatorProvider;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.OperatorHelper;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.PGPUtil;

public class JcePBESecretKeyDecryptorBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private PGPDigestCalculatorProvider calculatorProvider;
    private JcaPGPDigestCalculatorProviderBuilder calculatorProviderBuilder;

    public JcePBESecretKeyDecryptorBuilder() {
        this.calculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    }

    public JcePBESecretKeyDecryptorBuilder(PGPDigestCalculatorProvider pGPDigestCalculatorProvider) {
        this.calculatorProvider = pGPDigestCalculatorProvider;
    }

    public JcePBESecretKeyDecryptorBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        if (this.calculatorProviderBuilder != null) {
            this.calculatorProviderBuilder.setProvider(provider);
        }
        return this;
    }

    public JcePBESecretKeyDecryptorBuilder setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        if (this.calculatorProviderBuilder != null) {
            this.calculatorProviderBuilder.setProvider(string);
        }
        return this;
    }

    public PBESecretKeyDecryptor build(char[] cArray) throws PGPException {
        if (this.calculatorProvider == null) {
            this.calculatorProvider = this.calculatorProviderBuilder.build();
        }
        return new PBESecretKeyDecryptor(cArray, this.calculatorProvider){

            public byte[] recoverKeyData(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) throws PGPException {
                try {
                    Cipher cipher = JcePBESecretKeyDecryptorBuilder.this.helper.createCipher(PGPUtil.getSymmetricCipherName(n) + "/CFB/NoPadding");
                    cipher.init(2, (Key)PGPUtil.makeSymmetricKey(n, byArray), new IvParameterSpec(byArray2));
                    return cipher.doFinal(byArray3, n2, n3);
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    throw new PGPException("illegal block size: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
                }
                catch (BadPaddingException badPaddingException) {
                    throw new PGPException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new PGPException("invalid parameter: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new PGPException("invalid key: " + invalidKeyException.getMessage(), invalidKeyException);
                }
            }
        };
    }
}

