/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Date;
import org.vafer.jdeb.shaded.bc.asn1.ASN1ObjectIdentifier;
import org.vafer.jdeb.shaded.bc.asn1.DEROctetString;
import org.vafer.jdeb.shaded.bc.asn1.nist.NISTNamedCurves;
import org.vafer.jdeb.shaded.bc.asn1.x509.SubjectPublicKeyInfo;
import org.vafer.jdeb.shaded.bc.asn1.x9.X9ECParameters;
import org.vafer.jdeb.shaded.bc.asn1.x9.X9ECPoint;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGObject;
import org.vafer.jdeb.shaded.bc.bcpg.DSAPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.DSASecretBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ECDHPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ECDSAPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ECSecretBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ElGamalPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ElGamalSecretBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.PublicKeyPacket;
import org.vafer.jdeb.shaded.bc.bcpg.RSAPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.RSASecretBCPGKey;
import org.vafer.jdeb.shaded.bc.jcajce.DefaultJcaJceHelper;
import org.vafer.jdeb.shaded.bc.jcajce.NamedJcaJceHelper;
import org.vafer.jdeb.shaded.bc.jcajce.ProviderJcaJceHelper;
import org.vafer.jdeb.shaded.bc.jce.interfaces.ElGamalPrivateKey;
import org.vafer.jdeb.shaded.bc.jce.interfaces.ElGamalPublicKey;
import org.vafer.jdeb.shaded.bc.jce.spec.ECNamedCurveSpec;
import org.vafer.jdeb.shaded.bc.jce.spec.ElGamalParameterSpec;
import org.vafer.jdeb.shaded.bc.jce.spec.ElGamalPrivateKeySpec;
import org.vafer.jdeb.shaded.bc.jce.spec.ElGamalPublicKeySpec;
import org.vafer.jdeb.shaded.bc.openpgp.PGPAlgorithmParameters;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPKdfParameters;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPrivateKey;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPublicKey;
import org.vafer.jdeb.shaded.bc.openpgp.operator.KeyFingerPrintCalculator;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.JcaPGPPrivateKey;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.OperatorHelper;

public class JcaPGPKeyConverter {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private KeyFingerPrintCalculator fingerPrintCalculator = new JcaKeyFingerprintCalculator();

    public JcaPGPKeyConverter setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaPGPKeyConverter setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public PublicKey getPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent());
                    KeyFactory keyFactory = this.helper.createKeyFactory("RSA");
                    return keyFactory.generatePublic(rSAPublicKeySpec);
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicBCPGKey.getY(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    KeyFactory keyFactory = this.helper.createKeyFactory("DSA");
                    return keyFactory.generatePublic(dSAPublicKeySpec);
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    ElGamalPublicKeySpec elGamalPublicKeySpec = new ElGamalPublicKeySpec(elGamalPublicBCPGKey.getY(), new ElGamalParameterSpec(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                    KeyFactory keyFactory = this.helper.createKeyFactory("ElGamal");
                    return keyFactory.generatePublic(elGamalPublicKeySpec);
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(new ECPoint(eCDHPublicBCPGKey.getPoint().getAffineXCoord().toBigInteger(), eCDHPublicBCPGKey.getPoint().getAffineYCoord().toBigInteger()), this.convertX9Parameters(eCDHPublicBCPGKey.getCurveOID(), NISTNamedCurves.getByOID(eCDHPublicBCPGKey.getCurveOID())));
                    KeyFactory keyFactory = this.helper.createKeyFactory("ECDH");
                    return keyFactory.generatePublic(eCPublicKeySpec);
                }
                case 19: {
                    ECDSAPublicBCPGKey eCDSAPublicBCPGKey = (ECDSAPublicBCPGKey)publicKeyPacket.getKey();
                    ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(new ECPoint(eCDSAPublicBCPGKey.getPoint().getAffineXCoord().toBigInteger(), eCDSAPublicBCPGKey.getPoint().getAffineYCoord().toBigInteger()), this.convertX9Parameters(eCDSAPublicBCPGKey.getCurveOID(), NISTNamedCurves.getByOID(eCDSAPublicBCPGKey.getCurveOID())));
                    KeyFactory keyFactory = this.helper.createKeyFactory("ECDSA");
                    return keyFactory.generatePublic(eCPublicKeySpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    public PGPPublicKey getPGPPublicKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, PublicKey publicKey, Date date) throws PGPException {
        BCPGObject bCPGObject;
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            bCPGObject = new RSAPublicBCPGKey(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        } else if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAParams dSAParams = dSAPublicKey.getParams();
            bCPGObject = new DSAPublicBCPGKey(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG(), dSAPublicKey.getY());
        } else if (publicKey instanceof ElGamalPublicKey) {
            ElGamalPublicKey elGamalPublicKey = (ElGamalPublicKey)publicKey;
            ElGamalParameterSpec elGamalParameterSpec = elGamalPublicKey.getParameters();
            bCPGObject = new ElGamalPublicBCPGKey(elGamalParameterSpec.getP(), elGamalParameterSpec.getG(), elGamalPublicKey.getY());
        } else if (publicKey instanceof ECPublicKey) {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            X9ECParameters x9ECParameters = NISTNamedCurves.getByOID(aSN1ObjectIdentifier);
            DEROctetString dEROctetString = new DEROctetString(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            X9ECPoint x9ECPoint = new X9ECPoint(x9ECParameters.getCurve(), dEROctetString);
            if (n == 18) {
                PGPKdfParameters pGPKdfParameters = (PGPKdfParameters)pGPAlgorithmParameters;
                if (pGPKdfParameters == null) {
                    pGPKdfParameters = new PGPKdfParameters(8, 7);
                }
                bCPGObject = new ECDHPublicBCPGKey(aSN1ObjectIdentifier, x9ECPoint.getPoint(), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
            } else {
                bCPGObject = new ECDSAPublicBCPGKey(aSN1ObjectIdentifier, x9ECPoint.getPoint());
            }
        } else {
            throw new PGPException("unknown key class");
        }
        return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)((Object)bCPGObject)), this.fingerPrintCalculator);
    }

    public PGPPublicKey getPGPPublicKey(int n, PublicKey publicKey, Date date) throws PGPException {
        return this.getPGPPublicKey(n, null, publicKey, date);
    }

    public PrivateKey getPrivateKey(PGPPrivateKey pGPPrivateKey) throws PGPException {
        if (pGPPrivateKey instanceof JcaPGPPrivateKey) {
            return ((JcaPGPPrivateKey)pGPPrivateKey).getPrivateKey();
        }
        PublicKeyPacket publicKeyPacket = pGPPrivateKey.getPublicKeyPacket();
        BCPGKey bCPGKey = pGPPrivateKey.getPrivateKeyDataPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSASecretBCPGKey rSASecretBCPGKey = (RSASecretBCPGKey)bCPGKey;
                    RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(rSASecretBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent(), rSASecretBCPGKey.getPrivateExponent(), rSASecretBCPGKey.getPrimeP(), rSASecretBCPGKey.getPrimeQ(), rSASecretBCPGKey.getPrimeExponentP(), rSASecretBCPGKey.getPrimeExponentQ(), rSASecretBCPGKey.getCrtCoefficient());
                    KeyFactory keyFactory = this.helper.createKeyFactory("RSA");
                    return keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSASecretBCPGKey dSASecretBCPGKey = (DSASecretBCPGKey)bCPGKey;
                    DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(dSASecretBCPGKey.getX(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    KeyFactory keyFactory = this.helper.createKeyFactory("DSA");
                    return keyFactory.generatePrivate(dSAPrivateKeySpec);
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    ECSecretBCPGKey eCSecretBCPGKey = (ECSecretBCPGKey)bCPGKey;
                    ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(eCSecretBCPGKey.getX(), this.convertX9Parameters(eCDHPublicBCPGKey.getCurveOID(), NISTNamedCurves.getByOID(eCDHPublicBCPGKey.getCurveOID())));
                    KeyFactory keyFactory = this.helper.createKeyFactory("ECDH");
                    return keyFactory.generatePrivate(eCPrivateKeySpec);
                }
                case 19: {
                    ECDSAPublicBCPGKey eCDSAPublicBCPGKey = (ECDSAPublicBCPGKey)publicKeyPacket.getKey();
                    ECSecretBCPGKey eCSecretBCPGKey = (ECSecretBCPGKey)bCPGKey;
                    ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(eCSecretBCPGKey.getX(), this.convertX9Parameters(eCDSAPublicBCPGKey.getCurveOID(), NISTNamedCurves.getByOID(eCDSAPublicBCPGKey.getCurveOID())));
                    KeyFactory keyFactory = this.helper.createKeyFactory("ECDSA");
                    return keyFactory.generatePrivate(eCPrivateKeySpec);
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    ElGamalSecretBCPGKey elGamalSecretBCPGKey = (ElGamalSecretBCPGKey)bCPGKey;
                    ElGamalPrivateKeySpec elGamalPrivateKeySpec = new ElGamalPrivateKeySpec(elGamalSecretBCPGKey.getX(), new ElGamalParameterSpec(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                    KeyFactory keyFactory = this.helper.createKeyFactory("ElGamal");
                    return keyFactory.generatePrivate(elGamalPrivateKeySpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception constructing key", exception);
        }
    }

    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pGPPublicKey, PrivateKey privateKey) throws PGPException {
        BCPGObject bCPGObject;
        switch (pGPPublicKey.getAlgorithm()) {
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
                bCPGObject = new RSASecretBCPGKey(rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ());
                break;
            }
            case 17: {
                DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
                bCPGObject = new DSASecretBCPGKey(dSAPrivateKey.getX());
                break;
            }
            case 16: 
            case 20: {
                ElGamalPrivateKey elGamalPrivateKey = (ElGamalPrivateKey)privateKey;
                bCPGObject = new ElGamalSecretBCPGKey(elGamalPrivateKey.getX());
                break;
            }
            case 18: 
            case 19: {
                ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
                bCPGObject = new ECSecretBCPGKey(eCPrivateKey.getS());
                break;
            }
            default: {
                throw new PGPException("unknown key class");
            }
        }
        return new PGPPrivateKey(pGPPublicKey.getKeyID(), pGPPublicKey.getPublicKeyPacket(), (BCPGKey)((Object)bCPGObject));
    }

    private ECParameterSpec convertX9Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier, X9ECParameters x9ECParameters) {
        return new ECNamedCurveSpec(aSN1ObjectIdentifier.getId(), x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
    }
}

