/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGInputStream;
import org.vafer.jdeb.shaded.bc.openpgp.PGPCompressedData;
import org.vafer.jdeb.shaded.bc.openpgp.PGPEncryptedDataList;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPLiteralData;
import org.vafer.jdeb.shaded.bc.openpgp.PGPMarker;
import org.vafer.jdeb.shaded.bc.openpgp.PGPOnePassSignature;
import org.vafer.jdeb.shaded.bc.openpgp.PGPOnePassSignatureList;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPublicKeyRing;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSecretKeyRing;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignature;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignatureList;
import org.vafer.jdeb.shaded.bc.openpgp.operator.KeyFingerPrintCalculator;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;

public class PGPObjectFactory {
    private BCPGInputStream in;
    private KeyFingerPrintCalculator fingerPrintCalculator;

    public PGPObjectFactory(InputStream inputStream) {
        this(inputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
    }

    public PGPObjectFactory(InputStream inputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) {
        this.in = new BCPGInputStream(inputStream);
        this.fingerPrintCalculator = keyFingerPrintCalculator;
    }

    public PGPObjectFactory(byte[] byArray) {
        this(new ByteArrayInputStream(byArray));
    }

    public PGPObjectFactory(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator) {
        this(new ByteArrayInputStream(byArray), keyFingerPrintCalculator);
    }

    public Object nextObject() throws IOException {
        switch (this.in.nextPacketTag()) {
            case -1: {
                return null;
            }
            case 2: {
                ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
                while (this.in.nextPacketTag() == 2) {
                    try {
                        arrayList.add(new PGPSignature(this.in));
                    }
                    catch (PGPException pGPException) {
                        throw new IOException("can't create signature object: " + pGPException);
                    }
                }
                return new PGPSignatureList(arrayList.toArray(new PGPSignature[arrayList.size()]));
            }
            case 5: {
                try {
                    return new PGPSecretKeyRing(this.in, this.fingerPrintCalculator);
                }
                catch (PGPException pGPException) {
                    throw new IOException("can't create secret key object: " + pGPException);
                }
            }
            case 6: {
                return new PGPPublicKeyRing(this.in, this.fingerPrintCalculator);
            }
            case 14: {
                try {
                    return PGPPublicKeyRing.readSubkey(this.in, this.fingerPrintCalculator);
                }
                catch (PGPException pGPException) {
                    throw new IOException("processing error: " + pGPException.getMessage());
                }
            }
            case 8: {
                return new PGPCompressedData(this.in);
            }
            case 11: {
                return new PGPLiteralData(this.in);
            }
            case 1: 
            case 3: {
                return new PGPEncryptedDataList(this.in);
            }
            case 4: {
                ArrayList<PGPOnePassSignature> arrayList = new ArrayList<PGPOnePassSignature>();
                while (this.in.nextPacketTag() == 4) {
                    try {
                        arrayList.add(new PGPOnePassSignature(this.in));
                    }
                    catch (PGPException pGPException) {
                        throw new IOException("can't create one pass signature object: " + pGPException);
                    }
                }
                return new PGPOnePassSignatureList(arrayList.toArray(new PGPOnePassSignature[arrayList.size()]));
            }
            case 10: {
                return new PGPMarker(this.in);
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return this.in.readPacket();
            }
        }
        throw new IOException("unknown object in stream: " + this.in.nextPacketTag());
    }
}

