/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp.operator.bc;

import java.io.IOException;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.MPInteger;
import org.vafer.jdeb.shaded.bc.bcpg.PublicKeyPacket;
import org.vafer.jdeb.shaded.bc.bcpg.RSAPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.UnsupportedPacketVersionException;
import org.vafer.jdeb.shaded.bc.crypto.digests.GeneralDigest;
import org.vafer.jdeb.shaded.bc.crypto.digests.MD5Digest;
import org.vafer.jdeb.shaded.bc.crypto.digests.SHA1Digest;
import org.vafer.jdeb.shaded.bc.crypto.digests.SHA256Digest;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.operator.KeyFingerPrintCalculator;

public class BcKeyFingerprintCalculator
implements KeyFingerPrintCalculator {
    @Override
    public byte[] calculateFingerprint(PublicKeyPacket publicKeyPacket) throws PGPException {
        GeneralDigest generalDigest;
        Object object;
        BCPGKey bCPGKey = publicKeyPacket.getKey();
        if (publicKeyPacket.getVersion() <= 3) {
            object = (RSAPublicBCPGKey)bCPGKey;
            try {
                generalDigest = new MD5Digest();
                byte[] byArray = new MPInteger(((RSAPublicBCPGKey)object).getModulus()).getEncoded();
                generalDigest.update(byArray, 2, byArray.length - 2);
                byArray = new MPInteger(((RSAPublicBCPGKey)object).getPublicExponent()).getEncoded();
                generalDigest.update(byArray, 2, byArray.length - 2);
            }
            catch (IOException iOException) {
                throw new PGPException("can't encode key components: " + iOException.getMessage(), iOException);
            }
        } else if (publicKeyPacket.getVersion() == 4) {
            try {
                object = publicKeyPacket.getEncodedContents();
                generalDigest = new SHA1Digest();
                generalDigest.update((byte)-103);
                generalDigest.update((byte)(((Object)object).length >> 8));
                generalDigest.update((byte)((Object)object).length);
                generalDigest.update((byte[])object, 0, ((Object)object).length);
            }
            catch (IOException iOException) {
                throw new PGPException("can't encode key components: " + iOException.getMessage(), iOException);
            }
        } else if (publicKeyPacket.getVersion() == 5 || publicKeyPacket.getVersion() == 6) {
            try {
                object = publicKeyPacket.getEncodedContents();
                generalDigest = new SHA256Digest();
                generalDigest.update((byte)(publicKeyPacket.getVersion() == 6 ? 155 : 154));
                generalDigest.update((byte)(((Object)object).length >> 24));
                generalDigest.update((byte)(((Object)object).length >> 16));
                generalDigest.update((byte)(((Object)object).length >> 8));
                generalDigest.update((byte)((Object)object).length);
                generalDigest.update((byte[])object, 0, ((Object)object).length);
            }
            catch (IOException iOException) {
                throw new PGPException("can't encode key components: " + iOException.getMessage(), iOException);
            }
        } else {
            throw new UnsupportedPacketVersionException("Unsupported PGP key version: " + publicKeyPacket.getVersion());
        }
        object = new byte[generalDigest.getDigestSize()];
        generalDigest.doFinal((byte[])object, 0);
        return object;
    }
}

