/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp.operator;

import java.io.IOException;
import java.math.BigInteger;
import org.vafer.jdeb.shaded.bc.asn1.ASN1ObjectIdentifier;
import org.vafer.jdeb.shaded.bc.asn1.DEROctetString;
import org.vafer.jdeb.shaded.bc.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.vafer.jdeb.shaded.bc.asn1.edec.EdECObjectIdentifiers;
import org.vafer.jdeb.shaded.bc.asn1.pkcs.PrivateKeyInfo;
import org.vafer.jdeb.shaded.bc.asn1.sec.SECObjectIdentifiers;
import org.vafer.jdeb.shaded.bc.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.vafer.jdeb.shaded.bc.asn1.x509.AlgorithmIdentifier;
import org.vafer.jdeb.shaded.bc.openpgp.PGPAlgorithmParameters;
import org.vafer.jdeb.shaded.bc.openpgp.PGPKdfParameters;
import org.vafer.jdeb.shaded.bc.util.BigIntegers;

public abstract class PGPKeyConverter {
    protected PGPKeyConverter() {
    }

    protected PGPKdfParameters implGetKdfParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier, PGPAlgorithmParameters pGPAlgorithmParameters) {
        if (null == pGPAlgorithmParameters) {
            if (aSN1ObjectIdentifier.equals(SECObjectIdentifiers.secp256r1) || aSN1ObjectIdentifier.equals(TeleTrusTObjectIdentifiers.brainpoolP256r1) || aSN1ObjectIdentifier.equals(CryptlibObjectIdentifiers.curvey25519) || aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X25519)) {
                return new PGPKdfParameters(8, 7);
            }
            if (aSN1ObjectIdentifier.equals(SECObjectIdentifiers.secp384r1) || aSN1ObjectIdentifier.equals(TeleTrusTObjectIdentifiers.brainpoolP384r1)) {
                return new PGPKdfParameters(9, 8);
            }
            if (aSN1ObjectIdentifier.equals(SECObjectIdentifiers.secp521r1) || aSN1ObjectIdentifier.equals(TeleTrusTObjectIdentifiers.brainpoolP512r1) || aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X448)) {
                return new PGPKdfParameters(10, 9);
            }
            throw new IllegalArgumentException("unknown curve");
        }
        return (PGPKdfParameters)pGPAlgorithmParameters;
    }

    protected PrivateKeyInfo getPrivateKeyInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n, byte[] byArray) throws IOException {
        return new PrivateKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier), new DEROctetString(BigIntegers.asUnsignedByteArray(n, new BigInteger(1, byArray))));
    }

    protected PrivateKeyInfo getPrivateKeyInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) throws IOException {
        return new PrivateKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier), new DEROctetString(byArray));
    }
}

