/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.crypto.signers;

import java.io.ByteArrayOutputStream;
import org.vafer.jdeb.shaded.bc.crypto.CipherParameters;
import org.vafer.jdeb.shaded.bc.crypto.CryptoServicesRegistrar;
import org.vafer.jdeb.shaded.bc.crypto.Signer;
import org.vafer.jdeb.shaded.bc.crypto.params.Ed25519PrivateKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.Ed25519PublicKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.ParametersWithRandom;
import org.vafer.jdeb.shaded.bc.crypto.signers.Utils;
import org.vafer.jdeb.shaded.bc.util.Arrays;

public class Ed25519Signer
implements Signer {
    private final Buffer buffer = new Buffer();
    private boolean forSigning;
    private Ed25519PrivateKeyParameters privateKey;
    private Ed25519PublicKeyParameters publicKey;

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forSigning = bl;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        if (bl) {
            this.privateKey = (Ed25519PrivateKeyParameters)cipherParameters;
            this.publicKey = null;
        } else {
            this.privateKey = null;
            this.publicKey = (Ed25519PublicKeyParameters)cipherParameters;
        }
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties("Ed25519", 128, cipherParameters, bl));
        this.reset();
    }

    @Override
    public void update(byte by) {
        this.buffer.write(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.buffer.write(byArray, n, n2);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.forSigning || null == this.privateKey) {
            throw new IllegalStateException("Ed25519Signer not initialised for signature generation.");
        }
        return this.buffer.generateSignature(this.privateKey);
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        if (this.forSigning || null == this.publicKey) {
            throw new IllegalStateException("Ed25519Signer not initialised for verification");
        }
        return this.buffer.verifySignature(this.publicKey, byArray);
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }

    private static final class Buffer
    extends ByteArrayOutputStream {
        private Buffer() {
        }

        synchronized byte[] generateSignature(Ed25519PrivateKeyParameters ed25519PrivateKeyParameters) {
            byte[] byArray = new byte[64];
            ed25519PrivateKeyParameters.sign(0, null, this.buf, 0, this.count, byArray, 0);
            this.reset();
            return byArray;
        }

        synchronized boolean verifySignature(Ed25519PublicKeyParameters ed25519PublicKeyParameters, byte[] byArray) {
            if (64 != byArray.length) {
                this.reset();
                return false;
            }
            boolean bl = ed25519PublicKeyParameters.verify(0, null, this.buf, 0, this.count, byArray, 0);
            this.reset();
            return bl;
        }

        @Override
        public synchronized void reset() {
            Arrays.fill(this.buf, 0, this.count, (byte)0);
            this.count = 0;
        }
    }
}

