/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.debian;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vafer.jdeb.debian.ControlField;

public abstract class ControlFile {
    protected final Map<String, String> values = new LinkedHashMap<String, String>();
    protected final Map<String, String> userDefinedFields = new LinkedHashMap<String, String>();
    protected final Set<ControlField> userDefinedFieldNames = new HashSet<ControlField>();

    public void parse(String input) throws IOException, ParseException {
        this.parse(new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8)));
    }

    public void parse(InputStream input) throws IOException, ParseException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        StringBuilder buffer = new StringBuilder();
        String field = null;
        int linenr = 0;
        while (true) {
            String line;
            if ((line = reader.readLine()) == null) break;
            ++linenr;
            if (line.length() == 0) {
                throw new ParseException("Empty line", linenr);
            }
            char first = line.charAt(0);
            if (first == '#') continue;
            if (Character.isLetter(first)) {
                this.set(field, buffer.toString());
                buffer = new StringBuilder();
                int i = line.indexOf(58);
                if (i < 0) {
                    throw new ParseException("Line misses ':' delimiter", linenr);
                }
                field = line.substring(0, i);
                buffer.append(line.substring(i + 1).trim());
                continue;
            }
            buffer.append('\n');
            if (".".equals(line.substring(1).trim())) continue;
            buffer.append(line.substring(1));
        }
        this.set(field, buffer.toString());
        reader.close();
    }

    public void set(String field, String value) {
        if (field != null && this.isUserDefinedField(field)) {
            this.userDefinedFields.put(field, value);
            String fieldName = this.getUserDefinedFieldName(field);
            if (fieldName != null) {
                this.userDefinedFieldNames.add(new ControlField(fieldName));
            }
            field = fieldName;
        }
        if (field != null && !"".equals(field)) {
            this.values.put(field, value);
        }
    }

    public String get(String field) {
        return this.values.get(field);
    }

    protected abstract ControlField[] getFields();

    protected Map<String, String> getUserDefinedFields() {
        return this.userDefinedFields;
    }

    protected Set<ControlField> getUserDefinedFieldNames() {
        return this.userDefinedFieldNames;
    }

    public List<String> getMandatoryFields() {
        ArrayList<String> fields = new ArrayList<String>();
        for (ControlField field : this.getFields()) {
            if (!field.isMandatory()) continue;
            fields.add(field.getName());
        }
        return fields;
    }

    public boolean isValid() {
        return this.invalidFields().size() == 0;
    }

    public Set<String> invalidFields() {
        HashSet<String> invalid = new HashSet<String>();
        for (ControlField field : this.getFields()) {
            if (!field.isMandatory() || this.get(field.getName()) != null) continue;
            invalid.add(field.getName());
        }
        return invalid;
    }

    public String toString(ControlField ... fields) {
        StringBuilder s = new StringBuilder();
        for (ControlField field : fields) {
            String value = this.values.get(field.getName());
            s.append(field.format(value));
        }
        return s.toString();
    }

    public String toString() {
        ArrayList<ControlField> fields = new ArrayList<ControlField>();
        fields.addAll(Arrays.asList(this.getFields()));
        fields.addAll(this.getUserDefinedFieldNames());
        return this.toString(fields.toArray(new ControlField[fields.size()]));
    }

    protected abstract char getUserDefinedFieldLetter();

    protected boolean isUserDefinedField(String field) {
        return field.startsWith("X") && field.indexOf("-") > 0;
    }

    protected String getUserDefinedFieldName(String field) {
        int index = field.indexOf(45);
        char letter = this.getUserDefinedFieldLetter();
        for (int i = 0; i < index; ++i) {
            if (field.charAt(i) != letter) continue;
            return field.substring(index + 1);
        }
        return null;
    }
}

