/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.vafer.jdeb.PackagingException;
import org.vafer.jdeb.changes.ChangesProvider;
import org.vafer.jdeb.debian.BinaryPackageControlFile;
import org.vafer.jdeb.debian.ChangesFile;
import org.vafer.jdeb.shaded.commons.io.FileUtils;
import org.vafer.jdeb.shaded.commons.io.output.NullOutputStream;
import org.vafer.jdeb.utils.InformationOutputStream;

class ChangesFileBuilder {
    private final Long outputTimestampMs;

    ChangesFileBuilder(Long outputTimestampMs) {
        this.outputTimestampMs = outputTimestampMs;
    }

    public ChangesFile createChanges(BinaryPackageControlFile packageControlFile, File binaryPackage, ChangesProvider changesProvider) throws IOException, PackagingException {
        ChangesFile changesFile = new ChangesFile();
        changesFile.setChanges(changesProvider.getChangesSets());
        changesFile.initialize(packageControlFile);
        changesFile.set("Date", this.outputTimestampMs == null ? ChangesFile.formatDate(new Date()) : ChangesFile.formatDateUTC(new Date(this.outputTimestampMs)));
        try {
            InformationOutputStream md5output = new InformationOutputStream(NullOutputStream.INSTANCE, MessageDigest.getInstance("MD5"));
            InformationOutputStream sha1output = new InformationOutputStream(md5output, MessageDigest.getInstance("SHA1"));
            InformationOutputStream sha256output = new InformationOutputStream(sha1output, MessageDigest.getInstance("SHA-256"));
            FileUtils.copyFile(binaryPackage, sha256output);
            changesFile.set("Checksums-Sha1", sha1output.getHexDigest() + " " + binaryPackage.length() + " " + binaryPackage.getName());
            changesFile.set("Checksums-Sha256", sha256output.getHexDigest() + " " + binaryPackage.length() + " " + binaryPackage.getName());
            StringBuilder files = new StringBuilder(md5output.getHexDigest());
            files.append(' ').append(binaryPackage.length());
            files.append(' ').append(packageControlFile.get("Section"));
            files.append(' ').append(packageControlFile.get("Priority"));
            files.append(' ').append(binaryPackage.getName());
            changesFile.set("Files", files.toString());
        }
        catch (NoSuchAlgorithmException e) {
            throw new PackagingException("Unable to compute the checksums for " + binaryPackage, e);
        }
        if (!changesFile.isValid()) {
            throw new PackagingException("Changes file fields are invalid " + changesFile.invalidFields() + ". The following fields are mandatory: " + changesFile.getMandatoryFields() + ". Please check your pom.xml/build.xml and your control file.");
        }
        return changesFile;
    }
}

