/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import org.vafer.jdeb.shaded.bc.crypto.CryptoException;
import org.vafer.jdeb.shaded.bc.crypto.Signer;
import org.vafer.jdeb.shaded.bc.crypto.params.AsymmetricKeyParameter;
import org.vafer.jdeb.shaded.bc.crypto.params.ParametersWithRandom;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPrivateKey;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPContentSigner;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPContentSignerBuilder;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPDigestCalculator;
import org.vafer.jdeb.shaded.bc.openpgp.operator.bc.BcImplProvider;
import org.vafer.jdeb.shaded.bc.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.vafer.jdeb.shaded.bc.openpgp.operator.bc.BcPGPKeyConverter;
import org.vafer.jdeb.shaded.bc.openpgp.operator.bc.SignerOutputStream;
import org.vafer.jdeb.shaded.bc.util.io.TeeOutputStream;

public class BcPGPContentSignerBuilder
implements PGPContentSignerBuilder {
    private BcPGPDigestCalculatorProvider digestCalculatorProvider = new BcPGPDigestCalculatorProvider();
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();
    private int hashAlgorithm;
    private SecureRandom random;
    private int keyAlgorithm;

    public BcPGPContentSignerBuilder(int n, int n2) {
        this.keyAlgorithm = n;
        this.hashAlgorithm = n2;
    }

    public BcPGPContentSignerBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public PGPContentSigner build(final int n, final PGPPrivateKey pGPPrivateKey) throws PGPException {
        AsymmetricKeyParameter asymmetricKeyParameter = this.keyConverter.getPrivateKey(pGPPrivateKey);
        final PGPDigestCalculator pGPDigestCalculator = this.digestCalculatorProvider.get(this.hashAlgorithm);
        final Signer signer = BcImplProvider.createSigner(this.keyAlgorithm, this.hashAlgorithm, asymmetricKeyParameter);
        if (this.random != null) {
            signer.init(true, new ParametersWithRandom(asymmetricKeyParameter, this.random));
        } else {
            signer.init(true, asymmetricKeyParameter);
        }
        return new PGPContentSigner(){

            public int getType() {
                return n;
            }

            public int getHashAlgorithm() {
                return BcPGPContentSignerBuilder.this.hashAlgorithm;
            }

            public int getKeyAlgorithm() {
                return BcPGPContentSignerBuilder.this.keyAlgorithm;
            }

            public long getKeyID() {
                return pGPPrivateKey.getKeyID();
            }

            public OutputStream getOutputStream() {
                return new TeeOutputStream(new SignerOutputStream(signer), pGPDigestCalculator.getOutputStream());
            }

            public byte[] getSignature() {
                try {
                    return signer.generateSignature();
                }
                catch (CryptoException cryptoException) {
                    throw new IllegalStateException("unable to create signature");
                }
            }

            public byte[] getDigest() {
                return pGPDigestCalculator.getDigest();
            }
        };
    }
}

