/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGInputStream;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGObject;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGOutputStream;
import org.vafer.jdeb.shaded.bc.bcpg.ContainedPacket;
import org.vafer.jdeb.shaded.bc.bcpg.DSAPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ECDHPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ECDSAPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.EdDSAPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ElGamalPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.PublicKeyAlgorithmTags;
import org.vafer.jdeb.shaded.bc.bcpg.RSAPublicBCPGKey;

public class PublicKeyPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    private int version;
    private long time;
    private int validDays;
    private int algorithm;
    private BCPGKey key;

    PublicKeyPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this.version = bCPGInputStream.read();
        this.time = (long)bCPGInputStream.read() << 24 | (long)(bCPGInputStream.read() << 16) | (long)(bCPGInputStream.read() << 8) | (long)bCPGInputStream.read();
        if (this.version <= 3) {
            this.validDays = bCPGInputStream.read() << 8 | bCPGInputStream.read();
        }
        this.algorithm = (byte)bCPGInputStream.read();
        switch (this.algorithm) {
            case 1: 
            case 2: 
            case 3: {
                this.key = new RSAPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 17: {
                this.key = new DSAPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 16: 
            case 20: {
                this.key = new ElGamalPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 18: {
                this.key = new ECDHPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 19: {
                this.key = new ECDSAPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 22: {
                this.key = new EdDSAPublicBCPGKey(bCPGInputStream);
                break;
            }
            default: {
                throw new IOException("unknown PGP public key algorithm encountered: " + this.algorithm);
            }
        }
    }

    public PublicKeyPacket(int n, Date date, BCPGKey bCPGKey) {
        this.version = 4;
        this.time = date.getTime() / 1000L;
        this.algorithm = n;
        this.key = bCPGKey;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public int getValidDays() {
        return this.validDays;
    }

    public Date getTime() {
        return new Date(this.time * 1000L);
    }

    public BCPGKey getKey() {
        return this.key;
    }

    public byte[] getEncodedContents() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
        bCPGOutputStream.write(this.version);
        bCPGOutputStream.write((byte)(this.time >> 24));
        bCPGOutputStream.write((byte)(this.time >> 16));
        bCPGOutputStream.write((byte)(this.time >> 8));
        bCPGOutputStream.write((byte)this.time);
        if (this.version <= 3) {
            bCPGOutputStream.write((byte)(this.validDays >> 8));
            bCPGOutputStream.write((byte)this.validDays);
        }
        bCPGOutputStream.write(this.algorithm);
        bCPGOutputStream.writeObject((BCPGObject)((Object)this.key));
        bCPGOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(6, this.getEncodedContents());
    }
}

