/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGInputStream;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGOutputStream;
import org.vafer.jdeb.shaded.bc.bcpg.ContainedPacket;

public class OnePassSignaturePacket
extends ContainedPacket {
    private int version;
    private int sigType;
    private int hashAlgorithm;
    private int keyAlgorithm;
    private long keyID;
    private int nested;

    OnePassSignaturePacket(BCPGInputStream bCPGInputStream) throws IOException {
        this.version = bCPGInputStream.read();
        this.sigType = bCPGInputStream.read();
        this.hashAlgorithm = bCPGInputStream.read();
        this.keyAlgorithm = bCPGInputStream.read();
        this.keyID |= (long)bCPGInputStream.read() << 56;
        this.keyID |= (long)bCPGInputStream.read() << 48;
        this.keyID |= (long)bCPGInputStream.read() << 40;
        this.keyID |= (long)bCPGInputStream.read() << 32;
        this.keyID |= (long)bCPGInputStream.read() << 24;
        this.keyID |= (long)bCPGInputStream.read() << 16;
        this.keyID |= (long)bCPGInputStream.read() << 8;
        this.keyID |= (long)bCPGInputStream.read();
        this.nested = bCPGInputStream.read();
    }

    public OnePassSignaturePacket(int n, int n2, int n3, long l, boolean bl) {
        this.version = 3;
        this.sigType = n;
        this.hashAlgorithm = n2;
        this.keyAlgorithm = n3;
        this.keyID = l;
        this.nested = bl ? 0 : 1;
    }

    public int getSignatureType() {
        return this.sigType;
    }

    public int getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public int getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream2 = new BCPGOutputStream(byteArrayOutputStream);
        bCPGOutputStream2.write(this.version);
        bCPGOutputStream2.write(this.sigType);
        bCPGOutputStream2.write(this.hashAlgorithm);
        bCPGOutputStream2.write(this.keyAlgorithm);
        bCPGOutputStream2.write((byte)(this.keyID >> 56));
        bCPGOutputStream2.write((byte)(this.keyID >> 48));
        bCPGOutputStream2.write((byte)(this.keyID >> 40));
        bCPGOutputStream2.write((byte)(this.keyID >> 32));
        bCPGOutputStream2.write((byte)(this.keyID >> 24));
        bCPGOutputStream2.write((byte)(this.keyID >> 16));
        bCPGOutputStream2.write((byte)(this.keyID >> 8));
        bCPGOutputStream2.write((byte)this.keyID);
        bCPGOutputStream2.write(this.nested);
        bCPGOutputStream2.close();
        bCPGOutputStream.writePacket(4, byteArrayOutputStream.toByteArray());
    }
}

