/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.producers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.producers.AbstractDataProducer;
import org.vafer.jdeb.shaded.commons.compress.archivers.ArchiveEntry;
import org.vafer.jdeb.shaded.commons.compress.archivers.ArchiveException;
import org.vafer.jdeb.shaded.commons.compress.archivers.ArchiveInputStream;
import org.vafer.jdeb.shaded.commons.compress.archivers.ArchiveStreamFactory;
import org.vafer.jdeb.shaded.commons.compress.archivers.tar.TarArchiveEntry;
import org.vafer.jdeb.shaded.commons.compress.archivers.tar.TarArchiveInputStream;
import org.vafer.jdeb.shaded.commons.compress.archivers.zip.ZipArchiveEntry;
import org.vafer.jdeb.shaded.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.vafer.jdeb.shaded.commons.compress.compressors.CompressorException;
import org.vafer.jdeb.shaded.commons.compress.compressors.CompressorInputStream;
import org.vafer.jdeb.shaded.commons.compress.compressors.CompressorStreamFactory;

public final class DataProducerArchive
extends AbstractDataProducer
implements DataProducer {
    private final File archive;

    public DataProducerArchive(File pArchive, String[] pIncludes, String[] pExcludes, Mapper[] pMappers) {
        super(pIncludes, pExcludes, pMappers);
        this.archive = pArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produce(DataConsumer pReceiver) throws IOException {
        EntryConverter converter;
        Object archiveInputStream;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.archive));
        CompressorInputStream compressorInputStream = null;
        try {
            compressorInputStream = new CompressorStreamFactory().createCompressorInputStream(is);
        }
        catch (CompressorException compressorException) {
            // empty catch block
        }
        if (compressorInputStream != null) {
            is = new BufferedInputStream(compressorInputStream);
        }
        try {
            archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream(is);
        }
        catch (ArchiveException e) {
            throw new IOException("Unsupported archive format: " + this.archive, e);
        }
        if (archiveInputStream instanceof TarArchiveInputStream) {
            converter = new EntryConverter(){

                @Override
                public TarArchiveEntry convert(ArchiveEntry entry) {
                    return (TarArchiveEntry)entry;
                }
            };
        } else if (archiveInputStream instanceof ZipArchiveInputStream) {
            converter = new EntryConverter(){

                @Override
                public TarArchiveEntry convert(ArchiveEntry entry) {
                    ZipArchiveEntry src = (ZipArchiveEntry)entry;
                    TarArchiveEntry dst = new TarArchiveEntry(src.getName(), true);
                    dst.setSize(src.getSize());
                    dst.setMode(src.getUnixMode());
                    dst.setModTime(src.getTime());
                    return dst;
                }
            };
        } else {
            throw new IOException("Unsupported archive format: " + this.archive);
        }
        try {
            Object archiveEntry;
            while ((archiveEntry = ((ArchiveInputStream)archiveInputStream).getNextEntry()) != null) {
                if (!this.isIncluded(archiveEntry.getName())) continue;
                TarArchiveEntry entry = converter.convert((ArchiveEntry)archiveEntry);
                if ((entry = this.map(entry)).isSymbolicLink()) {
                    pReceiver.onEachLink(entry);
                    continue;
                }
                if (entry.isDirectory()) {
                    pReceiver.onEachDir(entry);
                    continue;
                }
                pReceiver.onEachFile((InputStream)archiveInputStream, entry);
            }
        }
        finally {
            if (archiveInputStream != null) {
                ((FilterInputStream)archiveInputStream).close();
            }
        }
    }

    private static interface EntryConverter {
        public TarArchiveEntry convert(ArchiveEntry var1);
    }
}

