/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.types.FileSet;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.DebMaker;
import org.vafer.jdeb.PackagingException;
import org.vafer.jdeb.ant.Data;
import org.vafer.jdeb.ant.Link;
import org.vafer.jdeb.ant.TaskConsole;
import org.vafer.jdeb.producers.DataProducerFileSet;
import org.vafer.jdeb.utils.OutputTimestampResolver;

public class DebAntTask
extends MatchingTask {
    private File deb;
    private File control;
    private String encoding;
    private File keyring;
    private String key;
    private String passphrase;
    private File changesIn;
    private File changesOut;
    private File changesSave;
    private boolean changesEnabled = true;
    private String compression = "gzip";
    private String digest = "SHA256";
    private boolean verbose;
    private Collection<Link> links = new ArrayList<Link>();
    private Collection<DataProducer> dataProducers = new ArrayList<DataProducer>();
    private Collection<DataProducer> conffilesProducers = new ArrayList<DataProducer>();

    public void setDestfile(File deb) {
        this.deb = deb;
    }

    public void setControl(File control) {
        this.control = control;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setChangesIn(File changes) {
        this.changesIn = changes;
    }

    public void setChangesOut(File changes) {
        this.changesOut = changes;
    }

    public void setChangesSave(File changes) {
        this.changesSave = changes;
    }

    public void setKeyring(File keyring) {
        this.keyring = keyring;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void addFileSet(FileSet fileset) {
        this.dataProducers.add(new DataProducerFileSet(fileset));
    }

    public void addTarFileSet(Tar.TarFileSet fileset) {
        this.dataProducers.add(new DataProducerFileSet((FileSet)fileset));
    }

    public void addData(Data data) {
        this.dataProducers.add(data);
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public void execute() {
        for (Link link : this.links) {
            this.dataProducers.add(link.toDataProducer());
        }
        for (DataProducer dataProducer : this.dataProducers) {
            if (!(dataProducer instanceof Data)) continue;
            Data data = (Data)dataProducer;
            if (data.getType() == null) {
                throw new BuildException("The type of the data element wasn't specified (expected 'file', 'directory' or 'archive')");
            }
            if (!Arrays.asList("file", "directory", "archive").contains(data.getType().toLowerCase())) {
                throw new BuildException("The type '" + data.getType() + "' of the data element is unknown (expected 'file', 'directory' or 'archive')");
            }
            if (data.getConffile() == null || !data.getConffile().booleanValue()) continue;
            this.conffilesProducers.add(dataProducer);
        }
        TaskConsole console = new TaskConsole((Task)this, this.verbose);
        DebMaker debMaker = new DebMaker(console, this.dataProducers, this.conffilesProducers);
        debMaker.setDeb(this.deb);
        debMaker.setControl(this.control);
        debMaker.setEncoding(this.encoding);
        debMaker.setChangesIn(this.changesIn);
        debMaker.setChangesOut(this.changesOut);
        debMaker.setChangesSave(this.changesSave);
        debMaker.setChangesEnabled(this.changesEnabled);
        debMaker.setKeyring(this.keyring);
        debMaker.setKey(this.key);
        debMaker.setPassphrase(this.passphrase);
        debMaker.setCompression(this.compression);
        debMaker.setDigest(this.digest);
        Long outputTimestampMs = new OutputTimestampResolver(console).resolveOutputTimestamp(null);
        debMaker.setOutputTimestampMs(outputTimestampMs);
        try {
            debMaker.validate();
            debMaker.makeDeb();
        }
        catch (PackagingException e) {
            this.log("Failed to create the Debian package " + this.deb, e, 0);
            throw new BuildException("Failed to create the Debian package " + this.deb, (Throwable)e);
        }
    }
}

