/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public final class InformationInputStream
extends FilterInputStream {
    private long i;
    private long ascii;
    private long nonascii;
    private long cr;
    private long lf;
    private long zero;
    private final Map<BOM, Integer> bomPositions = new HashMap<BOM, Integer>();
    private final Map<Shell, Integer> shellPositions = new HashMap<Shell, Integer>();
    private BOM bom = BOM.NONE;
    private Shell shell = Shell.NONE;

    public InformationInputStream(InputStream in) {
        super(in);
    }

    public boolean hasBom() {
        return this.bom != BOM.NONE;
    }

    public boolean isShell() {
        return this.shell != Shell.NONE;
    }

    public boolean hasUnixLineEndings() {
        return this.cr == 0L;
    }

    public String getEncoding() {
        String encoding = this.bom.encoding;
        if (encoding == null) {
            if (this.shell == Shell.UTF16BE) {
                encoding = BOM.UTF16BE.encoding;
            } else if (this.shell == Shell.UTF16LE) {
                encoding = BOM.UTF16LE.encoding;
            }
        }
        return encoding;
    }

    private void add(int c) {
        if (this.i < 10L) {
            int position;
            if (this.shell == Shell.NONE) {
                for (Enum enum_ : Shell.values()) {
                    int n = position = this.shellPositions.containsKey(enum_) ? this.shellPositions.get(enum_) : 0;
                    if (position < ((Shell)enum_).header.length) {
                        if (c == ((Shell)enum_).header[position]) {
                            this.shellPositions.put((Shell)enum_, position + 1);
                            continue;
                        }
                        this.shellPositions.put((Shell)enum_, 0);
                        continue;
                    }
                    this.shell = enum_;
                }
            }
            if (this.bom == BOM.NONE) {
                for (Enum enum_ : BOM.values()) {
                    int n = position = this.bomPositions.containsKey(enum_) ? this.bomPositions.get(enum_) : 0;
                    if (position < ((BOM)enum_).sequence.length) {
                        if (c == ((BOM)enum_).sequence[position] && (long)position == this.i) {
                            this.bomPositions.put((BOM)enum_, position + 1);
                            continue;
                        }
                        this.bomPositions.put((BOM)enum_, 0);
                        continue;
                    }
                    this.bom = enum_;
                }
            }
        }
        ++this.i;
        if (c == 10) {
            ++this.lf;
            return;
        }
        if (c == 13) {
            ++this.cr;
            return;
        }
        if (c >= 32 && c <= 126) {
            ++this.ascii;
            return;
        }
        if (c == 0) {
            ++this.zero;
            return;
        }
        ++this.nonascii;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b != -1) {
            this.add(b & 0xFF);
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int length = super.read(b, off, len);
        for (int i = 0; i < length; ++i) {
            this.add(b[off + i] & 0xFF);
        }
        return length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("total=").append(this.i);
        sb.append(",noascii=").append(this.nonascii);
        sb.append(",ascii=").append(this.ascii);
        sb.append(",cr=").append(this.cr);
        sb.append(",lf=").append(this.lf);
        sb.append(",zero=").append(this.zero);
        sb.append("}");
        return sb.toString();
    }

    private static enum BOM {
        NONE(null, new int[0]),
        UTF8("UTF-8", 239, 187, 191),
        UTF16LE("UTF-16LE", 255, 254),
        UTF16BE("UTF-16BE", 254, 255);

        int[] sequence;
        String encoding;

        private BOM(String encoding, int ... sequence) {
            this.encoding = encoding;
            this.sequence = sequence;
        }
    }

    private static enum Shell {
        NONE(new int[0]),
        ASCII(35, 33),
        UTF16BE(0, 35, 0, 33),
        UTF16LE(35, 0, 33, 0);

        int[] header;

        private Shell(int ... header) {
            this.header = header;
        }
    }
}

