/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import org.vafer.jdeb.Console;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.TarOptions;
import org.vafer.jdeb.shaded.commons.compress.archivers.tar.TarArchiveEntry;
import org.vafer.jdeb.shaded.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.vafer.jdeb.shaded.commons.compress.archivers.zip.ZipEncoding;
import org.vafer.jdeb.shaded.commons.compress.archivers.zip.ZipEncodingHelper;
import org.vafer.jdeb.shaded.commons.compress.compressors.CompressorException;
import org.vafer.jdeb.utils.Utils;

class DataBuilder {
    private Console console;
    private ZipEncoding encoding;
    private final Long outputTimestampMs;

    DataBuilder(Console console, Long outputTimestampMs) {
        this.console = console;
        this.encoding = ZipEncodingHelper.getZipEncoding(null);
        this.outputTimestampMs = outputTimestampMs;
    }

    private void checkField(String name, int length) throws IOException {
        ByteBuffer b;
        if (name != null && (b = this.encoding.encode(name)).limit() > length) {
            throw new IllegalArgumentException("Field '" + name + "' too long, maximum is " + length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BigInteger buildData(Collection<DataProducer> producers, File output, final StringBuilder checksums, TarOptions options) throws NoSuchAlgorithmException, IOException, CompressorException {
        File dir = output.getParentFile();
        if (!(dir == null || dir.exists() && dir.isDirectory())) {
            throw new IOException("Cannot write data file at '" + output.getAbsolutePath() + "'");
        }
        final TarArchiveOutputStream tarOutputStream = new TarArchiveOutputStream(options.compression().toCompressedOutputStream(new FileOutputStream(output)));
        tarOutputStream.setLongFileMode(options.longFileMode());
        tarOutputStream.setBigNumberMode(options.bigNumberMode());
        final MessageDigest digest = MessageDigest.getInstance("MD5");
        final Total dataSize = new Total();
        final ArrayList addedDirectories = new ArrayList();
        DataConsumer receiver = new DataConsumer(){

            @Override
            public void onEachDir(TarArchiveEntry dirEntry) throws IOException {
                DataBuilder.this.checkField(dirEntry.getLinkName(), 100);
                DataBuilder.this.checkField(dirEntry.getUserName(), 32);
                DataBuilder.this.checkField(dirEntry.getUserName(), 32);
                dirEntry.setName(DataBuilder.this.fixPathTar(dirEntry.getName()));
                this.createParentDirectories(dirEntry.getName(), dirEntry.getUserName(), dirEntry.getLongUserId(), dirEntry.getGroupName(), dirEntry.getLongGroupId());
                this.createDirectory(dirEntry.getName(), dirEntry.getUserName(), dirEntry.getLongUserId(), dirEntry.getGroupName(), dirEntry.getLongGroupId(), dirEntry.getMode(), 0L);
                DataBuilder.this.console.debug("dir: " + dirEntry.getName());
            }

            @Override
            public void onEachFile(InputStream input, TarArchiveEntry fileEntry) throws IOException {
                DataBuilder.this.checkField(fileEntry.getLinkName(), 100);
                DataBuilder.this.checkField(fileEntry.getUserName(), 32);
                DataBuilder.this.checkField(fileEntry.getGroupName(), 32);
                String rawFileEntryName = fileEntry.getName();
                fileEntry.setName(DataBuilder.this.fixPathTar(fileEntry.getName()));
                if (DataBuilder.this.outputTimestampMs != null) {
                    fileEntry.setModTime(DataBuilder.this.outputTimestampMs);
                }
                this.createParentDirectories(fileEntry.getName(), fileEntry.getUserName(), fileEntry.getLongUserId(), fileEntry.getGroupName(), fileEntry.getLongGroupId());
                tarOutputStream.putArchiveEntry(fileEntry);
                dataSize.add(fileEntry.getSize());
                digest.reset();
                Utils.copy(input, new DigestOutputStream(tarOutputStream, digest));
                String md5 = Utils.toHex(digest.digest());
                tarOutputStream.closeArchiveEntry();
                DataBuilder.this.console.debug("file:" + fileEntry.getName() + " size:" + fileEntry.getSize() + " mode:" + fileEntry.getMode() + " linkname:" + fileEntry.getLinkName() + " username:" + fileEntry.getUserName() + " userid:" + fileEntry.getLongUserId() + " groupname:" + fileEntry.getGroupName() + " groupid:" + fileEntry.getLongGroupId() + " modtime:" + fileEntry.getModTime() + " md5: " + md5);
                checksums.append(md5).append("  ").append(DataBuilder.this.fixPathMd5(rawFileEntryName)).append('\n');
            }

            @Override
            public void onEachLink(TarArchiveEntry entry) throws IOException {
                DataBuilder.this.checkField(entry.getUserName(), 32);
                DataBuilder.this.checkField(entry.getGroupName(), 32);
                entry.setName(DataBuilder.this.fixPathTar(entry.getName()));
                if (DataBuilder.this.outputTimestampMs != null) {
                    entry.setModTime(DataBuilder.this.outputTimestampMs);
                }
                this.createParentDirectories(entry.getName(), entry.getUserName(), entry.getLongUserId(), entry.getGroupName(), entry.getLongGroupId());
                tarOutputStream.putArchiveEntry(entry);
                tarOutputStream.closeArchiveEntry();
                DataBuilder.this.console.debug("link:" + entry.getName() + " mode:" + entry.getMode() + " linkname:" + entry.getLinkName() + " username:" + entry.getUserName() + " userid:" + entry.getLongUserId() + " groupname:" + entry.getGroupName() + " groupid:" + entry.getLongGroupId());
            }

            private void createDirectory(String directory, String user, long uid, String group, long gid, int mode, long size) throws IOException {
                if (!directory.endsWith("/")) {
                    directory = directory + "/";
                }
                if (!addedDirectories.contains(directory)) {
                    TarArchiveEntry entry = new TarArchiveEntry(directory, true);
                    entry.setUserName(user);
                    entry.setUserId(uid);
                    entry.setGroupName(group);
                    entry.setGroupId(gid);
                    entry.setMode(mode);
                    entry.setSize(size);
                    if (DataBuilder.this.outputTimestampMs != null) {
                        entry.setModTime(DataBuilder.this.outputTimestampMs);
                    }
                    tarOutputStream.putArchiveEntry(entry);
                    tarOutputStream.closeArchiveEntry();
                    addedDirectories.add(directory);
                }
            }

            private void createParentDirectories(String filename, String user, long uid, String group, long gid) throws IOException {
                String dirname = DataBuilder.this.fixPathTar(new File(filename).getParent());
                if (dirname == null) {
                    return;
                }
                String[] pathParts = dirname.split("/");
                String parentDir = "./";
                for (int i = 1; i < pathParts.length; ++i) {
                    parentDir = parentDir + pathParts[i] + "/";
                    int mode = 16877;
                    this.createDirectory(parentDir, user, uid, group, gid, mode, 0L);
                }
            }
        };
        try {
            for (DataProducer data : producers) {
                data.produce(receiver);
            }
        }
        finally {
            tarOutputStream.close();
        }
        this.console.debug("Total size: " + dataSize);
        return dataSize.count;
    }

    private String fixPathBase(String path) {
        if (path == null || path.equals(".")) {
            return path;
        }
        if (path.contains("\\")) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    private String fixPathTar(String path) {
        if (path == null || path.equals(".")) {
            return path;
        }
        if ((path = this.fixPathBase(path)).startsWith("/")) {
            path = "." + path;
        } else if (!path.startsWith("./")) {
            path = "./" + path;
        }
        return path;
    }

    private String fixPathMd5(String path) {
        if (path == null || path.equals(".")) {
            return path;
        }
        if ((path = this.fixPathBase(path)).startsWith("/")) {
            path = path.substring(1);
        } else if (path.startsWith("./")) {
            path = path.substring(2);
        }
        return path;
    }

    private static final class Total {
        private BigInteger count = BigInteger.valueOf(0L);

        private Total() {
        }

        public void add(long size) {
            this.count = this.count.add(BigInteger.valueOf(size));
        }

        public String toString() {
            return "" + this.count;
        }
    }
}

