/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util.sort;

import java.util.Comparator;
import org.unix4j.util.StringUtil;

public class ScientificNumberStringComparator
implements Comparator<CharSequence> {
    public static final ScientificNumberStringComparator INSTANCE = new ScientificNumberStringComparator();

    private ScientificNumberStringComparator() {
    }

    @Override
    public int compare(CharSequence s1, CharSequence s2) {
        int start1 = StringUtil.findStartTrimWhitespace(s1);
        int end1 = StringUtil.findEndTrimWhitespace(s1);
        int start2 = StringUtil.findStartTrimWhitespace(s2);
        int end2 = StringUtil.findEndTrimWhitespace(s2);
        String str1 = s1.subSequence(start1, end1).toString();
        String str2 = s2.subSequence(start2, end2).toString();
        double dbl1 = ScientificNumberStringComparator.parseDouble(str1);
        double dbl2 = ScientificNumberStringComparator.parseDouble(str2);
        boolean isNan1 = Double.isNaN(dbl1);
        boolean isNan2 = Double.isNaN(dbl2);
        if (isNan1 || isNan2) {
            boolean isNonDouble2;
            boolean isNonDouble1 = isNan1 && !"NaN".equals(str1);
            boolean bl = isNonDouble2 = isNan2 && !"NaN".equals(str2);
            if (isNonDouble1 && isNonDouble2) {
                return str1.compareTo(str2);
            }
            if (isNonDouble1) {
                return -1;
            }
            if (isNonDouble2) {
                return 1;
            }
        }
        return Double.compare(dbl1, dbl2);
    }

    private static double parseDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }
}

