/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util.sort;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class CompositeComparator<T>
implements Comparator<T> {
    private final List<Comparator<? super T>> comparators;

    public CompositeComparator(Comparator<? super T> ... comparators) {
        this(Arrays.asList(comparators));
    }

    public CompositeComparator(Comparator<? super T> comparator1, Comparator<? super T> comparator2) {
        this(new Comparator[]{comparator1, comparator2});
    }

    public CompositeComparator(Comparator<? super T> comparator1, Comparator<? super T> comparator2, Comparator<? super T> comparator3) {
        this(new Comparator[]{comparator1, comparator2, comparator3});
    }

    public CompositeComparator(List<Comparator<? super T>> comparators) {
        this.comparators = comparators;
    }

    @Override
    public int compare(T o1, T o2) {
        for (Comparator<T> comparator : this.comparators) {
            int cmp = comparator.compare(o1, o2);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

