/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util;

import java.io.File;
import java.util.List;
import org.unix4j.util.FileUtil;

public class RelativePathBase {
    public static final Settings DEFAULT = new Settings(){

        @Override
        public StringBuilder appendPathForBaseDir(StringBuilder result, File baseDir) {
            return result.append('.');
        }

        @Override
        public StringBuilder appendPrefixForChildren(StringBuilder result, File baseDir, boolean directChildOfBase) {
            if (directChildOfBase) {
                return result;
            }
            return result.append("./");
        }

        @Override
        public StringBuilder appendPrefixToCommonAncestor(StringBuilder result, File baseDir, int levelsToCommonAncestor) {
            for (int i = 0; i < levelsToCommonAncestor; ++i) {
                result.append("../");
            }
            return result;
        }
    };
    public static final Settings ALL_CHILDREN_WITH_DOT_PREFIX = new Settings(){

        @Override
        public StringBuilder appendPathForBaseDir(StringBuilder result, File baseDir) {
            return result.append('.');
        }

        @Override
        public StringBuilder appendPrefixForChildren(StringBuilder result, File baseDir, boolean directChildOfBase) {
            return result.append("./");
        }

        @Override
        public StringBuilder appendPrefixToCommonAncestor(StringBuilder result, File baseDir, int levelsToCommonAncestor) {
            for (int i = 0; i < levelsToCommonAncestor; ++i) {
                result.append("../");
            }
            return result;
        }
    };
    public static final Settings CHILDREN_WITHOUT_PREFIX = new Settings(){

        @Override
        public StringBuilder appendPathForBaseDir(StringBuilder result, File baseDir) {
            return result.append('.');
        }

        @Override
        public StringBuilder appendPrefixForChildren(StringBuilder result, File baseDir, boolean directChildOfBase) {
            return result;
        }

        @Override
        public StringBuilder appendPrefixToCommonAncestor(StringBuilder result, File baseDir, int levelsToCommonAncestor) {
            for (int i = 0; i < levelsToCommonAncestor; ++i) {
                result.append("../");
            }
            return result;
        }
    };
    private final File base;
    private final Settings settings;

    public RelativePathBase(String base) {
        this(new File(base));
    }

    public RelativePathBase(File base) {
        this(base, DEFAULT);
    }

    public RelativePathBase(String base, Settings settings) {
        this(new File(base), settings);
    }

    public RelativePathBase(File base, Settings settings) {
        this.base = base;
        this.settings = settings;
    }

    public File getBase() {
        return this.base;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public String getRelativePathFor(File file) {
        int common;
        StringBuilder path = new StringBuilder();
        if (this.base.equals(file)) {
            return this.settings.appendPathForBaseDir(path, file).toString();
        }
        if (this.base.equals(file.getParentFile())) {
            return this.settings.appendPrefixForChildren(path, this.base, true).append(file.getName()).toString();
        }
        List<String> baseParts = FileUtil.getPathElements(this.base);
        List<String> fileParts = FileUtil.getPathElements(file);
        int len = Math.min(baseParts.size(), fileParts.size());
        for (common = 0; common < len && baseParts.get(common).equals(fileParts.get(common)); ++common) {
        }
        if (common == 0) {
            return file.getAbsolutePath().replace('\\', '/');
        }
        if (common < baseParts.size()) {
            this.settings.appendPrefixToCommonAncestor(path, this.base, baseParts.size() - common);
        } else {
            this.settings.appendPrefixForChildren(path, this.base, false);
        }
        for (int i = common; i < fileParts.size(); ++i) {
            path.append(fileParts.get(i)).append('/');
        }
        return path.deleteCharAt(path.length() - 1).toString();
    }

    public String getRelativePathFor(String file) {
        return this.getRelativePathFor(new File(file));
    }

    public static interface Settings {
        public StringBuilder appendPathForBaseDir(StringBuilder var1, File var2);

        public StringBuilder appendPrefixForChildren(StringBuilder var1, File var2, boolean var3);

        public StringBuilder appendPrefixToCommonAncestor(StringBuilder var1, File var2, int var3);
    }
}

