/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.convert;

import org.unix4j.convert.ValueConverter;

public class EnumConverters {

    public static class StringToEnumConverter<E extends Enum<E>>
    implements ValueConverter<E> {
        private final Class<E> enumClass;

        public StringToEnumConverter(Class<E> enumClass) {
            this.enumClass = enumClass;
        }

        @Override
        public E convert(Object value) throws IllegalArgumentException {
            if (value != null) {
                String name = value.toString();
                try {
                    return Enum.valueOf(this.enumClass, name);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            return null;
        }
    }
}

