/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.report.impl;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import org.unitils.mock.core.ObservedInvocation;
import org.unitils.util.ReflectionUtils;

public class SuggestedAssertsReport {
    public String createReport(Object testObject, List<ObservedInvocation> observedInvocations) {
        StringBuilder result = new StringBuilder();
        for (ObservedInvocation mockInvocation : observedInvocations) {
            if (!Void.TYPE.equals(mockInvocation.getMethod().getReturnType())) continue;
            result.append(this.getSuggestedAssertStatement(testObject, mockInvocation));
            result.append("\n");
        }
        return result.toString();
    }

    protected String getSuggestedAssertStatement(Object testObject, ObservedInvocation observedInvocation) {
        StringBuilder result = new StringBuilder();
        result.append(this.formatMockName(observedInvocation));
        result.append(".assertInvoked().");
        result.append(observedInvocation.getMethod().getName());
        result.append("(");
        boolean firstArgument = true;
        for (Object argument : observedInvocation.getArguments()) {
            String testObjectFieldName = this.getFieldName(testObject, argument);
            if (!firstArgument) {
                result.append(", ");
            } else {
                firstArgument = false;
            }
            if (testObjectFieldName != null) {
                result.append(testObjectFieldName);
                continue;
            }
            result.append(this.getSuggestedArgument(argument));
        }
        result.append(");");
        return result.toString();
    }

    protected String getSuggestedArgument(Object argument) {
        if (argument == null) {
            return "null";
        }
        if (argument instanceof String) {
            return "\"" + argument + "\"";
        }
        if (argument instanceof Number) {
            return argument.toString();
        }
        if (argument instanceof Character) {
            return "'" + argument + "'";
        }
        return "null";
    }

    protected String getFieldName(Object testObject, Object value) {
        if (testObject == null) {
            return null;
        }
        Set fields = ReflectionUtils.getAllFields(testObject.getClass());
        for (Field field : fields) {
            Object fieldValue = ReflectionUtils.getFieldValue((Object)testObject, (Field)field);
            if (value != fieldValue) continue;
            return field.getName();
        }
        return null;
    }

    protected String formatMockName(ObservedInvocation observedInvocation) {
        String mockName = observedInvocation.getMockName();
        return mockName.replaceAll("##chained##", ".");
    }
}

